module Paths_fgl (
	version,
	getBinDir, getLibDir, getDataDir, getLibexecDir,
	getDataFileName
	) where

import Data.Version

version = Version {versionBranch = [5,3], versionTags = []}

bindir     = "/opt/local/bin"
libdir     = "/opt/local/lib/hugs/packages/fgl"
datadir    = "/opt/local/share/fgl-5.3"
libexecdir = "/opt/local/libexec"

getBinDir, getLibDir, getDataDir, getLibexecDir :: IO FilePath
getBinDir = return bindir
getLibDir = return libdir
getDataDir = return datadir
getLibexecDir = return libexecdir

getDataFileName :: FilePath -> IO FilePath
getDataFileName name = return (datadir ++ "/" ++ name)
