//
// ********************************************************************
// * License and Disclaimer                                           *
// *                                                                  *
// * The  Geant4 software  is  copyright of the Copyright Holders  of *
// * the Geant4 Collaboration.  It is provided  under  the terms  and *
// * conditions of the Geant4 Software License,  included in the file *
// * LICENSE and available at  http://cern.ch/geant4/license .  These *
// * include a list of copyright holders.                             *
// *                                                                  *
// * Neither the authors of this software system, nor their employing *
// * institutes,nor the agencies providing financial support for this *
// * work  make  any representation or  warranty, express or implied, *
// * regarding  this  software system or assume any liability for its *
// * use.  Please see the license in the file  LICENSE  and URL above *
// * for the full disclaimer and the limitation of liability.         *
// *                                                                  *
// * This  code  implementation is the result of  the  scientific and *
// * technical work of the GEANT4 collaboration.                      *
// * By using,  copying,  modifying or  distributing the software (or *
// * any work based  on the software)  you  agree  to acknowledge its *
// * use  in  resulting  scientific  publications,  and indicate your *
// * acceptance of all terms of the Geant4 Software license.          *
// ********************************************************************
//
/// \file RE06/include/RE06PrimaryGeneratorAction.hh
/// \brief Definition of the RE06PrimaryGeneratorAction class
//
// $Id: RE06PrimaryGeneratorAction.hh 66526 2012-12-19 13:41:33Z ihrivnac $
//

#ifndef RE06PrimaryGeneratorAction_h
#define RE06PrimaryGeneratorAction_h 1

#include "G4VUserPrimaryGeneratorAction.hh"
#include "globals.hh"

class G4ParticleGun;
class G4Event;

class RE06PrimaryGeneratorAction : public G4VUserPrimaryGeneratorAction
{
  public:
    RE06PrimaryGeneratorAction();    
    virtual ~RE06PrimaryGeneratorAction();

    virtual void GeneratePrimaries(G4Event*);

    void SetSerial(G4bool serial) { fSerial = serial; }

  private:
    G4ParticleGun* fParticleGun;
    G4bool         fSerial;
};


#endif


