(make-package :compiler :use '(:lisp :si))
(make-package :sloop :use '(:lisp))
(make-package :ansi-loop :use'(:lisp))
(make-package :defpackage :use '(:lisp))
(make-package :tk :use '(:lisp :sloop))
(make-package :fpe :use '(:lisp))
(make-package :cltl1-compat)

(in-package :system)
(use-package :fpe)

(init-system) 
(in-package :si)
(gbc t)

(unless *link-array*
  (setq *link-array* (make-array (ash 1 11) :element-type 'character :fill-pointer 0)))
(use-fast-links t)

(let* ((x (append (pathname-directory *system-directory*) (list :back)))
       (lsp (append x (list "lsp")))
       (cmpnew (append x (list "cmpnew")))
       (h (append x (list "h")))
       (xgcl-2 (append x (list "xgcl-2")))
       (pcl (append x (list "pcl")))
       (clcs (append x (list "clcs")))
       (gtk (append x (list "gcl-tk"))))
  (dolist (d (list lsp cmpnew #+(and xgcl (not pre-gcl)) xgcl-2 #+(or pcl ansi-cl) pcl #+ansi-cl clcs))
    (load (make-pathname :name "sys-proclaim" :type "lisp" :directory d)))
  (load (make-pathname :name "tk-package" :type "lsp" :directory gtk))
  (load (make-pathname :name "gcl_lfun_list" :type "lsp" :directory cmpnew))
  (load (make-pathname :name "gcl_cmpopt" :type "lsp" :directory cmpnew))
  (load (make-pathname :name "gcl_auto_new" :type "lsp" :directory lsp))
  
  (gbc t))

(setf (symbol-function 'clear-compiler-properties)
      (symbol-function 'compiler::compiler-clear-compiler-properties))

(terpri)
(setq *inhibit-macro-special* t)
(gbc t)
(reset-gbc-count)

(defun top-level nil (gcl-top-level))

(set-up-top-level)

(setq *gcl-extra-version* 14
      *gcl-minor-version* 6 
      *gcl-major-version* 2
      *gcl-git-tag* "Version_2_6_14"
      *gcl-release-date*  "Fri Jan 13 10:47:56 AM EST 2023")

(defvar *system-banner* (default-system-banner))
(setq *optimize-maximum-pages* t)

(fmakunbound 'init-cmp-anon)
(when (fboundp 'user-init) (user-init))

(in-package :compiler)
(setq *cc* "clang  -std=gnu11 -c -pipe -Os -arch x86_64 -fsigned-char -pipe -fcommon -fno-builtin-malloc -fno-builtin-free -fno-PIE -fno-pie -fno-PIC -fno-pic -Wall -Wno-builtin-requires-header -Wno-empty-body -Wno-self-assign -m64 -I/opt/local/include"
      *default-prof-p* (> (length "") 0)
      *ld* "clang  -std=gnu11 -L/opt/local/lib -Wl,-headerpad_max_install_names -arch x86_64 -Wl,-no_pie -m64 -Wl,-headerpad,72 -o "
      *ld-libs* " -lm -lgmp -lreadline -lc -lgclp"
      *ld-libs* (concatenate 'string "-l" #+ansi-cl "ansi_" "gcl " *ld-libs*)
      *opt-three* "-O3 -fomit-frame-pointer"
      *opt-two* "-O"
      *init-lsp* "sys_init.lsp")

(import 'si::(clines defentry defcfun object void int double quit bye gbc system
		     commonp *break-on-warnings* make-char char-bits char-font
		     char-bit set-char-bit string-char-p int-char
		     char-font-limit char-bits-limit char-control-bit
		     char-meta-bit char-super-bit char-hyper-bit compiler-let) :cltl1-compat)
(deftype cltl1-compat::string-char nil 'character)
(do-symbols (s :cltl1-compat) (export s :cltl1-compat))

#-ansi-cl(use-package :cltl1-compat :lisp)
#-ansi-cl(do-symbols (s :cltl1-compat) (export s :lisp)))

#+ansi-cl (use-package :pcl :user)

(import 'si::(clines defentry defcfun object void int double quit bye gbc system
		     *lib-directory* *system-directory* while help) :user)

(let* ((i 4096)(j (si::equal-tail-recursion-check i)))
  (unless (<= (ash i -1) j)
    (warn "equal is not tail recursive ~s ~s" i j)))

(format t "~s heap words available~%" (multiple-value-bind (a b c d) (si::heap-report) (/ (- d c) (/ a 8))))
