/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.tree;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.plaf.UIResource;
import javax.swing.tree.TreeCellRenderer;

public class DefaultTreeCellRenderer
extends JLabel
implements TreeCellRenderer {
    protected boolean selected;
    protected boolean hasFocus;
    private boolean drawsFocusBorderAroundIcon;
    protected transient Icon closedIcon;
    protected transient Icon leafIcon;
    protected transient Icon openIcon;
    protected Color textSelectionColor;
    protected Color textNonSelectionColor;
    protected Color backgroundSelectionColor;
    protected Color backgroundNonSelectionColor;
    protected Color borderSelectionColor;

    public DefaultTreeCellRenderer() {
        this.setLeafIcon(this.getDefaultLeafIcon());
        this.setOpenIcon(this.getDefaultOpenIcon());
        this.setClosedIcon(this.getDefaultClosedIcon());
        this.setTextNonSelectionColor(UIManager.getColor("Tree.textForeground"));
        this.setTextSelectionColor(UIManager.getColor("Tree.selectionForeground"));
        this.setBackgroundNonSelectionColor(UIManager.getColor("Tree.textBackground"));
        this.setBackgroundSelectionColor(UIManager.getColor("Tree.selectionBackground"));
        this.setBorderSelectionColor(UIManager.getColor("Tree.selectionBorderColor"));
        Object val = UIManager.get("Tree.drawsFocusBorderAroundIcon");
        this.drawsFocusBorderAroundIcon = val != null && (Boolean)val != false;
    }

    public Icon getDefaultOpenIcon() {
        return UIManager.getIcon("Tree.openIcon");
    }

    public Icon getDefaultClosedIcon() {
        return UIManager.getIcon("Tree.closedIcon");
    }

    public Icon getDefaultLeafIcon() {
        return UIManager.getIcon("Tree.leafIcon");
    }

    public void setOpenIcon(Icon icon) {
        this.openIcon = icon;
    }

    public Icon getOpenIcon() {
        return this.openIcon;
    }

    public void setClosedIcon(Icon icon) {
        this.closedIcon = icon;
    }

    public Icon getClosedIcon() {
        return this.closedIcon;
    }

    public void setLeafIcon(Icon icon) {
        this.leafIcon = icon;
    }

    public Icon getLeafIcon() {
        return this.leafIcon;
    }

    public void setTextSelectionColor(Color c) {
        this.textSelectionColor = c;
    }

    public Color getTextSelectionColor() {
        return this.textSelectionColor;
    }

    public void setTextNonSelectionColor(Color c) {
        this.textNonSelectionColor = c;
    }

    public Color getTextNonSelectionColor() {
        return this.textNonSelectionColor;
    }

    public void setBackgroundSelectionColor(Color c) {
        this.backgroundSelectionColor = c;
    }

    public Color getBackgroundSelectionColor() {
        return this.backgroundSelectionColor;
    }

    public void setBackgroundNonSelectionColor(Color c) {
        this.backgroundNonSelectionColor = c;
    }

    public Color getBackgroundNonSelectionColor() {
        return this.backgroundNonSelectionColor;
    }

    public void setBorderSelectionColor(Color c) {
        this.borderSelectionColor = c;
    }

    public Color getBorderSelectionColor() {
        return this.borderSelectionColor;
    }

    public void setFont(Font f) {
        if (f != null && f instanceof UIResource) {
            f = null;
        }
        super.setFont(f);
    }

    public void setBackground(Color c) {
        if (c != null && c instanceof UIResource) {
            c = null;
        }
        super.setBackground(c);
    }

    public Component getTreeCellRendererComponent(JTree tree, Object val, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        if (leaf) {
            this.setIcon(this.getLeafIcon());
        } else if (expanded) {
            this.setIcon(this.getOpenIcon());
        } else {
            this.setIcon(this.getClosedIcon());
        }
        this.setText(val.toString());
        this.selected = selected;
        this.hasFocus = hasFocus;
        this.setHorizontalAlignment(2);
        this.setOpaque(false);
        this.setVerticalAlignment(0);
        this.setEnabled(true);
        super.setFont(UIManager.getFont("Tree.font"));
        if (selected) {
            super.setBackground(this.getBackgroundSelectionColor());
            this.setForeground(this.getTextSelectionColor());
            if (hasFocus) {
                this.setBorderSelectionColor(UIManager.getLookAndFeelDefaults().getColor("Tree.selectionBorderColor"));
            } else {
                this.setBorderSelectionColor(null);
            }
        } else {
            super.setBackground(this.getBackgroundNonSelectionColor());
            this.setForeground(this.getTextNonSelectionColor());
            this.setBorderSelectionColor(null);
        }
        return this;
    }

    public Font getFont() {
        return super.getFont();
    }

    public void paint(Graphics g) {
        Color bgColor;
        if (this.selected) {
            bgColor = this.getBackgroundSelectionColor();
        } else {
            bgColor = this.getBackgroundNonSelectionColor();
            if (bgColor == null) {
                bgColor = this.getBackground();
            }
        }
        int xOffset = -1;
        if (bgColor != null) {
            this.getIcon();
            xOffset = this.getXOffset();
            g.setColor(bgColor);
            g.fillRect(xOffset, 0, this.getWidth() - xOffset, this.getHeight());
        }
        if (this.hasFocus) {
            if (this.drawsFocusBorderAroundIcon) {
                xOffset = 0;
            } else if (xOffset == -1) {
                xOffset = this.getXOffset();
            }
            this.paintFocus(g, xOffset, 0, this.getWidth() - xOffset, this.getHeight());
        }
        super.paint(g);
    }

    private void paintFocus(Graphics g, int x, int y, int w, int h) {
        Color col = this.getBorderSelectionColor();
        if (col != null) {
            g.setColor(col);
            g.drawRect(x, y, w - 1, h - 1);
        }
    }

    private int getXOffset() {
        Icon i = this.getIcon();
        int offs = 0;
        if (i != null && this.getText() != null) {
            offs = i.getIconWidth() + Math.max(0, this.getIconTextGap() - 1);
        }
        return offs;
    }

    public Dimension getPreferredSize() {
        Dimension size = super.getPreferredSize();
        size.width += 3;
        return size;
    }

    public void validate() {
    }

    public void revalidate() {
    }

    public void repaint(long tm, int x, int y, int width, int height) {
    }

    public void repaint(Rectangle area) {
    }

    protected void firePropertyChange(String name, Object oldValue, Object newValue) {
    }

    public void firePropertyChange(String name, byte oldValue, byte newValue) {
    }

    public void firePropertyChange(String name, char oldValue, char newValue) {
    }

    public void firePropertyChange(String name, short oldValue, short newValue) {
    }

    public void firePropertyChange(String name, int oldValue, int newValue) {
    }

    public void firePropertyChange(String name, long oldValue, long newValue) {
    }

    public void firePropertyChange(String name, float oldValue, float newValue) {
    }

    public void firePropertyChange(String name, double oldValue, double newValue) {
    }

    public void firePropertyChange(String name, boolean oldValue, boolean newValue) {
    }
}

