/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text;

import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.InputMethodListener;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.text.BreakIterator;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleAction;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleEditableText;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleState;
import javax.accessibility.AccessibleStateSet;
import javax.accessibility.AccessibleText;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.Scrollable;
import javax.swing.TransferHandler;
import javax.swing.UIManager;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.plaf.ActionMapUIResource;
import javax.swing.plaf.InputMapUIResource;
import javax.swing.plaf.TextUI;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.DefaultEditorKit;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.Highlighter;
import javax.swing.text.Keymap;
import javax.swing.text.NavigationFilter;
import javax.swing.text.Position;
import javax.swing.text.StyledDocument;
import javax.swing.text.View;

public abstract class JTextComponent
extends JComponent
implements Scrollable,
Accessible {
    private static final long serialVersionUID = -8796518220218978795L;
    public static final String DEFAULT_KEYMAP = "default";
    public static final String FOCUS_ACCELERATOR_KEY = "focusAcceleratorKey";
    private static DefaultTransferHandler defaultTransferHandler;
    private static Hashtable keymaps;
    private Keymap keymap;
    private char focusAccelerator = '\u0000';
    private NavigationFilter navigationFilter;
    Document doc;
    Caret caret;
    boolean editable;
    private Highlighter highlighter;
    private Color caretColor;
    private Color disabledTextColor;
    private Color selectedTextColor;
    private Color selectionColor;
    private Insets margin;
    private boolean dragEnabled;

    static {
        keymaps = new Hashtable();
    }

    public static Keymap getKeymap(String n) {
        return (Keymap)keymaps.get(n);
    }

    public static Keymap removeKeymap(String n) {
        Keymap km = (Keymap)keymaps.get(n);
        keymaps.remove(n);
        return km;
    }

    public static Keymap addKeymap(String n, Keymap parent) {
        DefaultKeymap k = new DefaultKeymap(n);
        k.setResolveParent(parent);
        if (n != null) {
            keymaps.put(n, k);
        }
        return k;
    }

    public Keymap getKeymap() {
        return this.keymap;
    }

    /*
     * Unable to fully structure code
     */
    public void setKeymap(Keymap k) {
        block17: {
            block16: {
                kw = k == null ? null : new KeymapWrapper(k);
                childInputMap = this.getInputMap(0);
                if (childInputMap != null) ** GOTO lbl7
                this.setInputMap(0, kw);
                break block16;
lbl-1000:
                // 1 sources

                {
                    childInputMap = childInputMap.getParent();
lbl7:
                    // 2 sources

                    ** while (childInputMap.getParent() != null && !(childInputMap.getParent() instanceof KeymapWrapper) && !(childInputMap.getParent() instanceof InputMapUIResource))
                }
lbl8:
                // 1 sources

                if (childInputMap.getParent() == null) {
                    childInputMap.setParent(kw);
                } else if (childInputMap.getParent() instanceof KeymapWrapper) {
                    if (kw == null) {
                        childInputMap.setParent(childInputMap.getParent().getParent());
                    } else {
                        kw.setParent(childInputMap.getParent().getParent());
                        childInputMap.setParent(kw);
                    }
                } else if (childInputMap.getParent() instanceof InputMapUIResource && kw != null) {
                    kw.setParent(childInputMap.getParent());
                    childInputMap.setParent(kw);
                }
            }
            kam = k == null ? null : new KeymapActionMap(k);
            childActionMap = this.getActionMap();
            if (childActionMap != null) ** GOTO lbl28
            this.setActionMap(kam);
            break block17;
lbl-1000:
            // 1 sources

            {
                childActionMap = childActionMap.getParent();
lbl28:
                // 2 sources

                ** while (childActionMap.getParent() != null && !(childActionMap.getParent() instanceof KeymapActionMap) && !(childActionMap.getParent() instanceof ActionMapUIResource))
            }
lbl29:
            // 1 sources

            if (childActionMap.getParent() == null) {
                childActionMap.setParent(kam);
            } else if (childActionMap.getParent() instanceof KeymapActionMap) {
                if (kam == null) {
                    childActionMap.setParent(childActionMap.getParent().getParent());
                } else {
                    kam.setParent(childActionMap.getParent().getParent());
                    childActionMap.setParent(kam);
                }
            } else if (childActionMap.getParent() instanceof ActionMapUIResource && kam != null) {
                kam.setParent(childActionMap.getParent());
                childActionMap.setParent(kam);
            }
        }
        old = this.keymap;
        this.keymap = k;
        this.firePropertyChange("keymap", old, k);
    }

    public static void loadKeymap(Keymap map, KeyBinding[] bindings, Action[] actions) {
        Hashtable<Object, Action> acts = new Hashtable<Object, Action>(actions.length);
        int i = 0;
        while (i < actions.length) {
            acts.put(actions[i].getValue("Name"), actions[i]);
            ++i;
        }
        i = 0;
        while (i < bindings.length) {
            if (acts.containsKey(bindings[i].actionName)) {
                map.addActionForKeyStroke(bindings[i].key, (Action)acts.get(bindings[i].actionName));
            }
            ++i;
        }
    }

    public Action[] getActions() {
        return this.getUI().getEditorKit(this).getActions();
    }

    public JTextComponent() {
        Keymap defkeymap = JTextComponent.getKeymap(DEFAULT_KEYMAP);
        if (defkeymap == null) {
            defkeymap = JTextComponent.addKeymap(DEFAULT_KEYMAP, null);
            defkeymap.setDefaultAction(new DefaultEditorKit.DefaultKeyTypedAction());
        }
        this.setFocusable(true);
        this.setEditable(true);
        this.enableEvents(8L);
        this.setOpaque(true);
        this.updateUI();
    }

    public void setDocument(Document newDoc) {
        Document oldDoc = this.doc;
        try {
            if (oldDoc instanceof AbstractDocument) {
                ((AbstractDocument)oldDoc).readLock();
            }
            this.doc = newDoc;
            this.firePropertyChange("document", oldDoc, newDoc);
        }
        finally {
            if (oldDoc instanceof AbstractDocument) {
                ((AbstractDocument)oldDoc).readUnlock();
            }
        }
        this.revalidate();
        this.repaint();
    }

    public Document getDocument() {
        return this.doc;
    }

    public AccessibleContext getAccessibleContext() {
        return new AccessibleJTextComponent();
    }

    public void setMargin(Insets m) {
        this.margin = m;
    }

    public Insets getMargin() {
        return this.margin;
    }

    public void setText(String text) {
        try {
            if (this.doc instanceof AbstractDocument) {
                ((AbstractDocument)this.doc).replace(0, this.doc.getLength(), text, null);
            } else {
                this.doc.remove(0, this.doc.getLength());
                this.doc.insertString(0, text, null);
            }
        }
        catch (BadLocationException e) {
            throw (InternalError)new InternalError().initCause(e);
        }
    }

    public String getText() {
        if (this.doc == null) {
            return null;
        }
        try {
            return this.doc.getText(0, this.doc.getLength());
        }
        catch (BadLocationException badLocationException) {
            return "";
        }
    }

    public String getText(int offset, int length) throws BadLocationException {
        return this.getDocument().getText(offset, length);
    }

    public String getSelectedText() {
        int start = this.getSelectionStart();
        int offset = this.getSelectionEnd() - start;
        if (offset <= 0) {
            return null;
        }
        try {
            return this.doc.getText(start, offset);
        }
        catch (BadLocationException badLocationException) {
            return null;
        }
    }

    public String getUIClassID() {
        return "TextComponentUI";
    }

    protected String paramString() {
        return super.paramString();
    }

    public TextUI getUI() {
        return (TextUI)this.ui;
    }

    public void setUI(TextUI newUI) {
        super.setUI(newUI);
    }

    public void updateUI() {
        this.setUI((TextUI)UIManager.getUI(this));
    }

    public Dimension getPreferredScrollableViewportSize() {
        return this.getPreferredSize();
    }

    public int getScrollableUnitIncrement(Rectangle visible, int orientation, int direction) {
        if (orientation == 0) {
            return visible.width / 10;
        }
        if (orientation == 1) {
            return visible.height / 10;
        }
        throw new IllegalArgumentException("orientation must be either javax.swing.SwingConstants.VERTICAL or javax.swing.SwingConstants.HORIZONTAL");
    }

    public int getScrollableBlockIncrement(Rectangle visible, int orientation, int direction) {
        if (orientation == 0) {
            return visible.width;
        }
        if (orientation == 1) {
            return visible.height;
        }
        throw new IllegalArgumentException("orientation must be either javax.swing.SwingConstants.VERTICAL or javax.swing.SwingConstants.HORIZONTAL");
    }

    public boolean isEditable() {
        return this.editable;
    }

    public void setEditable(boolean newValue) {
        if (this.editable == newValue) {
            return;
        }
        boolean oldValue = this.editable;
        this.editable = newValue;
        this.firePropertyChange("editable", oldValue, newValue);
    }

    public Caret getCaret() {
        return this.caret;
    }

    public void setCaret(Caret newCaret) {
        if (this.caret != null) {
            this.caret.deinstall(this);
        }
        Caret oldCaret = this.caret;
        this.caret = newCaret;
        if (this.caret != null) {
            this.caret.install(this);
        }
        this.firePropertyChange("caret", oldCaret, newCaret);
    }

    public Color getCaretColor() {
        return this.caretColor;
    }

    public void setCaretColor(Color newColor) {
        Color oldCaretColor = this.caretColor;
        this.caretColor = newColor;
        this.firePropertyChange("caretColor", oldCaretColor, newColor);
    }

    public Color getDisabledTextColor() {
        return this.disabledTextColor;
    }

    public void setDisabledTextColor(Color newColor) {
        Color oldColor = this.disabledTextColor;
        this.disabledTextColor = newColor;
        this.firePropertyChange("disabledTextColor", oldColor, newColor);
    }

    public Color getSelectedTextColor() {
        return this.selectedTextColor;
    }

    public void setSelectedTextColor(Color newColor) {
        Color oldColor = this.selectedTextColor;
        this.selectedTextColor = newColor;
        this.firePropertyChange("selectedTextColor", oldColor, newColor);
    }

    public Color getSelectionColor() {
        return this.selectionColor;
    }

    public void setSelectionColor(Color newColor) {
        Color oldColor = this.selectionColor;
        this.selectionColor = newColor;
        this.firePropertyChange("selectionColor", oldColor, newColor);
    }

    public int getCaretPosition() {
        return this.caret.getDot();
    }

    public void setCaretPosition(int position) {
        if (this.doc == null) {
            return;
        }
        if (position < 0 || position > this.doc.getLength()) {
            throw new IllegalArgumentException();
        }
        this.caret.setDot(position);
    }

    public void moveCaretPosition(int position) {
        if (this.doc == null) {
            return;
        }
        if (position < 0 || position > this.doc.getLength()) {
            throw new IllegalArgumentException();
        }
        this.caret.moveDot(position);
    }

    public Highlighter getHighlighter() {
        return this.highlighter;
    }

    public void setHighlighter(Highlighter newHighlighter) {
        if (this.highlighter != null) {
            this.highlighter.deinstall(this);
        }
        Highlighter oldHighlighter = this.highlighter;
        this.highlighter = newHighlighter;
        if (this.highlighter != null) {
            this.highlighter.install(this);
        }
        this.firePropertyChange("highlighter", oldHighlighter, newHighlighter);
    }

    public int getSelectionStart() {
        return Math.min(this.caret.getDot(), this.caret.getMark());
    }

    public void setSelectionStart(int start) {
        this.select(start, this.getSelectionEnd());
    }

    public int getSelectionEnd() {
        return Math.max(this.caret.getDot(), this.caret.getMark());
    }

    public void setSelectionEnd(int end) {
        this.select(this.getSelectionStart(), end);
    }

    public void select(int start, int end) {
        int length = this.doc.getLength();
        start = Math.max(start, 0);
        start = Math.min(start, length);
        end = Math.max(end, start);
        end = Math.min(end, length);
        this.setCaretPosition(start);
        this.moveCaretPosition(end);
    }

    public void selectAll() {
        this.select(0, this.doc.getLength());
    }

    public synchronized void replaceSelection(String content) {
        int dot = this.caret.getDot();
        int mark = this.caret.getMark();
        if (content == null) {
            this.caret.setDot(dot);
            return;
        }
        try {
            int start = this.getSelectionStart();
            int end = this.getSelectionEnd();
            if (dot != mark) {
                this.doc.remove(start, end - start);
            }
            this.doc.insertString(start, content, null);
            dot = start + content.length();
            this.setCaretPosition(dot);
            this.caret.setMagicCaretPosition(this.modelToView(dot).getLocation());
        }
        catch (BadLocationException badLocationException) {}
    }

    public boolean getScrollableTracksViewportHeight() {
        if (this.getParent() instanceof JViewport) {
            return this.getParent().getHeight() > this.getPreferredSize().height;
        }
        return false;
    }

    public boolean getScrollableTracksViewportWidth() {
        boolean res = false;
        Container c = this.getParent();
        if (c instanceof JViewport) {
            res = ((JViewport)c).getExtentSize().width > this.getPreferredSize().width;
        }
        return res;
    }

    public void addCaretListener(CaretListener listener) {
        this.listenerList.add(CaretListener.class, listener);
    }

    public void removeCaretListener(CaretListener listener) {
        this.listenerList.remove(CaretListener.class, listener);
    }

    public CaretListener[] getCaretListeners() {
        return (CaretListener[])this.getListeners(CaretListener.class);
    }

    protected void fireCaretUpdate(CaretEvent event) {
        CaretListener[] listeners = this.getCaretListeners();
        int index = 0;
        while (index < listeners.length) {
            listeners[index].caretUpdate(event);
            ++index;
        }
    }

    public void addInputMethodListener(InputMethodListener listener) {
        this.listenerList.add(InputMethodListener.class, listener);
    }

    public void removeInputMethodListener(InputMethodListener listener) {
        this.listenerList.remove(InputMethodListener.class, listener);
    }

    public InputMethodListener[] getInputMethodListeners() {
        return (InputMethodListener[])this.getListeners(InputMethodListener.class);
    }

    public Rectangle modelToView(int position) throws BadLocationException {
        return this.getUI().modelToView(this, position);
    }

    public boolean getDragEnabled() {
        return this.dragEnabled;
    }

    public void setDragEnabled(boolean enabled) {
        this.dragEnabled = enabled;
    }

    public int viewToModel(Point pt) {
        return this.getUI().viewToModel(this, pt);
    }

    public void copy() {
        if (this.isEnabled()) {
            this.doTransferAction("copy", TransferHandler.getCopyAction());
        }
    }

    public void cut() {
        if (this.editable && this.isEnabled()) {
            this.doTransferAction("cut", TransferHandler.getCutAction());
        }
    }

    public void paste() {
        if (this.editable && this.isEnabled()) {
            this.doTransferAction("paste", TransferHandler.getPasteAction());
        }
    }

    private void doTransferAction(String name, Action action) {
        if (this.getTransferHandler() == null) {
            if (defaultTransferHandler == null) {
                defaultTransferHandler = new DefaultTransferHandler();
            }
            this.setTransferHandler(defaultTransferHandler);
        }
        ActionEvent event = new ActionEvent(this, 1001, action.getValue("Name").toString());
        action.actionPerformed(event);
    }

    public void setFocusAccelerator(char newKey) {
        if (this.focusAccelerator == newKey) {
            return;
        }
        char oldKey = this.focusAccelerator;
        this.focusAccelerator = newKey;
        this.firePropertyChange(FOCUS_ACCELERATOR_KEY, oldKey, newKey);
    }

    public char getFocusAccelerator() {
        return this.focusAccelerator;
    }

    public NavigationFilter getNavigationFilter() {
        return this.navigationFilter;
    }

    public void setNavigationFilter(NavigationFilter filter) {
        this.navigationFilter = filter;
    }

    public void read(Reader input, Object streamDescription) throws IOException {
        int c;
        Document d;
        if (streamDescription != null && (d = this.getDocument()) != null) {
            d.putProperty("stream", streamDescription);
        }
        StringBuffer b = new StringBuffer();
        while ((c = input.read()) >= 0) {
            b.append((char)c);
        }
        this.setText(b.toString());
    }

    public void write(Writer output) throws IOException {
        output.write(this.getText());
    }

    public String getToolTipText(MouseEvent ev) {
        return this.getUI().getToolTipText(this, ev.getPoint());
    }

    public class AccessibleJTextComponent
    extends JComponent.AccessibleJComponent
    implements AccessibleText,
    CaretListener,
    DocumentListener,
    AccessibleAction,
    AccessibleEditableText {
        private static final long serialVersionUID = 7664188944091413696L;
        private int caretDot;

        public AccessibleJTextComponent() {
            JTextComponent.this.addCaretListener(this);
            this.caretDot = this.getCaretPosition();
        }

        public int getCaretPosition() {
            return JTextComponent.this.getCaretPosition();
        }

        public String getSelectedText() {
            return JTextComponent.this.getSelectedText();
        }

        public int getSelectionStart() {
            if (this.getSelectedText() == null || JTextComponent.this.getText().equals("")) {
                return 0;
            }
            return JTextComponent.this.getSelectionStart();
        }

        public int getSelectionEnd() {
            return JTextComponent.this.getSelectionEnd();
        }

        public void caretUpdate(CaretEvent e) {
            int dot = e.getDot();
            int mark = e.getMark();
            if (this.caretDot != dot) {
                this.firePropertyChange("AccessibleCaret", new Integer(this.caretDot), new Integer(dot));
                this.caretDot = dot;
            }
            if (mark != dot) {
                this.firePropertyChange("AccessibleSelection", null, this.getSelectedText());
            }
        }

        public AccessibleStateSet getAccessibleStateSet() {
            AccessibleStateSet state = super.getAccessibleStateSet();
            if (JTextComponent.this.isEditable()) {
                state.add(AccessibleState.EDITABLE);
            }
            return state;
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.TEXT;
        }

        public AccessibleEditableText getAccessibleEditableText() {
            return this;
        }

        public AccessibleText getAccessibleText() {
            return this;
        }

        public void insertUpdate(DocumentEvent e) {
            this.firePropertyChange("AccessibleText", null, new Integer(e.getOffset()));
        }

        public void removeUpdate(DocumentEvent e) {
            this.firePropertyChange("AccessibleText", null, new Integer(e.getOffset()));
        }

        public void changedUpdate(DocumentEvent e) {
            this.firePropertyChange("AccessibleText", null, new Integer(e.getOffset()));
        }

        public int getIndexAtPoint(Point p) {
            return JTextComponent.this.viewToModel(p);
        }

        public Rectangle getCharacterBounds(int index) {
            Rectangle bounds = null;
            if (index >= 0 && index < JTextComponent.this.doc.getLength() - 1) {
                if (JTextComponent.this.doc instanceof AbstractDocument) {
                    ((AbstractDocument)JTextComponent.this.doc).readLock();
                }
                try {
                    try {
                        TextUI ui = JTextComponent.this.getUI();
                        if (ui != null) {
                            Rectangle rect = new Rectangle();
                            Insets insets = JTextComponent.this.getInsets();
                            rect.x = insets.left;
                            rect.y = insets.top;
                            rect.width = JTextComponent.this.getWidth() - insets.left - insets.right;
                            rect.height = JTextComponent.this.getHeight() - insets.top - insets.bottom;
                            View rootView = ui.getRootView(JTextComponent.this);
                            if (rootView != null) {
                                rootView.setSize(rect.width, rect.height);
                                Shape s = rootView.modelToView(index, Position.Bias.Forward, index + 1, Position.Bias.Backward, rect);
                                if (s != null) {
                                    bounds = s.getBounds();
                                }
                            }
                        }
                    }
                    catch (BadLocationException badLocationException) {
                        if (JTextComponent.this.doc instanceof AbstractDocument) {
                            ((AbstractDocument)JTextComponent.this.doc).readUnlock();
                        }
                    }
                }
                finally {
                    if (JTextComponent.this.doc instanceof AbstractDocument) {
                        ((AbstractDocument)JTextComponent.this.doc).readUnlock();
                    }
                }
            }
            return bounds;
        }

        public int getCharCount() {
            return JTextComponent.this.getText().length();
        }

        public AttributeSet getCharacterAttribute(int index) {
            AttributeSet atts;
            if (JTextComponent.this.doc instanceof AbstractDocument) {
                ((AbstractDocument)JTextComponent.this.doc).readLock();
            }
            try {
                Element el = JTextComponent.this.doc.getDefaultRootElement();
                while (!el.isLeaf()) {
                    int i = el.getElementIndex(index);
                    el = el.getElement(i);
                }
                atts = el.getAttributes();
            }
            finally {
                if (JTextComponent.this.doc instanceof AbstractDocument) {
                    ((AbstractDocument)JTextComponent.this.doc).readUnlock();
                }
            }
            return atts;
        }

        public String getAtIndex(int part, int index) {
            return this.getAtIndexImpl(part, index, 0);
        }

        public String getAfterIndex(int part, int index) {
            return this.getAtIndexImpl(part, index, 1);
        }

        public String getBeforeIndex(int part, int index) {
            return this.getAtIndexImpl(part, index, -1);
        }

        private String getAtIndexImpl(int part, int index, int dir) {
            String ret = null;
            if (JTextComponent.this.doc instanceof AbstractDocument) {
                ((AbstractDocument)JTextComponent.this.doc).readLock();
            }
            try {
                try {
                    BreakIterator iter = null;
                    switch (part) {
                        case 1: {
                            iter = BreakIterator.getCharacterInstance(this.getLocale());
                            break;
                        }
                        case 2: {
                            iter = BreakIterator.getWordInstance(this.getLocale());
                            break;
                        }
                        case 3: {
                            iter = BreakIterator.getSentenceInstance(this.getLocale());
                            break;
                        }
                    }
                    String text = JTextComponent.this.doc.getText(0, JTextComponent.this.doc.getLength() - 1);
                    iter.setText(text);
                    int start = index;
                    int end = index;
                    switch (dir) {
                        case 0: {
                            if (iter.isBoundary(index)) {
                                start = index;
                                end = iter.following(index);
                                break;
                            }
                            start = iter.preceding(index);
                            end = iter.next();
                            break;
                        }
                        case 1: {
                            start = iter.following(index);
                            end = iter.next();
                            break;
                        }
                        case -1: {
                            end = iter.preceding(index);
                            start = iter.previous();
                            break;
                        }
                        default: {
                            assert (false);
                            break;
                        }
                    }
                    ret = text.substring(start, end);
                }
                catch (BadLocationException badLocationException) {
                    if (JTextComponent.this.doc instanceof AbstractDocument) {
                        ((AbstractDocument)JTextComponent.this.doc).readUnlock();
                    }
                }
            }
            finally {
                if (JTextComponent.this.doc instanceof AbstractDocument) {
                    ((AbstractDocument)JTextComponent.this.doc).readUnlock();
                }
            }
            return ret;
        }

        public int getAccessibleActionCount() {
            return JTextComponent.this.getActions().length;
        }

        public String getAccessibleActionDescription(int i) {
            String desc = null;
            Action[] actions = JTextComponent.this.getActions();
            if (i >= 0 && i < actions.length) {
                desc = (String)actions[i].getValue("Name");
            }
            return desc;
        }

        public boolean doAccessibleAction(int i) {
            boolean ret = false;
            Action[] actions = JTextComponent.this.getActions();
            if (i >= 0 && i < actions.length) {
                ActionEvent ev = new ActionEvent(JTextComponent.this, 1001, null);
                actions[i].actionPerformed(ev);
                ret = true;
            }
            return ret;
        }

        public void setTextContents(String s) {
            JTextComponent.this.setText(s);
        }

        public void insertTextAtIndex(int index, String s) {
            try {
                JTextComponent.this.doc.insertString(index, s, null);
            }
            catch (BadLocationException ex) {
                ex.printStackTrace();
            }
        }

        public String getTextRange(int start, int end) {
            try {
                return JTextComponent.this.getText(start, end - start);
            }
            catch (BadLocationException badLocationException) {
                return "";
            }
        }

        public void delete(int start, int end) {
            this.replaceText(start, end, "");
        }

        public void cut(int start, int end) {
            JTextComponent.this.select(start, end);
            JTextComponent.this.cut();
        }

        public void paste(int start) {
            JTextComponent.this.setCaretPosition(start);
            JTextComponent.this.paste();
        }

        public void replaceText(int start, int end, String s) {
            JTextComponent.this.select(start, end);
            JTextComponent.this.replaceSelection(s);
        }

        public void selectText(int start, int end) {
            JTextComponent.this.select(start, end);
        }

        public void setAttributes(int start, int end, AttributeSet s) {
            if (JTextComponent.this.doc instanceof StyledDocument) {
                StyledDocument sdoc = (StyledDocument)JTextComponent.this.doc;
                sdoc.setCharacterAttributes(start, end - start, s, true);
            }
        }
    }

    static class DefaultKeymap
    implements Keymap {
        String name;
        Keymap parent;
        Hashtable map;
        Action defaultAction;

        public DefaultKeymap(String name) {
            this.name = name;
            this.map = new Hashtable();
        }

        public void addActionForKeyStroke(KeyStroke key, Action a) {
            this.map.put(key, a);
        }

        public Action getAction(KeyStroke key) {
            if (this.map.containsKey(key)) {
                return (Action)this.map.get(key);
            }
            if (this.parent != null) {
                return this.parent.getAction(key);
            }
            return null;
        }

        public Action[] getBoundActions() {
            Action[] ret = new Action[this.map.size()];
            Enumeration e = this.map.elements();
            int i = 0;
            while (e.hasMoreElements()) {
                ret[i++] = (Action)e.nextElement();
            }
            return ret;
        }

        public KeyStroke[] getBoundKeyStrokes() {
            KeyStroke[] ret = new KeyStroke[this.map.size()];
            Enumeration e = this.map.keys();
            int i = 0;
            while (e.hasMoreElements()) {
                ret[i++] = (KeyStroke)e.nextElement();
            }
            return ret;
        }

        public Action getDefaultAction() {
            return this.defaultAction;
        }

        public KeyStroke[] getKeyStrokesForAction(Action a) {
            int i = 0;
            Enumeration e = this.map.keys();
            while (e.hasMoreElements()) {
                if (!this.map.get(e.nextElement()).equals(a)) continue;
                ++i;
            }
            KeyStroke[] ret = new KeyStroke[i];
            i = 0;
            e = this.map.keys();
            while (e.hasMoreElements()) {
                KeyStroke k = (KeyStroke)e.nextElement();
                if (!this.map.get(k).equals(a)) continue;
                ret[i++] = k;
            }
            return ret;
        }

        public String getName() {
            return this.name;
        }

        public Keymap getResolveParent() {
            return this.parent;
        }

        public boolean isLocallyDefined(KeyStroke key) {
            return this.map.containsKey(key);
        }

        public void removeBindings() {
            this.map.clear();
        }

        public void removeKeyStrokeBinding(KeyStroke key) {
            this.map.remove(key);
        }

        public void setDefaultAction(Action a) {
            this.defaultAction = a;
        }

        public void setResolveParent(Keymap p) {
            this.parent = p;
        }
    }

    class DefaultTransferHandler
    extends TransferHandler {
        DefaultTransferHandler() {
        }

        public boolean canImport(JComponent component, DataFlavor[] flavors) {
            JTextComponent textComponent = (JTextComponent)component;
            if (!textComponent.isEnabled() || !textComponent.isEditable() || flavors == null) {
                return false;
            }
            int i = 0;
            while (i < flavors.length) {
                if (flavors[i].equals(DataFlavor.stringFlavor)) {
                    return true;
                }
                ++i;
            }
            return false;
        }

        public void exportToClipboard(JComponent component, Clipboard clipboard, int action) {
            int end;
            JTextComponent textComponent = (JTextComponent)component;
            int start = textComponent.getSelectionStart();
            if (start == (end = textComponent.getSelectionEnd())) {
                return;
            }
            try {
                String data = textComponent.getDocument().getText(start, end);
                StringSelection selection = new StringSelection(data);
                clipboard.setContents(selection, null);
                if (action == 2) {
                    JTextComponent.this.doc.remove(start, end - start);
                }
            }
            catch (BadLocationException badLocationException) {}
        }

        public int getSourceActions() {
            return 0;
        }

        public boolean importData(JComponent component, Transferable transferable) {
            DataFlavor flavor = null;
            DataFlavor[] flavors = transferable.getTransferDataFlavors();
            if (flavors == null) {
                return false;
            }
            int i = 0;
            while (i < flavors.length) {
                if (flavors[i].equals(DataFlavor.stringFlavor)) {
                    flavor = flavors[i];
                }
                ++i;
            }
            if (flavor == null) {
                return false;
            }
            try {
                JTextComponent textComponent = (JTextComponent)component;
                String data = (String)transferable.getTransferData(flavor);
                textComponent.replaceSelection(data);
                return true;
            }
            catch (IOException iOException) {
            }
            catch (UnsupportedFlavorException unsupportedFlavorException) {}
            return false;
        }
    }

    public static class KeyBinding {
        public KeyStroke key;
        public String actionName;

        public KeyBinding(KeyStroke key, String actionName) {
            this.key = key;
            this.actionName = actionName;
        }
    }

    private class KeymapActionMap
    extends ActionMap {
        Keymap map;

        public KeymapActionMap(Keymap k) {
            this.map = k;
        }

        public Action get(Object cmd) {
            if (cmd instanceof Action) {
                return (Action)cmd;
            }
            return super.get(cmd);
        }

        public int size() {
            return this.map.getBoundKeyStrokes().length + super.size();
        }

        public Object[] keys() {
            Object[] superKeys = super.keys();
            KeyStroke[] mapKeys = this.map.getBoundKeyStrokes();
            Object[] bothKeys = new Object[superKeys.length + mapKeys.length];
            int i = 0;
            while (i < superKeys.length) {
                bothKeys[i] = superKeys[i];
                ++i;
            }
            i = 0;
            while (i < mapKeys.length) {
                bothKeys[i + superKeys.length] = mapKeys[i];
                ++i;
            }
            return bothKeys;
        }

        public Object[] allKeys() {
            Object[] superKeys = super.allKeys();
            KeyStroke[] mapKeys = this.map.getBoundKeyStrokes();
            Object[] bothKeys = new Object[superKeys.length + mapKeys.length];
            int i = 0;
            while (i < superKeys.length) {
                bothKeys[i] = superKeys[i];
                ++i;
            }
            i = 0;
            while (i < mapKeys.length) {
                bothKeys[i + superKeys.length] = mapKeys[i];
                ++i;
            }
            return bothKeys;
        }
    }

    private class KeymapWrapper
    extends InputMap {
        Keymap map;

        public KeymapWrapper(Keymap k) {
            this.map = k;
        }

        public int size() {
            return this.map.getBoundKeyStrokes().length + super.size();
        }

        public Object get(KeyStroke ks) {
            Action mapped = null;
            Keymap m = this.map;
            while (mapped == null && m != null) {
                mapped = m.getAction(ks);
                if (mapped == null && ks.getKeyEventType() == 400) {
                    mapped = m.getDefaultAction();
                }
                if (mapped != null) continue;
                m = m.getResolveParent();
            }
            if (mapped == null) {
                return super.get(ks);
            }
            return mapped;
        }

        public KeyStroke[] keys() {
            KeyStroke[] superKeys = super.keys();
            KeyStroke[] mapKeys = this.map.getBoundKeyStrokes();
            KeyStroke[] bothKeys = new KeyStroke[superKeys.length + mapKeys.length];
            int i = 0;
            while (i < superKeys.length) {
                bothKeys[i] = superKeys[i];
                ++i;
            }
            i = 0;
            while (i < mapKeys.length) {
                bothKeys[i + superKeys.length] = mapKeys[i];
                ++i;
            }
            return bothKeys;
        }

        public KeyStroke[] allKeys() {
            KeyStroke[] superKeys = super.allKeys();
            KeyStroke[] mapKeys = this.map.getBoundKeyStrokes();
            int skl = 0;
            int mkl = 0;
            if (superKeys != null) {
                skl = superKeys.length;
            }
            if (mapKeys != null) {
                mkl = mapKeys.length;
            }
            KeyStroke[] bothKeys = new KeyStroke[skl + mkl];
            int i = 0;
            while (i < skl) {
                bothKeys[i] = superKeys[i];
                ++i;
            }
            i = 0;
            while (i < mkl) {
                bothKeys[i + skl] = mapKeys[i];
                ++i;
            }
            return bothKeys;
        }
    }
}

