/*
 * Decompiled with CFR 0.152.
 */
package javax.imageio.stream;

import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteOrder;
import java.util.Stack;
import javax.imageio.stream.IIOByteBuffer;
import javax.imageio.stream.ImageInputStream;

public abstract class ImageInputStreamImpl
implements ImageInputStream {
    private boolean closed;
    private Stack markStack = new Stack();
    byte[] buffer = new byte[8];
    protected int bitOffset;
    protected ByteOrder byteOrder = ByteOrder.BIG_ENDIAN;
    protected long flushedPos;
    protected long streamPos;

    protected final void checkClosed() throws IOException {
        if (this.closed) {
            throw new IOException("stream closed");
        }
    }

    public void close() throws IOException {
        this.checkClosed();
        this.closed = true;
    }

    protected void finalize() throws Throwable {
        if (!this.closed) {
            this.close();
        }
    }

    public void flush() throws IOException {
        this.flushBefore(this.getStreamPosition());
    }

    public void flushBefore(long position) throws IOException {
        if (position < this.flushedPos) {
            throw new IndexOutOfBoundsException();
        }
        if (position > this.streamPos) {
            throw new IndexOutOfBoundsException();
        }
        this.flushedPos = position;
    }

    public int getBitOffset() throws IOException {
        this.checkClosed();
        return this.bitOffset;
    }

    public ByteOrder getByteOrder() {
        return this.byteOrder;
    }

    public long getFlushedPosition() {
        return this.flushedPos;
    }

    public long getStreamPosition() throws IOException {
        this.checkClosed();
        return this.streamPos;
    }

    public boolean isCached() {
        return false;
    }

    public boolean isCachedFile() {
        return false;
    }

    public boolean isCachedMemory() {
        return false;
    }

    public long length() {
        return -1L;
    }

    public void mark() {
        try {
            this.markStack.push(new Long(this.getStreamPosition()));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public abstract int read() throws IOException;

    public abstract int read(byte[] var1, int var2, int var3) throws IOException;

    public int read(byte[] data) throws IOException {
        return this.read(data, 0, data.length);
    }

    public int readBit() throws IOException {
        this.checkClosed();
        int newOffset = this.bitOffset + 1 & 7;
        byte data = this.readByte();
        if (newOffset != 0) {
            this.seek(this.getStreamPosition() - 1L);
            data = (byte)(data >> 8 - newOffset);
        }
        this.bitOffset = newOffset;
        return data & 1;
    }

    public long readBits(int numBits) throws IOException {
        this.checkClosed();
        if (numBits < 0 || numBits > 64) {
            throw new IllegalArgumentException();
        }
        long bits = 0L;
        int i = 0;
        while (i < numBits) {
            bits <<= 1;
            bits |= (long)this.readBit();
            ++i;
        }
        return bits;
    }

    public boolean readBoolean() throws IOException {
        byte data = this.readByte();
        return data != 0;
    }

    public byte readByte() throws IOException {
        this.checkClosed();
        int data = this.read();
        if (data == -1) {
            throw new EOFException();
        }
        return (byte)data;
    }

    public void readBytes(IIOByteBuffer buffer, int len) throws IOException {
        this.readFullyPrivate(buffer.getData(), buffer.getOffset(), len);
        buffer.setLength(len);
    }

    public char readChar() throws IOException {
        return (char)this.readShort();
    }

    public double readDouble() throws IOException {
        return Double.longBitsToDouble(this.readLong());
    }

    public float readFloat() throws IOException {
        return Float.intBitsToFloat(this.readInt());
    }

    public void readFully(byte[] data) throws IOException {
        this.readFully(data, 0, data.length);
    }

    public void readFully(byte[] data, int offset, int len) throws IOException {
        this.readFullyPrivate(data, offset, len);
    }

    public void readFully(char[] data, int offset, int len) throws IOException {
        int i = 0;
        while (i < len) {
            data[offset + i] = this.readChar();
            ++i;
        }
    }

    public void readFully(double[] data, int offset, int len) throws IOException {
        int i = 0;
        while (i < len) {
            data[offset + i] = this.readDouble();
            ++i;
        }
    }

    public void readFully(float[] data, int offset, int len) throws IOException {
        int i = 0;
        while (i < len) {
            data[offset + i] = this.readFloat();
            ++i;
        }
    }

    public void readFully(int[] data, int offset, int len) throws IOException {
        int i = 0;
        while (i < len) {
            data[offset + i] = this.readInt();
            ++i;
        }
    }

    public void readFully(long[] data, int offset, int len) throws IOException {
        int i = 0;
        while (i < len) {
            data[offset + i] = this.readLong();
            ++i;
        }
    }

    public void readFully(short[] data, int offset, int len) throws IOException {
        int i = 0;
        while (i < len) {
            data[offset + i] = this.readShort();
            ++i;
        }
    }

    public int readInt() throws IOException {
        this.readFullyPrivate(this.buffer, 0, 4);
        if (this.getByteOrder() == ByteOrder.LITTLE_ENDIAN) {
            return (this.buffer[0] & 0xFF) << 0 | (this.buffer[1] & 0xFF) << 8 | (this.buffer[2] & 0xFF) << 16 | (this.buffer[3] & 0xFF) << 24;
        }
        return ((this.buffer[0] & 0xFF) << 24) + ((this.buffer[1] & 0xFF) << 16) + ((this.buffer[2] & 0xFF) << 8) + ((this.buffer[3] & 0xFF) << 0);
    }

    /*
     * Unable to fully structure code
     */
    public String readLine() throws IOException {
        this.checkClosed();
        c = -1;
        eol = false;
        buffer = new StringBuffer();
        c = this.read();
        if (c != -1) ** GOTO lbl27
        return null;
lbl-1000:
        // 1 sources

        {
            switch (c) {
                case 13: {
                    oldPosition = this.getStreamPosition();
                    c = this.read();
                    if (c == -1 || c == 10) {
                        eol = true;
                        break;
                    }
                    this.seek(oldPosition);
                    eol = true;
                    break;
                }
                case 10: {
                    eol = true;
                    break;
                }
                default: {
                    buffer.append((char)c);
                    c = this.read();
                    if (c != -1) continue block4;
                    eol = true;
                }
            }
lbl27:
            // 6 sources

            ** while (!eol)
        }
lbl28:
        // 1 sources

        return buffer.toString();
    }

    public long readLong() throws IOException {
        this.readFullyPrivate(this.buffer, 0, 8);
        if (this.getByteOrder() == ByteOrder.LITTLE_ENDIAN) {
            return (long)(this.buffer[0] & 0xFF) << 0 | (long)(this.buffer[1] & 0xFF) << 8 | (long)(this.buffer[2] & 0xFF) << 16 | (long)(this.buffer[3] & 0xFF) << 24 | (long)(this.buffer[4] & 0xFF) << 32 | (long)(this.buffer[5] & 0xFF) << 40 | (long)(this.buffer[6] & 0xFF) << 48 | (long)(this.buffer[7] & 0xFF) << 56;
        }
        return (long)(this.buffer[0] & 0xFF) << 56 | (long)(this.buffer[1] & 0xFF) << 48 | (long)(this.buffer[2] & 0xFF) << 40 | (long)(this.buffer[3] & 0xFF) << 32 | (long)(this.buffer[4] & 0xFF) << 24 | (long)(this.buffer[5] & 0xFF) << 16 | (long)(this.buffer[6] & 0xFF) << 8 | (long)(this.buffer[7] & 0xFF) << 0;
    }

    public short readShort() throws IOException {
        this.readFullyPrivate(this.buffer, 0, 2);
        if (this.getByteOrder() == ByteOrder.LITTLE_ENDIAN) {
            return (short)((short)(this.buffer[0] & 0xFF) << 0 | (short)(this.buffer[1] & 0xFF) << 8);
        }
        return (short)((short)(this.buffer[0] & 0xFF) << 8 | (short)(this.buffer[1] & 0xFF) << 0);
    }

    public int readUnsignedByte() throws IOException {
        return this.readByte() & 0xFF;
    }

    public long readUnsignedInt() throws IOException {
        return (long)this.readInt() & 0xFFFFFFFFL;
    }

    public int readUnsignedShort() throws IOException {
        return this.readShort() & 0xFFFF;
    }

    public String readUTF() throws IOException {
        String data;
        this.checkClosed();
        ByteOrder old = this.getByteOrder();
        this.setByteOrder(ByteOrder.BIG_ENDIAN);
        try {
            data = DataInputStream.readUTF(this);
        }
        finally {
            this.setByteOrder(old);
        }
        return data;
    }

    public void reset() throws IOException {
        this.checkClosed();
        long mark = (Long)this.markStack.pop();
        this.seek(mark);
    }

    public void seek(long position) throws IOException {
        this.checkClosed();
        if (position < this.getFlushedPosition()) {
            throw new IndexOutOfBoundsException("position < flushed position");
        }
        this.streamPos = position;
        this.bitOffset = 0;
    }

    public void setBitOffset(int bitOffset) throws IOException {
        this.checkClosed();
        if (bitOffset < 0 || bitOffset > 7) {
            throw new IllegalArgumentException("bitOffset not between 0 and 7 inclusive");
        }
        this.bitOffset = bitOffset;
    }

    public void setByteOrder(ByteOrder byteOrder) {
        this.byteOrder = byteOrder;
    }

    public int skipBytes(int num) throws IOException {
        this.checkClosed();
        this.seek(this.getStreamPosition() + (long)num);
        this.bitOffset = 0;
        return num;
    }

    public long skipBytes(long num) throws IOException {
        this.checkClosed();
        this.seek(this.getStreamPosition() + num);
        this.bitOffset = 0;
        return num;
    }

    /*
     * Unable to fully structure code
     */
    private void readFullyPrivate(byte[] buf, int offset, int len) throws IOException {
        this.checkClosed();
        if (len >= 0) ** GOTO lbl9
        throw new IndexOutOfBoundsException("Negative length: " + len);
lbl-1000:
        // 1 sources

        {
            numread = this.read(buf, offset, len);
            if (numread < 0) {
                throw new EOFException();
            }
            len -= numread;
            offset += numread;
lbl9:
            // 2 sources

            ** while (len > 0)
        }
lbl10:
        // 1 sources

        this.bitOffset = 0;
    }
}

