/*
 * Decompiled with CFR 0.152.
 */
package java.awt.image;

import gnu.java.awt.Buffers;
import java.awt.image.ComponentSampleModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferDouble;
import java.awt.image.DataBufferFloat;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferShort;
import java.awt.image.DataBufferUShort;
import java.awt.image.RasterFormatException;
import java.awt.image.SampleModel;

public final class BandedSampleModel
extends ComponentSampleModel {
    private int[] bitMasks;
    private int[] bitOffsets;
    private int[] sampleSize;
    private int dataBitOffset;
    private int elemBits;
    private int numberOfBits;
    private int numElems;

    private static int[] createBankArray(int size) {
        int[] result = new int[size];
        int i = 0;
        while (i < size) {
            result[i] = i;
            ++i;
        }
        return result;
    }

    public BandedSampleModel(int dataType, int w, int h, int numBands) {
        this(dataType, w, h, w, BandedSampleModel.createBankArray(numBands), new int[numBands]);
    }

    public BandedSampleModel(int dataType, int w, int h, int scanlineStride, int[] bankIndices, int[] bandOffsets) {
        super(dataType, w, h, 1, scanlineStride, bankIndices, bandOffsets);
    }

    public DataBuffer createDataBuffer() {
        int size = this.scanlineStride * this.height;
        return Buffers.createBuffer(this.getDataType(), size, this.numBanks);
    }

    public SampleModel createCompatibleSampleModel(int w, int h) {
        int[] newoffsets = new int[this.bandOffsets.length];
        int[] order = new int[this.bandOffsets.length];
        int i = 0;
        while (i < this.bandOffsets.length) {
            order[i] = i;
            ++i;
        }
        i = 0;
        while (i < this.bandOffsets.length) {
            int j = i + 1;
            while (j < this.bandOffsets.length) {
                if (this.bankIndices[order[i]] > this.bankIndices[order[j]] || this.bankIndices[order[i]] == this.bankIndices[order[j]] && this.bandOffsets[order[i]] > this.bandOffsets[order[j]]) {
                    int t = order[i];
                    order[i] = order[j];
                    order[j] = t;
                }
                ++j;
            }
            ++i;
        }
        int bank = 0;
        int offset = 0;
        int i2 = 0;
        while (i2 < this.bandOffsets.length) {
            if (this.bankIndices[order[i2]] != bank) {
                bank = this.bankIndices[order[i2]];
                offset = 0;
            }
            newoffsets[order[i2]] = offset;
            offset += w * this.scanlineStride;
            ++i2;
        }
        return new BandedSampleModel(this.dataType, w, h, w, this.bankIndices, newoffsets);
    }

    public SampleModel createSubsetSampleModel(int[] bands) {
        if (bands.length > this.bankIndices.length) {
            throw new RasterFormatException("BandedSampleModel createSubsetSampleModel too many bands");
        }
        int[] newoff = new int[bands.length];
        int[] newbanks = new int[bands.length];
        int i = 0;
        while (i < bands.length) {
            int b = bands[i];
            newoff[i] = this.bandOffsets[b];
            newbanks[i] = this.bankIndices[b];
            ++i;
        }
        return new BandedSampleModel(this.dataType, this.width, this.height, this.scanlineStride, newbanks, newoff);
    }

    public Object getDataElements(int x, int y, Object obj, DataBuffer data) {
        if (x < 0 || y < 0) {
            throw new ArrayIndexOutOfBoundsException("x and y must not be less than 0.");
        }
        this.getSample(x, y, 0, data);
        switch (this.getTransferType()) {
            case 0: {
                byte[] b = (byte[])obj;
                if (b == null) {
                    b = new byte[this.numBands];
                }
                int i = 0;
                while (i < this.numBands) {
                    b[i] = (byte)this.getSample(x, y, i, data);
                    ++i;
                }
                return b;
            }
            case 1: 
            case 2: {
                short[] b = (short[])obj;
                if (b == null) {
                    b = new short[this.numBands];
                }
                int i = 0;
                while (i < this.numBands) {
                    b[i] = (short)this.getSample(x, y, i, data);
                    ++i;
                }
                return b;
            }
            case 3: {
                int[] b = (int[])obj;
                if (b == null) {
                    b = new int[this.numBands];
                }
                int i = 0;
                while (i < this.numBands) {
                    b[i] = this.getSample(x, y, i, data);
                    ++i;
                }
                return b;
            }
            case 4: {
                float[] b = (float[])obj;
                if (b == null) {
                    b = new float[this.numBands];
                }
                int i = 0;
                while (i < this.numBands) {
                    b[i] = this.getSampleFloat(x, y, i, data);
                    ++i;
                }
                return b;
            }
            case 5: {
                double[] b = (double[])obj;
                if (b == null) {
                    b = new double[this.numBands];
                }
                int i = 0;
                while (i < this.numBands) {
                    b[i] = this.getSample(x, y, i, data);
                    ++i;
                }
                return b;
            }
        }
        throw new ClassCastException();
    }

    public int[] getPixel(int x, int y, int[] iArray, DataBuffer data) {
        if (iArray == null) {
            iArray = new int[this.numBands];
        }
        int i = 0;
        while (i < this.numBands) {
            iArray[i] = this.getSample(x, y, i, data);
            ++i;
        }
        return iArray;
    }

    public int[] getPixels(int x, int y, int w, int h, int[] iArray, DataBuffer data) {
        if (x < 0 || y < 0) {
            throw new ArrayIndexOutOfBoundsException("x and y must not be less than 0.");
        }
        if (iArray == null) {
            iArray = new int[w * h * this.numBands];
        }
        int outOffset = 0;
        int maxX = x + w;
        int maxY = y + h;
        int yy = x;
        while (yy < maxY) {
            int xx = x;
            while (xx < maxX) {
                int b = 0;
                while (b < this.numBands) {
                    int offset = this.bandOffsets[b] + yy * this.scanlineStride + xx;
                    iArray[outOffset++] = data.getElem(this.bankIndices[b], offset);
                    ++b;
                }
                ++xx;
            }
            ++yy;
        }
        return iArray;
    }

    public int getSample(int x, int y, int b, DataBuffer data) {
        int offset = this.bandOffsets[b] + y * this.scanlineStride + x;
        return data.getElem(this.bankIndices[b], offset);
    }

    public float getSampleFloat(int x, int y, int b, DataBuffer data) {
        int offset = this.bandOffsets[b] + y * this.scanlineStride + x;
        return data.getElemFloat(this.bankIndices[b], offset);
    }

    public double getSampleDouble(int x, int y, int b, DataBuffer data) {
        int offset = this.bandOffsets[b] + y * this.scanlineStride + x;
        return data.getElemDouble(this.bankIndices[b], offset);
    }

    public int[] getSamples(int x, int y, int w, int h, int b, int[] iArray, DataBuffer data) {
        if (x < 0 || y < 0) {
            throw new ArrayIndexOutOfBoundsException("x and y must not be less than 0.");
        }
        if (iArray == null) {
            iArray = new int[w * h];
        }
        int outOffset = 0;
        int maxX = x + w;
        int maxY = y + h;
        int yy = y;
        while (yy < maxY) {
            int xx = x;
            while (xx < maxX) {
                int offset = this.bandOffsets[b] + yy * this.scanlineStride + xx;
                iArray[outOffset++] = data.getElem(this.bankIndices[b], offset);
                ++xx;
            }
            ++yy;
        }
        return iArray;
    }

    public void setDataElements(int x, int y, Object obj, DataBuffer data) {
        int transferType = this.getTransferType();
        if (this.getTransferType() != data.getDataType()) {
            throw new IllegalArgumentException("transfer type (" + this.getTransferType() + "), " + "does not match data " + "buffer type (" + data.getDataType() + ").");
        }
        int offset = y * this.scanlineStride + x;
        try {
            switch (transferType) {
                case 0: {
                    DataBufferByte out = (DataBufferByte)data;
                    byte[] in = (byte[])obj;
                    int i = 0;
                    while (i < this.numBands) {
                        out.getData((int)this.bankIndices[i])[offset + this.bandOffsets[i]] = in[i];
                        ++i;
                    }
                    return;
                }
                case 2: {
                    DataBufferShort out = (DataBufferShort)data;
                    short[] in = (short[])obj;
                    int i = 0;
                    while (i < this.numBands) {
                        out.getData((int)this.bankIndices[i])[offset + this.bandOffsets[i]] = in[i];
                        ++i;
                    }
                    return;
                }
                case 1: {
                    DataBufferUShort out = (DataBufferUShort)data;
                    short[] in = (short[])obj;
                    int i = 0;
                    while (i < this.numBands) {
                        out.getData((int)this.bankIndices[i])[offset + this.bandOffsets[i]] = in[i];
                        ++i;
                    }
                    return;
                }
                case 3: {
                    DataBufferInt out = (DataBufferInt)data;
                    int[] in = (int[])obj;
                    int i = 0;
                    while (i < this.numBands) {
                        out.getData((int)this.bankIndices[i])[offset + this.bandOffsets[i]] = in[i];
                        ++i;
                    }
                    return;
                }
                case 4: {
                    DataBufferFloat out = (DataBufferFloat)data;
                    float[] in = (float[])obj;
                    int i = 0;
                    while (i < this.numBands) {
                        out.getData((int)this.bankIndices[i])[offset + this.bandOffsets[i]] = in[i];
                        ++i;
                    }
                    return;
                }
                case 5: {
                    DataBufferDouble out = (DataBufferDouble)data;
                    double[] in = (double[])obj;
                    int i = 0;
                    while (i < this.numBands) {
                        out.getData((int)this.bankIndices[i])[offset + this.bandOffsets[i]] = in[i];
                        ++i;
                    }
                    return;
                }
            }
            throw new ClassCastException("Unsupported data type");
        }
        catch (ArrayIndexOutOfBoundsException aioobe) {
            String msg = "While writing data elements, x=" + x + ", y=" + y + ", width=" + this.width + ", height=" + this.height + ", scanlineStride=" + this.scanlineStride + ", offset=" + offset + ", data.getSize()=" + data.getSize() + ", data.getOffset()=" + data.getOffset() + ": " + aioobe;
            throw new ArrayIndexOutOfBoundsException(msg);
        }
    }

    public void setPixel(int x, int y, int[] iArray, DataBuffer data) {
        int b = 0;
        while (b < this.numBands) {
            data.setElem(this.bankIndices[b], this.bandOffsets[b] + y * this.scanlineStride + x, iArray[b]);
            ++b;
        }
    }

    public void setPixels(int x, int y, int w, int h, int[] iArray, DataBuffer data) {
        int inOffset = 0;
        int hh = 0;
        while (hh < h) {
            int ww = 0;
            while (ww < w) {
                int offset = y * this.scanlineStride + (x + ww);
                int b = 0;
                while (b < this.numBands) {
                    data.setElem(this.bankIndices[b], this.bandOffsets[b] + offset, iArray[inOffset++]);
                    ++b;
                }
                ++ww;
            }
            ++y;
            ++hh;
        }
    }

    public void setSample(int x, int y, int b, int s, DataBuffer data) {
        data.setElem(this.bankIndices[b], this.bandOffsets[b] + y * this.scanlineStride + x, s);
    }

    public void setSample(int x, int y, int b, float s, DataBuffer data) {
        data.setElemFloat(this.bankIndices[b], this.bandOffsets[b] + y * this.scanlineStride + x, s);
    }

    public void setSample(int x, int y, int b, double s, DataBuffer data) {
        data.setElemDouble(this.bankIndices[b], this.bandOffsets[b] + y * this.scanlineStride + x, s);
    }

    public void setSamples(int x, int y, int w, int h, int b, int[] iArray, DataBuffer data) {
        if (x < 0 || y < 0) {
            throw new ArrayIndexOutOfBoundsException("x and y must not be less than 0.");
        }
        int inOffset = 0;
        switch (this.getTransferType()) {
            case 0: {
                DataBufferByte out = (DataBufferByte)data;
                byte[] bank = out.getData(this.bankIndices[b]);
                int hh = 0;
                while (hh < h) {
                    int ww = 0;
                    while (ww < w) {
                        int offset = this.bandOffsets[b] + y * this.scanlineStride + (x + ww);
                        bank[offset] = (byte)iArray[inOffset++];
                        ++ww;
                    }
                    ++y;
                    ++hh;
                }
                return;
            }
            case 2: {
                DataBufferShort out = (DataBufferShort)data;
                short[] bank = out.getData(this.bankIndices[b]);
                int hh = 0;
                while (hh < h) {
                    int ww = 0;
                    while (ww < w) {
                        int offset = this.bandOffsets[b] + y * this.scanlineStride + (x + ww);
                        bank[offset] = (short)iArray[inOffset++];
                        ++ww;
                    }
                    ++y;
                    ++hh;
                }
                return;
            }
            case 1: {
                DataBufferShort out = (DataBufferShort)data;
                short[] bank = out.getData(this.bankIndices[b]);
                int hh = 0;
                while (hh < h) {
                    int ww = 0;
                    while (ww < w) {
                        int offset = this.bandOffsets[b] + y * this.scanlineStride + (x + ww);
                        bank[offset] = (short)iArray[inOffset++];
                        ++ww;
                    }
                    ++y;
                    ++hh;
                }
                return;
            }
            case 3: {
                DataBufferInt out = (DataBufferInt)data;
                int[] bank = out.getData(this.bankIndices[b]);
                int hh = 0;
                while (hh < h) {
                    int ww = 0;
                    while (ww < w) {
                        int offset = this.bandOffsets[b] + y * this.scanlineStride + (x + ww);
                        bank[offset] = iArray[inOffset++];
                        ++ww;
                    }
                    ++y;
                    ++hh;
                }
                return;
            }
            case 4: 
            case 5: {
                break;
            }
            default: {
                throw new ClassCastException("Unsupported data type");
            }
        }
        int hh = 0;
        while (hh < h) {
            int ww = 0;
            while (ww < w) {
                int offset = this.bandOffsets[b] + y * this.scanlineStride + (x + ww);
                data.setElem(this.bankIndices[b], offset, iArray[inOffset++]);
                ++ww;
            }
            ++y;
            ++hh;
        }
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append(this.getClass().getName());
        result.append("[");
        result.append("scanlineStride=").append(this.scanlineStride);
        int i = 0;
        while (i < this.bitMasks.length) {
            result.append(", mask[").append(i).append("]=0x").append(Integer.toHexString(this.bitMasks[i]));
            ++i;
        }
        result.append("]");
        return result.toString();
    }
}

