/*
 * Decompiled with CFR 0.152.
 */
package gnu.xml.xpath;

import gnu.xml.xpath.Expr;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import org.w3c.dom.Node;

final class ConcatFunction
extends Expr {
    final List args;

    ConcatFunction(List args) {
        this.args = args;
    }

    public Object evaluate(Node context, int pos, int len) {
        StringBuffer buf = new StringBuffer();
        for (Expr arg : this.args) {
            Object val = arg.evaluate(context, pos, len);
            buf.append(ConcatFunction._string(context, val));
        }
        return buf.toString();
    }

    public Expr clone(Object context) {
        int len = this.args.size();
        ArrayList<Expr> args2 = new ArrayList<Expr>(len);
        int i = 0;
        while (i < len) {
            args2.add(((Expr)this.args.get(i)).clone(context));
            ++i;
        }
        return new ConcatFunction(args2);
    }

    public boolean references(QName var) {
        Iterator i = this.args.iterator();
        while (i.hasNext()) {
            if (!((Expr)i.next()).references(var)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer("concat(");
        int len = this.args.size();
        int i = 0;
        while (i < len) {
            if (i > 0) {
                buf.append(',');
            }
            buf.append(this.args.get(i));
            ++i;
        }
        buf.append(')');
        return buf.toString();
    }
}

