/*
 * Decompiled with CFR 0.152.
 */
package gnu.xml.transform;

import gnu.xml.transform.Stylesheet;
import gnu.xml.transform.TemplateNode;
import gnu.xml.xpath.Expr;
import javax.xml.namespace.QName;
import javax.xml.transform.TransformerException;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

final class TextNode
extends TemplateNode {
    final boolean disableOutputEscaping;

    TextNode(boolean disableOutputEscaping) {
        this.disableOutputEscaping = disableOutputEscaping;
    }

    TemplateNode clone(Stylesheet stylesheet) {
        TextNode ret = new TextNode(this.disableOutputEscaping);
        if (this.children != null) {
            ret.children = this.children.clone(stylesheet);
        }
        if (this.next != null) {
            ret.next = this.next.clone(stylesheet);
        }
        return ret;
    }

    void doApply(Stylesheet stylesheet, QName mode, Node context, int pos, int len, Node parent, Node nextSibling) throws TransformerException {
        Document doc;
        String value = "";
        Document document = doc = parent instanceof Document ? (Document)parent : parent.getOwnerDocument();
        if (this.children != null) {
            DocumentFragment fragment = doc.createDocumentFragment();
            this.children.apply(stylesheet, mode, context, pos, len, fragment, null);
            value = Expr.stringValue(fragment);
        }
        Text text = doc.createTextNode(value);
        if (this.disableOutputEscaping) {
            text.setUserData("disable-output-escaping", "yes", stylesheet);
        }
        if (nextSibling != null) {
            parent.insertBefore(text, nextSibling);
        } else {
            parent.appendChild(text);
        }
        if (this.next != null) {
            this.next.apply(stylesheet, mode, context, pos, len, parent, nextSibling);
        }
    }

    public String toString() {
        StringBuffer buf = new StringBuffer("text");
        if (this.disableOutputEscaping) {
            buf.append('[');
            buf.append("disable-output-escaping");
            buf.append(']');
        }
        return buf.toString();
    }
}

