/*
 * Decompiled with CFR 0.152.
 */
package gnu.xml.transform;

import gnu.xml.transform.Stylesheet;
import gnu.xml.transform.TemplateNode;
import gnu.xml.transform.WithParam;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.transform.TransformerException;
import org.w3c.dom.Node;

final class CallTemplateNode
extends TemplateNode {
    final QName name;
    final List withParams;

    CallTemplateNode(QName name, List withParams) {
        this.name = name;
        this.withParams = withParams;
    }

    TemplateNode clone(Stylesheet stylesheet) {
        int len = this.withParams.size();
        ArrayList<WithParam> withParams2 = new ArrayList<WithParam>(len);
        int i = 0;
        while (i < len) {
            withParams2.add(((WithParam)this.withParams.get(i)).clone(stylesheet));
            ++i;
        }
        CallTemplateNode ret = new CallTemplateNode(this.name, withParams2);
        if (this.children != null) {
            ret.children = this.children.clone(stylesheet);
        }
        if (this.next != null) {
            ret.next = this.next.clone(stylesheet);
        }
        return ret;
    }

    void doApply(Stylesheet stylesheet, QName mode, Node context, int pos, int len, Node parent, Node nextSibling) throws TransformerException {
        TemplateNode t = stylesheet.getTemplate(mode, this.name);
        if (t != null) {
            if (this.withParams != null) {
                LinkedList<Object[]> values = new LinkedList<Object[]>();
                for (WithParam p : this.withParams) {
                    if (!t.hasParam(p.name)) continue;
                    Object value = p.getValue(stylesheet, mode, context, pos, len);
                    Object[] pair = new Object[]{p.name, value};
                    values.add(pair);
                }
                stylesheet.bindings.push(2);
                for (Object[] pair : values) {
                    QName name = (QName)pair[0];
                    Object value = pair[1];
                    stylesheet.bindings.set(name, value, 2);
                    if (!stylesheet.debug) continue;
                    System.err.println("with-param: " + name + " = " + value);
                }
            }
            t.apply(stylesheet, mode, context, pos, len, parent, nextSibling);
            if (this.withParams != null) {
                stylesheet.bindings.pop(2);
            }
        }
        if (this.next != null) {
            this.next.apply(stylesheet, mode, context, pos, len, parent, nextSibling);
        }
    }

    public boolean references(QName var) {
        if (this.withParams != null) {
            Iterator i = this.withParams.iterator();
            while (i.hasNext()) {
                if (!((WithParam)i.next()).references(var)) continue;
                return true;
            }
        }
        return super.references(var);
    }

    public String toString() {
        StringBuffer buf = new StringBuffer("call-template");
        buf.append('[');
        buf.append("name=");
        buf.append(this.name);
        buf.append(']');
        return buf.toString();
    }
}

