/*
 * Decompiled with CFR 0.152.
 */
package gnu.xml.stream;

import gnu.xml.stream.XMLParser;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashSet;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.util.ReaderDelegate;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.TypeInfo;
import org.w3c.dom.traversal.DocumentTraversal;
import org.w3c.dom.traversal.TreeWalker;
import org.w3c.dom.xpath.XPathEvaluator;
import org.w3c.dom.xpath.XPathResult;
import org.xml.sax.SAXException;

class XIncludeFilter
extends ReaderDelegate {
    static final String XINCLUDE_NS_URI = "http://www.w3.org/2001/XInclude";
    static final int SHOW_FLAGS = 221;
    final String systemId;
    final boolean namespaceAware;
    final boolean validating;
    final boolean expandERefs;
    String href;
    int event;
    boolean included;
    XPathResult result;
    int snapshotIndex;
    Node current;
    TreeWalker walker;
    HashSet seen = new HashSet();
    boolean backtracking;
    boolean lookahead;
    Reader includedText;
    char[] buf;
    int len = -1;
    boolean inInclude;
    boolean inFallback;
    boolean seenFallback;
    DocumentBuilder builder;

    XIncludeFilter(XMLStreamReader reader, String systemId, boolean namespaceAware, boolean validating, boolean expandERefs) {
        super(reader);
        this.systemId = XMLParser.absolutize(null, systemId);
        this.namespaceAware = namespaceAware;
        this.validating = validating;
        this.expandERefs = expandERefs;
    }

    public int getAttributeCount() {
        if (this.current != null) {
            NamedNodeMap attrs = this.current.getAttributes();
            return attrs == null ? 0 : attrs.getLength();
        }
        return super.getAttributeCount();
    }

    public String getAttributeLocalName(int index) {
        if (this.current != null) {
            NamedNodeMap attrs = this.current.getAttributes();
            if (attrs == null) {
                return null;
            }
            Node attr = attrs.item(index);
            return attr.getLocalName();
        }
        return super.getAttributeLocalName(index);
    }

    public String getAttributeNamespace(int index) {
        if (this.current != null) {
            NamedNodeMap attrs = this.current.getAttributes();
            if (attrs == null) {
                return null;
            }
            Node attr = attrs.item(index);
            return attr.getNamespaceURI();
        }
        return super.getAttributeNamespace(index);
    }

    public String getAttributePrefix(int index) {
        if (this.current != null) {
            NamedNodeMap attrs = this.current.getAttributes();
            if (attrs == null) {
                return null;
            }
            Node attr = attrs.item(index);
            return attr.getPrefix();
        }
        return super.getAttributePrefix(index);
    }

    public QName getAttributeName(int index) {
        if (this.current != null) {
            NamedNodeMap attrs = this.current.getAttributes();
            if (attrs == null) {
                return null;
            }
            Node attr = attrs.item(index);
            String localName = attr.getLocalName();
            String uri = attr.getNamespaceURI();
            String prefix = attr.getPrefix();
            return new QName(uri, localName, prefix);
        }
        return super.getAttributeName(index);
    }

    public String getAttributeType(int index) {
        if (this.current != null) {
            NamedNodeMap attrs = this.current.getAttributes();
            if (attrs == null) {
                return null;
            }
            Attr attr = (Attr)attrs.item(index);
            TypeInfo ti = attr.getSchemaTypeInfo();
            return ti == null ? "CDATA" : ti.getTypeName();
        }
        return super.getAttributeType(index);
    }

    public boolean isAttributeSpecified(int index) {
        if (this.current != null) {
            NamedNodeMap attrs = this.current.getAttributes();
            if (attrs == null) {
                return false;
            }
            Attr attr = (Attr)attrs.item(index);
            return attr.getSpecified();
        }
        return super.isAttributeSpecified(index);
    }

    public String getAttributeValue(int index) {
        if (this.current != null) {
            NamedNodeMap attrs = this.current.getAttributes();
            if (attrs == null) {
                return null;
            }
            Node attr = attrs.item(index);
            return attr.getNodeValue();
        }
        return super.getAttributeValue(index);
    }

    public String getAttributeValue(String uri, String localName) {
        if (this.current != null) {
            NamedNodeMap attrs = this.current.getAttributes();
            if (attrs == null) {
                return null;
            }
            Node attr = attrs.getNamedItemNS(uri, localName);
            return attr == null ? null : attr.getNodeValue();
        }
        return super.getAttributeValue(uri, localName);
    }

    public String getElementText() throws XMLStreamException {
        if (this.current != null) {
            return this.current.getTextContent();
        }
        return super.getElementText();
    }

    public int getEventType() {
        return this.event;
    }

    public String getLocalName() {
        if (this.current != null) {
            return this.current.getLocalName();
        }
        return super.getLocalName();
    }

    public QName getName() {
        if (this.current != null) {
            String localName = this.current.getLocalName();
            String uri = this.current.getNamespaceURI();
            String prefix = this.current.getPrefix();
            return new QName(uri, localName, prefix);
        }
        return super.getName();
    }

    public String getNamespaceURI() {
        if (this.current != null) {
            return this.current.getNamespaceURI();
        }
        return super.getNamespaceURI();
    }

    public String getPIData() {
        if (this.current != null) {
            return ((ProcessingInstruction)this.current).getData();
        }
        return super.getPIData();
    }

    public String getPITarget() {
        if (this.current != null) {
            return ((ProcessingInstruction)this.current).getTarget();
        }
        return super.getPITarget();
    }

    public String getPrefix() {
        if (this.current != null) {
            return this.current.getPrefix();
        }
        return super.getPrefix();
    }

    public String getText() {
        Node n;
        if (this.current != null) {
            return this.current.getNodeValue();
        }
        if (this.walker != null && (n = this.walker.getCurrentNode()) != null) {
            return n.getTextContent();
        }
        if (this.buf != null) {
            return new String(this.buf, 0, this.len);
        }
        return super.getText();
    }

    public char[] getTextCharacters() {
        if (this.current != null) {
            this.buf = this.current.getNodeValue().toCharArray();
            this.len = this.buf.length;
        }
        if (this.buf != null) {
            return this.buf;
        }
        return super.getTextCharacters();
    }

    public int getTextCharacters(int sourceStart, char[] target, int targetStart, int length) throws XMLStreamException {
        if (this.current != null) {
            this.buf = this.current.getNodeValue().toCharArray();
            this.len = this.buf.length;
        }
        if (this.buf != null) {
            int max = Math.min(this.len - sourceStart, length);
            if (max > 0) {
                System.arraycopy(this.buf, sourceStart, target, targetStart, max);
            }
            return max;
        }
        return super.getTextCharacters(sourceStart, target, targetStart, length);
    }

    public int getTextLength() {
        if (this.current != null) {
            this.buf = this.current.getNodeValue().toCharArray();
            this.len = this.buf.length;
        }
        if (this.buf != null) {
            return this.len;
        }
        return super.getTextLength();
    }

    public int getTextStart() {
        if (this.current != null) {
            this.buf = this.current.getNodeValue().toCharArray();
            this.len = this.buf.length;
        }
        if (this.buf != null) {
            return 0;
        }
        return super.getTextStart();
    }

    public boolean hasNext() throws XMLStreamException {
        if (!this.lookahead) {
            try {
                this.next();
            }
            catch (NoSuchElementException noSuchElementException) {
                this.event = -1;
            }
            this.lookahead = true;
        }
        return this.event != -1;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int next() throws XMLStreamException {
        if (this.lookahead) {
            this.lookahead = false;
            return this.event;
        }
        this.buf = null;
        this.len = 0;
        if (this.walker != null) {
            Node c = this.walker.getCurrentNode();
            Node n = null;
            if (c.getNodeType() == 1) {
                boolean isStartElement;
                boolean bl = isStartElement = !this.seen.contains(c);
                if (isStartElement) {
                    this.seen.add(c);
                    this.current = c;
                    this.event = 1;
                    return this.event;
                }
                if (this.backtracking) {
                    n = this.walker.nextSibling();
                    if (n != null) {
                        this.backtracking = false;
                    }
                } else {
                    n = this.walker.firstChild();
                    if (n == null) {
                        n = this.walker.nextSibling();
                    }
                }
            } else {
                n = this.walker.firstChild();
                if (n == null) {
                    n = this.walker.nextSibling();
                }
            }
            if (n == null) {
                this.current = this.walker.parentNode();
                if (this.current != null && this.current.getNodeType() == 1) {
                    this.backtracking = true;
                    this.event = 2;
                    return this.event;
                }
                this.walker = null;
                this.current = null;
            } else {
                this.current = n;
                switch (n.getNodeType()) {
                    case 1: {
                        return this.next();
                    }
                    case 3: {
                        String text = n.getNodeValue();
                        this.buf = text.toCharArray();
                        this.len = this.buf.length;
                        this.event = this.isSpace(this.buf, this.len) ? 6 : 4;
                        return this.event;
                    }
                    case 4: {
                        this.event = 12;
                        return this.event;
                    }
                    case 8: {
                        this.event = 5;
                        return this.event;
                    }
                    case 7: {
                        this.event = 3;
                        return this.event;
                    }
                    case 5: {
                        this.event = 9;
                        return this.event;
                    }
                }
                throw new IllegalStateException();
            }
        }
        if (this.result != null) {
            switch (this.result.getResultType()) {
                case 3: {
                    boolean bval = this.result.getBooleanValue();
                    String btext = bval ? "true" : "false";
                    this.buf = btext.toCharArray();
                    this.len = this.buf.length;
                    this.result = null;
                    this.event = 4;
                    return this.event;
                }
                case 1: {
                    double nval = this.result.getNumberValue();
                    String ntext = new Double(nval).toString();
                    this.buf = ntext.toCharArray();
                    this.len = this.buf.length;
                    this.result = null;
                    this.event = 4;
                    return this.event;
                }
                case 2: {
                    String stext = this.result.getStringValue();
                    this.buf = stext.toCharArray();
                    this.len = this.buf.length;
                    this.result = null;
                    this.event = this.isSpace(this.buf, this.len) ? 6 : 4;
                    return this.event;
                }
                case 8: 
                case 9: {
                    Node n1 = this.result.getSingleNodeValue();
                    Document d1 = this.getDocument(n1);
                    this.walker = this.getDocumentTraversal(d1).createTreeWalker(n1, 221, null, this.expandERefs);
                    this.result = null;
                    return this.next();
                }
                case 4: 
                case 5: {
                    Node n2 = this.result.iterateNext();
                    if (n2 == null) {
                        this.result = null;
                        return this.next();
                    }
                    Document d2 = this.getDocument(n2);
                    this.walker = this.getDocumentTraversal(d2).createTreeWalker(n2, 221, null, this.expandERefs);
                    return this.next();
                }
                case 6: 
                case 7: {
                    Node n3 = this.result.snapshotItem(this.snapshotIndex++);
                    if (n3 == null) {
                        this.result = null;
                        return this.next();
                    }
                    Document d3 = this.getDocument(n3);
                    this.walker = this.getDocumentTraversal(d3).createTreeWalker(n3, 221, null, this.expandERefs);
                    return this.next();
                }
            }
            throw new IllegalStateException();
        }
        if (this.includedText != null) {
            if (this.buf == null) {
                this.buf = new char[2048];
            }
            try {
                this.len = this.includedText.read(this.buf, 0, this.buf.length);
                if (this.len == -1) {
                    this.includedText = null;
                    this.buf = null;
                    return this.next();
                }
                this.event = this.isSpace(this.buf, this.len) ? 6 : 4;
                return this.event;
            }
            catch (IOException e) {
                XMLStreamException e2 = new XMLStreamException(e.getMessage());
                e2.initCause(e);
                throw e2;
            }
        }
        this.event = super.next();
        switch (this.event) {
            case 1: {
                String uri = this.getNamespaceURI();
                if (!XINCLUDE_NS_URI.equals(uri)) break;
                String localName = this.getLocalName();
                if ("include".equals(localName)) {
                    String acceptLanguage;
                    String accept;
                    String encoding;
                    String xpointer;
                    this.href = this.getAttributeValue(null, "href");
                    String parse = this.getAttributeValue(null, "parse");
                    if (this.includeResource(this.href, parse, xpointer = this.getAttributeValue(null, "xpointer"), encoding = this.getAttributeValue(null, "encoding"), accept = this.getAttributeValue(null, "accept"), acceptLanguage = this.getAttributeValue(null, "accept-language"))) {
                        int depth = 0;
                        while (depth >= 0) {
                            this.event = super.next();
                            switch (this.event) {
                                case 1: {
                                    ++depth;
                                    break;
                                }
                                case 2: {
                                    --depth;
                                }
                            }
                        }
                        return this.next();
                    } else {
                        this.inInclude = true;
                    }
                    return this.next();
                } else if (this.inInclude && "fallback".equals(localName)) {
                    if (this.seenFallback) throw new XMLStreamException("duplicate xi:fallback element");
                    this.seenFallback = true;
                    this.inFallback = true;
                    return this.next();
                } else {
                    if (!this.inInclude) return this.next();
                    throw new XMLStreamException("illegal xi element '" + localName + "'");
                }
            }
            case 2: {
                String uri2 = this.getNamespaceURI();
                if (!XINCLUDE_NS_URI.equals(uri2)) break;
                String localName = this.getLocalName();
                if ("include".equals(localName)) {
                    if (!this.seenFallback && this.included) {
                        String msg = "Unable to read " + this.href + " and no xi:fallback element present";
                        throw new XMLStreamException(msg);
                    }
                    this.included = false;
                    this.href = null;
                    this.seenFallback = false;
                    this.inFallback = false;
                    this.inInclude = false;
                    return this.next();
                } else {
                    if (!"fallback".equals(localName)) return this.next();
                    this.inFallback = false;
                }
                return this.next();
            }
        }
        if (!this.inInclude || this.inFallback) return this.event;
        return this.next();
    }

    boolean isSpace(char[] text, int len) {
        boolean space = true;
        int i = 0;
        while (i < len) {
            char c = text[i];
            if (c != ' ' && c != '\t' && c != '\n' && c != '\r') {
                space = false;
                break;
            }
            ++i;
        }
        return space;
    }

    String getBaseURI() {
        String base = (String)this.getParent().getProperty("gnu.xml.stream.baseURI");
        return base == null ? this.systemId : base;
    }

    /*
     * Unable to fully structure code
     */
    boolean includeResource(String href, String parse, String xpointer, String encoding, String accept, String acceptLanguage) {
        this.included = false;
        try {
            block20: {
                block18: {
                    block19: {
                        if (xpointer != null) {
                            throw new XMLStreamException("xpointer attribute not yet supported");
                        }
                        base = this.getBaseURI();
                        href = href == null || "".equals(href) != false ? base : XMLParser.absolutize(base, href);
                        if (parse != null && !"xml".equals(parse)) break block18;
                        this.seen.clear();
                        this.result = null;
                        this.snapshotIndex = 0;
                        this.walker = null;
                        this.current = null;
                        this.backtracking = false;
                        connection = this.getURLConnection(href, accept, acceptLanguage);
                        in = connection.getInputStream();
                        doc = this.getDocumentBuilder().parse(in, href);
                        dt = this.getDocumentTraversal(doc);
                        if (xpointer != null) break block19;
                        this.result = null;
                        item = doc.getDocumentElement();
                        this.walker = dt.createTreeWalker(item, 221, null, this.expandERefs);
                        break block20;
                    }
                    this.result = null;
                    this.snapshotIndex = 0;
                    this.walker = null;
                    lpi = xpointer.indexOf(40);
                    rpi = xpointer.indexOf(41, lpi);
                    if (lpi == -1 || rpi == -1) ** GOTO lbl65
                    scheme = xpointer.substring(0, lpi);
                    if ("element".equals(scheme)) {
                        elementSchemeData = xpointer.substring(lpi + 1, rpi);
                        item = doc;
                        si = elementSchemeData.indexOf(47);
                        if (si == -1) {
                            if (elementSchemeData.length() > 0) {
                                item = doc.getElementById(elementSchemeData);
                            }
                        } else {
                            if (si > 0) {
                                context = elementSchemeData.substring(0, si);
                                item = doc.getElementById(context);
                                elementSchemeData = elementSchemeData.substring(si + 1);
                            }
                            st = new StringTokenizer(elementSchemeData, "/");
                            while (st.hasMoreTokens() && item != null) {
                                n = Integer.parseInt(st.nextToken());
                                ctx = item.getFirstChild();
                                count = 1;
                                while (ctx != null && count++ < n) {
                                    ctx = ctx.getNextSibling();
                                }
                                item = ctx;
                            }
                        }
                        this.walker = dt.createTreeWalker(item, 221, null, this.expandERefs);
                        this.included = true;
                    } else if ("xpointer".equals(scheme)) {
                        xpointer = xpointer.substring(lpi + 1, rpi);
                        eval = this.getXPathEvaluator(doc);
                        resolver = eval.createNSResolver(doc);
                        this.result = (XPathResult)eval.evaluate(xpointer, doc, resolver, (short)0, null);
                        this.included = true;
                    } else {
                        msg = "Unknown XPointer scheme: " + scheme;
                        throw new XMLStreamException(msg);
lbl65:
                        // 1 sources

                        item = doc.getElementById(xpointer);
                        this.walker = dt.createTreeWalker(item, 221, null, this.expandERefs);
                        this.included = true;
                    }
                    break block20;
                }
                if ("text".equals(parse)) {
                    connection = this.getURLConnection(href, accept, acceptLanguage);
                    in = connection.getInputStream();
                    if (encoding == null && (encoding = connection.getContentEncoding()) == null && (contentType = connection.getContentType()) != null) {
                        encoding = XIncludeFilter.getParameter(contentType, "charset");
                    }
                    this.includedText = encoding == null ? new InputStreamReader(in, "UTF-8") : new InputStreamReader(in, encoding);
                    this.included = true;
                } else {
                    throw new XMLStreamException("value of 'parse' attribute must be 'xml' or 'text'");
                }
            }
            return true;
        }
        catch (IOException v0) {
            return false;
        }
        catch (XMLStreamException v1) {
            return false;
        }
        catch (SAXException v2) {
            return false;
        }
    }

    URLConnection getURLConnection(String href, String accept, String acceptLanguage) throws IOException {
        URL url = new URL(href);
        URLConnection connection = url.openConnection();
        if (connection instanceof HttpURLConnection) {
            HttpURLConnection http = (HttpURLConnection)connection;
            http.setInstanceFollowRedirects(true);
            if (accept != null) {
                http.setRequestProperty("Accept", accept);
            }
            if (acceptLanguage != null) {
                http.setRequestProperty("Accept-Language", acceptLanguage);
            }
        }
        return connection;
    }

    Document getDocument(Node node2) {
        if (node2.getNodeType() == 9) {
            return (Document)node2;
        }
        return node2.getOwnerDocument();
    }

    DocumentBuilder getDocumentBuilder() throws XMLStreamException {
        if (this.builder == null) {
            try {
                DocumentBuilderFactory f = DocumentBuilderFactory.newInstance();
                f.setXIncludeAware(true);
                f.setNamespaceAware(this.namespaceAware);
                f.setValidating(this.validating);
                this.builder = f.newDocumentBuilder();
            }
            catch (ParserConfigurationException e) {
                XMLStreamException e2 = new XMLStreamException(e.getMessage());
                e2.initCause(e);
                throw e2;
            }
        }
        this.builder.reset();
        return this.builder;
    }

    DocumentTraversal getDocumentTraversal(Document doc) throws XMLStreamException {
        DOMImplementation dom = doc.getImplementation();
        if (!dom.hasFeature("Traversal", "2.0")) {
            throw new XMLStreamException("Traversal not supported");
        }
        return (DocumentTraversal)((Object)doc);
    }

    XPathEvaluator getXPathEvaluator(Document doc) throws XMLStreamException {
        DOMImplementation dom = doc.getImplementation();
        if (!dom.hasFeature("XPath", "3.0")) {
            throw new XMLStreamException("XPath not supported");
        }
        return (XPathEvaluator)((Object)doc);
    }

    static String getParameter(String contentType, String name) {
        StringTokenizer st = new StringTokenizer(contentType, " ;");
        if (st.hasMoreTokens()) {
            st.nextToken();
        }
        while (st.hasMoreTokens()) {
            String key;
            String token = st.nextToken();
            int ei = token.indexOf(61);
            if (ei == -1 || !(key = token.substring(0, ei)).equals(name)) continue;
            String value = token.substring(ei + 1);
            int len = value.length();
            if (len > 1 && value.charAt(0) == '\"' && value.charAt(len - 1) == '\"') {
                value = value.substring(1, len - 1);
            } else if (len > 1 && value.charAt(0) == '\'' && value.charAt(len - 1) == '\'') {
                value = value.substring(1, len - 1);
            }
            return value;
        }
        return null;
    }
}

