/*
 * Decompiled with CFR 0.152.
 */
package gnu.xml.pipeline;

import gnu.xml.pipeline.EventConsumer;
import gnu.xml.pipeline.ValidationConsumer;
import gnu.xml.pipeline.WellFormednessFilter;
import gnu.xml.pipeline.XIncludeFilter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.DeclHandler;
import org.xml.sax.ext.DefaultHandler2;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.XMLFilterImpl;

public class EventFilter
implements EventConsumer,
ContentHandler,
DTDHandler,
LexicalHandler,
DeclHandler {
    private ContentHandler docHandler;
    private ContentHandler docNext;
    private DTDHandler dtdHandler;
    private DTDHandler dtdNext;
    private LexicalHandler lexHandler;
    private LexicalHandler lexNext;
    private DeclHandler declHandler;
    private DeclHandler declNext;
    private Locator locator;
    private EventConsumer next;
    private ErrorHandler errHandler;
    public static final String FEATURE_URI = "http://xml.org/sax/features/";
    public static final String PROPERTY_URI = "http://xml.org/sax/properties/";
    public static final String DECL_HANDLER = "http://xml.org/sax/properties/declaration-handler";
    public static final String LEXICAL_HANDLER = "http://xml.org/sax/properties/lexical-handler";
    private static boolean loaded;
    private static Class nsClass;
    private static Class validClass;
    private static Class wfClass;
    private static Class xincClass;

    static ClassLoader getClassLoader() {
        Method m = null;
        try {
            m = Thread.class.getMethod("getContextClassLoader", null);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return EventFilter.class.getClassLoader();
        }
        try {
            return (ClassLoader)m.invoke(Thread.currentThread(), null);
        }
        catch (IllegalAccessException e) {
            throw new UnknownError(e.getMessage());
        }
        catch (InvocationTargetException e) {
            throw new UnknownError(e.getMessage());
        }
    }

    static Class loadClass(ClassLoader classLoader, String className) {
        try {
            if (classLoader == null) {
                return Class.forName(className);
            }
            return classLoader.loadClass(className);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static void loadClasses() {
        ClassLoader loader = EventFilter.getClassLoader();
        nsClass = EventFilter.loadClass(loader, "gnu.xml.pipeline.NSFilter");
        validClass = EventFilter.loadClass(loader, "gnu.xml.pipeline.ValidationConsumer");
        wfClass = EventFilter.loadClass(loader, "gnu.xml.pipeline.WellFormednessFilter");
        xincClass = EventFilter.loadClass(loader, "gnu.xml.pipeline.XIncludeFilter");
        loaded = true;
    }

    public static void bind(XMLReader producer, EventConsumer consumer) {
        boolean prefixes;
        Class<? extends Object> klass = null;
        if (!loaded) {
            EventFilter.loadClasses();
        }
        try {
            producer.setFeature("http://xml.org/sax/features/namespace-prefixes", true);
            prefixes = true;
        }
        catch (SAXException sAXException) {
            prefixes = false;
        }
        while (consumer != null) {
            block22: {
                klass = consumer.getClass();
                if (nsClass != null && nsClass.isAssignableFrom(klass)) {
                    if (!prefixes) break;
                    consumer = ((EventFilter)consumer).getNext();
                } else {
                    if (validClass != null && validClass.isAssignableFrom(klass)) {
                        try {
                            producer.setFeature("http://xml.org/sax/features/validation", true);
                            consumer = ((ValidationConsumer)consumer).getNext();
                            break block22;
                        }
                        catch (SAXException sAXException) {
                            break;
                        }
                    }
                    if (wfClass == null || !wfClass.isAssignableFrom(klass)) break;
                    consumer = ((WellFormednessFilter)consumer).getNext();
                }
            }
            if (consumer != null) continue;
            klass = null;
        }
        if (xincClass != null && klass != null && xincClass.isAssignableFrom(klass)) {
            ((XIncludeFilter)consumer).setSavingPrefixes(prefixes);
        }
        DefaultHandler2 h = new DefaultHandler2();
        if (consumer != null && consumer.getContentHandler() != null) {
            producer.setContentHandler(consumer.getContentHandler());
        } else {
            producer.setContentHandler(h);
        }
        if (consumer != null && consumer.getDTDHandler() != null) {
            producer.setDTDHandler(consumer.getDTDHandler());
        } else {
            producer.setDTDHandler(h);
        }
        try {
            Object dh = consumer != null ? consumer.getProperty(DECL_HANDLER) : null;
            if (dh == null) {
                dh = h;
            }
            producer.setProperty(DECL_HANDLER, dh);
        }
        catch (Exception exception) {}
        try {
            Object lh = consumer != null ? consumer.getProperty(LEXICAL_HANDLER) : null;
            if (lh == null) {
                lh = h;
            }
            producer.setProperty(LEXICAL_HANDLER, lh);
        }
        catch (Exception exception) {}
        if (producer.getErrorHandler() == null) {
            producer.setErrorHandler(h);
        }
        if (consumer != null) {
            consumer.setErrorHandler(producer.getErrorHandler());
        }
    }

    public EventFilter() {
    }

    public EventFilter(EventConsumer consumer) {
        if (consumer == null) {
            return;
        }
        this.next = consumer;
        this.docHandler = this.docNext = consumer.getContentHandler();
        this.dtdHandler = this.dtdNext = consumer.getDTDHandler();
        try {
            this.declHandler = this.declNext = (DeclHandler)consumer.getProperty(DECL_HANDLER);
        }
        catch (SAXException sAXException) {}
        try {
            this.lexHandler = this.lexNext = (LexicalHandler)consumer.getProperty(LEXICAL_HANDLER);
        }
        catch (SAXException sAXException) {}
    }

    public void chainTo(XMLFilterImpl next) {
        if (this.next != null) {
            throw new IllegalStateException();
        }
        this.docNext = next.getContentHandler();
        if (this.docHandler == null) {
            this.docHandler = this.docNext;
        }
        this.dtdNext = next.getDTDHandler();
        if (this.dtdHandler == null) {
            this.dtdHandler = this.dtdNext;
        }
        try {
            this.declNext = (DeclHandler)next.getProperty(DECL_HANDLER);
            if (this.declHandler == null) {
                this.declHandler = this.declNext;
            }
        }
        catch (SAXException sAXException) {}
        try {
            this.lexNext = (LexicalHandler)next.getProperty(LEXICAL_HANDLER);
            if (this.lexHandler == null) {
                this.lexHandler = this.lexNext;
            }
        }
        catch (SAXException sAXException) {}
        if (this.errHandler != null) {
            next.setErrorHandler(this.errHandler);
        }
    }

    public final void setErrorHandler(ErrorHandler handler) {
        this.errHandler = handler;
        if (this.next != null) {
            this.next.setErrorHandler(handler);
        }
    }

    public final ErrorHandler getErrorHandler() {
        return this.errHandler;
    }

    public final EventConsumer getNext() {
        return this.next;
    }

    public final void setContentHandler(ContentHandler h) {
        this.docHandler = h;
    }

    public final ContentHandler getContentHandler() {
        return this.docHandler;
    }

    public final void setDTDHandler(DTDHandler h) {
        this.dtdHandler = h;
    }

    public final DTDHandler getDTDHandler() {
        return this.dtdHandler;
    }

    public final void setProperty(String id, Object o) throws SAXNotRecognizedException, SAXNotSupportedException {
        try {
            Object value = this.getProperty(id);
            if (value == o) {
                return;
            }
            if (DECL_HANDLER.equals(id)) {
                this.declHandler = (DeclHandler)o;
                return;
            }
            if (LEXICAL_HANDLER.equals(id)) {
                this.lexHandler = (LexicalHandler)o;
                return;
            }
            throw new SAXNotSupportedException(id);
        }
        catch (ClassCastException classCastException) {
            throw new SAXNotSupportedException(id);
        }
    }

    public final Object getProperty(String id) throws SAXNotRecognizedException {
        if (DECL_HANDLER.equals(id)) {
            return this.declHandler;
        }
        if (LEXICAL_HANDLER.equals(id)) {
            return this.lexHandler;
        }
        throw new SAXNotRecognizedException(id);
    }

    public Locator getDocumentLocator() {
        return this.locator;
    }

    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
        if (this.docNext != null) {
            this.docNext.setDocumentLocator(locator);
        }
    }

    public void startDocument() throws SAXException {
        if (this.docNext != null) {
            this.docNext.startDocument();
        }
    }

    public void skippedEntity(String name) throws SAXException {
        if (this.docNext != null) {
            this.docNext.skippedEntity(name);
        }
    }

    public void processingInstruction(String target, String data) throws SAXException {
        if (this.docNext != null) {
            this.docNext.processingInstruction(target, data);
        }
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.docNext != null) {
            this.docNext.characters(ch, start, length);
        }
    }

    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        if (this.docNext != null) {
            this.docNext.ignorableWhitespace(ch, start, length);
        }
    }

    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        if (this.docNext != null) {
            this.docNext.startPrefixMapping(prefix, uri);
        }
    }

    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        if (this.docNext != null) {
            this.docNext.startElement(uri, localName, qName, atts);
        }
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (this.docNext != null) {
            this.docNext.endElement(uri, localName, qName);
        }
    }

    public void endPrefixMapping(String prefix) throws SAXException {
        if (this.docNext != null) {
            this.docNext.endPrefixMapping(prefix);
        }
    }

    public void endDocument() throws SAXException {
        if (this.docNext != null) {
            this.docNext.endDocument();
        }
        this.locator = null;
    }

    public void unparsedEntityDecl(String name, String publicId, String systemId, String notationName) throws SAXException {
        if (this.dtdNext != null) {
            this.dtdNext.unparsedEntityDecl(name, publicId, systemId, notationName);
        }
    }

    public void notationDecl(String name, String publicId, String systemId) throws SAXException {
        if (this.dtdNext != null) {
            this.dtdNext.notationDecl(name, publicId, systemId);
        }
    }

    public void startDTD(String name, String publicId, String systemId) throws SAXException {
        if (this.lexNext != null) {
            this.lexNext.startDTD(name, publicId, systemId);
        }
    }

    public void endDTD() throws SAXException {
        if (this.lexNext != null) {
            this.lexNext.endDTD();
        }
    }

    public void comment(char[] ch, int start, int length) throws SAXException {
        if (this.lexNext != null) {
            this.lexNext.comment(ch, start, length);
        }
    }

    public void startCDATA() throws SAXException {
        if (this.lexNext != null) {
            this.lexNext.startCDATA();
        }
    }

    public void endCDATA() throws SAXException {
        if (this.lexNext != null) {
            this.lexNext.endCDATA();
        }
    }

    public void startEntity(String name) throws SAXException {
        if (this.lexNext != null) {
            this.lexNext.startEntity(name);
        }
    }

    public void endEntity(String name) throws SAXException {
        if (this.lexNext != null) {
            this.lexNext.endEntity(name);
        }
    }

    public void elementDecl(String name, String model) throws SAXException {
        if (this.declNext != null) {
            this.declNext.elementDecl(name, model);
        }
    }

    public void attributeDecl(String eName, String aName, String type, String mode, String value) throws SAXException {
        if (this.declNext != null) {
            this.declNext.attributeDecl(eName, aName, type, mode, value);
        }
    }

    public void externalEntityDecl(String name, String publicId, String systemId) throws SAXException {
        if (this.declNext != null) {
            this.declNext.externalEntityDecl(name, publicId, systemId);
        }
    }

    public void internalEntityDecl(String name, String value) throws SAXException {
        if (this.declNext != null) {
            this.declNext.internalEntityDecl(name, value);
        }
    }
}

