/*
 * Decompiled with CFR 0.152.
 */
package gnu.xml.dom;

import gnu.xml.dom.DTDAttributeTypeInfo;
import gnu.xml.dom.DTDElementTypeInfo;
import gnu.xml.dom.DomAttr;
import gnu.xml.dom.DomCDATASection;
import gnu.xml.dom.DomComment;
import gnu.xml.dom.DomDOMException;
import gnu.xml.dom.DomDoctype;
import gnu.xml.dom.DomDocumentConfiguration;
import gnu.xml.dom.DomDocumentFragment;
import gnu.xml.dom.DomElement;
import gnu.xml.dom.DomEntity;
import gnu.xml.dom.DomEntityReference;
import gnu.xml.dom.DomImpl;
import gnu.xml.dom.DomNamedNodeMap;
import gnu.xml.dom.DomNode;
import gnu.xml.dom.DomNodeIterator;
import gnu.xml.dom.DomNotation;
import gnu.xml.dom.DomNsNode;
import gnu.xml.dom.DomProcessingInstruction;
import gnu.xml.dom.DomText;
import gnu.xml.dom.DomXPathExpression;
import gnu.xml.dom.DomXPathNSResolver;
import java.util.Iterator;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Comment;
import org.w3c.dom.DOMConfiguration;
import org.w3c.dom.DOMException;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.Entity;
import org.w3c.dom.EntityReference;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.Notation;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;
import org.w3c.dom.traversal.DocumentTraversal;
import org.w3c.dom.traversal.NodeFilter;
import org.w3c.dom.traversal.NodeIterator;
import org.w3c.dom.traversal.TreeWalker;
import org.w3c.dom.xpath.XPathEvaluator;
import org.w3c.dom.xpath.XPathException;
import org.w3c.dom.xpath.XPathExpression;
import org.w3c.dom.xpath.XPathNSResolver;

public class DomDocument
extends DomNode
implements Document,
DocumentTraversal,
XPathEvaluator {
    private final DOMImplementation implementation;
    private boolean checkingCharacters = true;
    boolean checkingWellformedness = true;
    private boolean defaultAttributes = true;
    boolean building;
    DomDocumentConfiguration config;
    String inputEncoding;
    String encoding;
    String version = "1.0";
    boolean standalone;
    String systemId;

    public DomDocument() {
        this(new DomImpl());
    }

    protected DomDocument(DOMImplementation impl) {
        super((short)9, null);
        this.implementation = impl;
    }

    public void setBuilding(boolean flag) {
        this.building = flag;
    }

    public void setCheckWellformedness(boolean flag) {
        this.checkingWellformedness = flag;
    }

    public void setCheckingCharacters(boolean flag) {
        this.checkingCharacters = flag;
    }

    public void setDefaultAttributes(boolean flag) {
        this.defaultAttributes = flag;
    }

    public final String getNodeName() {
        return "#document";
    }

    public final Element getDocumentElement() {
        DomNode ctx = this.first;
        while (ctx != null) {
            if (ctx.nodeType == 1) {
                return (Element)((Object)ctx);
            }
            ctx = ctx.next;
        }
        return null;
    }

    public final DocumentType getDoctype() {
        DomNode ctx = this.first;
        while (ctx != null) {
            if (ctx.nodeType == 10) {
                return (DocumentType)((Object)ctx);
            }
            ctx = ctx.next;
        }
        return null;
    }

    public final DOMImplementation getImplementation() {
        return this.implementation;
    }

    /*
     * Unable to fully structure code
     */
    public Element getElementById(String id) {
        if (id == null || id.length() == 0) {
            return null;
        }
        doctype = (DomDoctype)this.getDoctype();
        if (doctype != null && !doctype.hasIds()) {
            doctype = null;
        }
        if ((current = this.getDocumentElement()) != null) ** GOTO lbl33
        return null;
lbl-1000:
        // 1 sources

        {
            if (current.getNodeType() == 1) {
                element = (DomElement)current;
                if (element.userIdAttrs != null) {
                    for (Node idAttr : element.userIdAttrs) {
                        if (!id.equals(idAttr.getNodeValue())) continue;
                        return element;
                    }
                }
                if (doctype != null && (info = doctype.getElementTypeInfo(current.getNodeName())) != null && id.equals(element.getAttribute(info.idAttrName))) {
                    return element;
                }
                xmlId = element.getAttribute("xml:id");
                if (xmlId == null) {
                    xmlId = element.getAttributeNS("http://www.w3.org/XML/1998/namespace", "id");
                }
                if (id.equals(xmlId)) {
                    return element;
                }
            }
            if (current.hasChildNodes()) {
                current = current.getFirstChild();
                continue;
            }
            temp = current.getNextSibling();
            if (temp != null) {
                current = temp;
                continue;
            }
            do {
                if ((temp = current.getParentNode()) != null) continue;
                return null;
            } while ((temp = (current = temp).getNextSibling()) == null);
            current = temp;
lbl33:
            // 4 sources

            ** while (current != this)
        }
lbl34:
        // 1 sources

        return null;
    }

    private void checkNewChild(Node newChild) {
        if (newChild.getNodeType() == 1 && this.getDocumentElement() != null) {
            throw new DomDOMException(3, "document element already present: " + this.getDocumentElement(), newChild, 0);
        }
        if (newChild.getNodeType() == 10 && this.getDoctype() != null) {
            throw new DomDOMException(3, "document type already present: " + this.getDoctype(), newChild, 0);
        }
    }

    public Node appendChild(Node newChild) {
        if (this.checkingWellformedness) {
            this.checkNewChild(newChild);
        }
        return super.appendChild(newChild);
    }

    public Node insertBefore(Node newChild, Node refChild) {
        if (this.checkingWellformedness) {
            this.checkNewChild(newChild);
        }
        return super.insertBefore(newChild, refChild);
    }

    public Node replaceChild(Node newChild, Node refChild) {
        if (this.checkingWellformedness && (newChild.getNodeType() == 1 && refChild.getNodeType() != 1 || newChild.getNodeType() == 10 && refChild.getNodeType() != 10)) {
            this.checkNewChild(newChild);
        }
        return super.replaceChild(newChild, refChild);
    }

    public static void verifyXmlName(String name) {
        DomDocument.checkName(name, false);
    }

    static void checkName(String name, boolean xml11) {
        if (name == null) {
            throw new DomDOMException(14, name, null, 0);
        }
        int len = name.length();
        if (len == 0) {
            throw new DomDOMException(14, name, null, 0);
        }
        char c = name.charAt(0);
        if (xml11) {
            if (!(c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c == ':' || c == '_' || c >= '\u00c0' && c <= '\u00d6' || c >= '\u00d8' && c <= '\u00f6' || c >= '\u00f8' && c <= '\u02ff' || c >= '\u0370' && c <= '\u037d' || c >= '\u037f' && c <= '\u1fff' || c >= '\u200c' && c <= '\u200d' || c >= '\u2070' && c <= '\u218f' || c >= '\u2c00' && c <= '\u2fef' || c >= '\u3001' && c <= '\ud7ff' || c >= '\uf900' && c <= '\ufdcf' || c >= '\ufdf0' && c <= '\ufffd' || c >= '\u10000' && c <= '\ueffff')) {
                throw new DomDOMException(5, name, null, c);
            }
        } else {
            int type = Character.getType(c);
            switch (type) {
                case 1: 
                case 2: 
                case 3: 
                case 5: 
                case 10: {
                    if ((c <= '\uf900' || c >= '\ufffe') && (c < '\u20dd' || c > '\u20e0')) break;
                    throw new DomDOMException(5, name, null, c);
                }
                default: {
                    if (c == ':' || c == '_' || c >= '\u02bb' && c <= '\u02c1' || c == '\u0559' || c == '\u06e5' || c == '\u06e6') break;
                    throw new DomDOMException(5, name, null, c);
                }
            }
        }
        int i = 1;
        while (i < len) {
            c = name.charAt(i);
            if (xml11) {
                if (!(c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c >= '0' && c <= '9' || c == ':' || c == '_' || c == '-' || c == '.' || c >= '\u00c0' && c <= '\u00d6' || c >= '\u00d8' && c <= '\u00f6' || c >= '\u00f8' && c <= '\u02ff' || c >= '\u0370' && c <= '\u037d' || c >= '\u037f' && c <= '\u1fff' || c >= '\u200c' && c <= '\u200d' || c >= '\u2070' && c <= '\u218f' || c >= '\u2c00' && c <= '\u2fef' || c >= '\u3001' && c <= '\ud7ff' || c >= '\uf900' && c <= '\ufdcf' || c >= '\ufdf0' && c <= '\ufffd' || c >= '\u10000' && c <= '\ueffff' || c == '\u00b7' || c >= '\u0300' && c <= '\u036f' || c >= '\u203f' && c <= '\u2040')) {
                    throw new DomDOMException(5, name, null, c);
                }
            } else {
                int type = Character.getType(c);
                switch (type) {
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: 
                    case 9: 
                    case 10: {
                        if ((c <= '\uf900' || c >= '\ufffe') && (c < '\u20dd' || c > '\u20e0')) break;
                        throw new DomDOMException(5, name, null, c);
                    }
                    default: {
                        if (c == '-' || c == '.' || c == ':' || c == '_' || c == '\u0387' || c >= '\u02bb' && c <= '\u02c1' || c == '\u0559' || c == '\u06e5' || c == '\u06e6' || c == '\u00b7') break;
                        throw new DomDOMException(5, name, null, c);
                    }
                }
            }
            ++i;
        }
    }

    static void checkNCName(String name, boolean xml11) {
        DomDocument.checkName(name, xml11);
        int len = name.length();
        int index = name.indexOf(58);
        if (index != -1 && (index == 0 || index == len - 1 || name.lastIndexOf(58) != index)) {
            throw new DomDOMException(14, name, null, 0);
        }
    }

    static void checkChar(String value, boolean xml11) {
        char[] chars = value.toCharArray();
        DomDocument.checkChar(chars, 0, chars.length, xml11);
    }

    static void checkChar(char[] buf, int off, int len, boolean xml11) {
        int i = 0;
        while (i < len) {
            char c = buf[i];
            if (!(c >= ' ' && c <= '\ud7ff' || c == '\n' || c == '\r' || c == '\t' || c >= '\ue000' && c <= '\ufffd' || c >= '\u10000' && c <= '\u10ffff' || xml11 && (c >= '\u0001' && c <= '\u001f' || c >= '\u007f' && c <= '\u0084' || c >= '\u0086' && c <= '\u009f'))) {
                throw new DomDOMException(5, new String(buf, off, len), null, c);
            }
            ++i;
        }
    }

    public Element createElement(String name) {
        Element element;
        if (this.checkingCharacters) {
            DomDocument.checkName(name, "1.1".equals(this.version));
        }
        if (name.startsWith("xml:")) {
            element = this.createElementNS(null, name);
        } else {
            DomElement domElement = new DomElement(this, null, name);
            domElement.localName = null;
            element = domElement;
        }
        if (this.defaultAttributes) {
            this.setDefaultAttributes(element, name);
        }
        return element;
    }

    public Element createElementNS(String namespaceURI, String name) {
        if (this.checkingCharacters) {
            DomDocument.checkNCName(name, "1.1".equals(this.version));
        }
        if ("".equals(namespaceURI)) {
            namespaceURI = null;
        }
        if (name.startsWith("xml:")) {
            if (namespaceURI != null && !"http://www.w3.org/XML/1998/namespace".equals(namespaceURI)) {
                throw new DomDOMException(14, "xml namespace is always http://www.w3.org/XML/1998/namespace", this, 0);
            }
            namespaceURI = "http://www.w3.org/XML/1998/namespace";
        } else {
            if ("xmlns".equals(name) || name.startsWith("xmlns:")) {
                throw new DomDOMException(14, "xmlns is reserved", this, 0);
            }
            if (namespaceURI == null && name.indexOf(58) != -1) {
                throw new DomDOMException(14, "prefixed name '" + name + "' needs a URI", this, 0);
            }
        }
        DomElement element = new DomElement(this, namespaceURI, name);
        if (this.defaultAttributes) {
            this.setDefaultAttributes(element, name);
        }
        return element;
    }

    private void setDefaultAttributes(Element element, String name) {
        DomDoctype doctype = (DomDoctype)this.getDoctype();
        if (doctype == null) {
            return;
        }
        DTDElementTypeInfo info = doctype.getElementTypeInfo(name);
        if (info != null) {
            Iterator i = info.attributes();
            while (i != null && i.hasNext()) {
                DTDAttributeTypeInfo attr = (DTDAttributeTypeInfo)i.next();
                String value = attr.value;
                if ("#IMPLIED".equals(attr.mode) && value == null) continue;
                DomAttr node2 = (DomAttr)this.createAttribute(attr.name);
                if (value == null) {
                    value = "";
                }
                node2.setValue(value);
                node2.setSpecified(false);
                element.setAttributeNode(node2);
            }
        }
    }

    public DocumentFragment createDocumentFragment() {
        return new DomDocumentFragment(this);
    }

    public Text createTextNode(String value) {
        if (this.checkingCharacters) {
            DomDocument.checkChar(value, "1.1".equals(this.version));
        }
        return new DomText(this, value);
    }

    public Text createTextNode(char[] buf, int off, int len) {
        if (this.checkingCharacters) {
            DomDocument.checkChar(buf, off, len, "1.1".equals(this.version));
        }
        return new DomText(this, buf, off, len);
    }

    public Comment createComment(String value) {
        if (this.checkingCharacters) {
            DomDocument.checkChar(value, "1.1".equals(this.version));
        }
        return new DomComment(this, value);
    }

    public CDATASection createCDATASection(String value) {
        if (this.checkingCharacters) {
            DomDocument.checkChar(value, "1.1".equals(this.version));
        }
        return new DomCDATASection(this, value);
    }

    public CDATASection createCDATASection(char[] buf, int off, int len) {
        if (this.checkingCharacters) {
            DomDocument.checkChar(buf, off, len, "1.1".equals(this.version));
        }
        return new DomCDATASection(this, buf, off, len);
    }

    public ProcessingInstruction createProcessingInstruction(String target, String data) {
        if (this.checkingCharacters) {
            boolean xml11 = "1.1".equals(this.version);
            DomDocument.checkName(target, xml11);
            if ("xml".equalsIgnoreCase(target)) {
                throw new DomDOMException(12, "illegal PI target name", this, 0);
            }
            DomDocument.checkChar(data, xml11);
        }
        return new DomProcessingInstruction(this, target, data);
    }

    public Attr createAttribute(String name) {
        if (this.checkingCharacters) {
            DomDocument.checkName(name, "1.1".equals(this.version));
        }
        if (name.startsWith("xml:")) {
            return this.createAttributeNS("http://www.w3.org/XML/1998/namespace", name);
        }
        if ("xmlns".equals(name) || name.startsWith("xmlns:")) {
            return this.createAttributeNS("http://www.w3.org/2000/xmlns/", name);
        }
        DomAttr ret = new DomAttr(this, null, name);
        ret.localName = null;
        return ret;
    }

    public Attr createAttributeNS(String namespaceURI, String name) {
        if (this.checkingCharacters) {
            DomDocument.checkNCName(name, "1.1".equals(this.version));
        }
        if ("".equals(namespaceURI)) {
            namespaceURI = null;
        }
        if (name.startsWith("xml:")) {
            if (namespaceURI == null) {
                namespaceURI = "http://www.w3.org/XML/1998/namespace";
            } else if (!"http://www.w3.org/XML/1998/namespace".equals(namespaceURI)) {
                throw new DomDOMException(14, "xml namespace is always http://www.w3.org/XML/1998/namespace", this, 0);
            }
        } else if ("xmlns".equals(name) || name.startsWith("xmlns:")) {
            if (namespaceURI == null) {
                namespaceURI = "http://www.w3.org/2000/xmlns/";
            } else if (!"http://www.w3.org/2000/xmlns/".equals(namespaceURI)) {
                throw new DomDOMException(14, "xmlns namespace must be http://www.w3.org/2000/xmlns/", this, 0);
            }
        } else if (namespaceURI == null && name.indexOf(58) != -1) {
            throw new DomDOMException(14, "prefixed name needs a URI: " + name, this, 0);
        }
        return new DomAttr(this, namespaceURI, name);
    }

    public EntityReference createEntityReference(String name) {
        DomEntity ent;
        DomEntityReference ret = new DomEntityReference(this, name);
        DocumentType doctype = this.getDoctype();
        if (doctype != null && (ent = (DomEntity)doctype.getEntities().getNamedItem(name)) != null) {
            DomNode ctx = ent.first;
            while (ctx != null) {
                ret.appendChild(ctx.cloneNode(true));
                ctx = ctx.next;
            }
        }
        ret.makeReadonly();
        return ret;
    }

    public Node importNode(Node src, boolean deep) {
        Node dst = null;
        switch (src.getNodeType()) {
            case 3: {
                dst = this.createTextNode(src.getNodeValue());
                break;
            }
            case 4: {
                dst = this.createCDATASection(src.getNodeValue());
                break;
            }
            case 8: {
                dst = this.createComment(src.getNodeValue());
                break;
            }
            case 7: {
                dst = this.createProcessingInstruction(src.getNodeName(), src.getNodeValue());
                break;
            }
            case 12: {
                Notation notation = (Notation)src;
                dst = new DomNotation(this, notation.getNodeName(), notation.getPublicId(), notation.getSystemId());
                break;
            }
            case 6: {
                Entity entity = (Entity)src;
                dst = new DomEntity(this, entity.getNodeName(), entity.getPublicId(), entity.getSystemId(), entity.getNotationName());
                if (!deep) break;
                Node ctx = src.getFirstChild();
                while (ctx != null) {
                    dst.appendChild(this.importNode(ctx, deep));
                    ctx = ctx.getNextSibling();
                }
                break;
            }
            case 5: {
                dst = this.createEntityReference(src.getNodeName());
                break;
            }
            case 11: {
                dst = new DomDocumentFragment(this);
                if (!deep) break;
                Node ctx = src.getFirstChild();
                while (ctx != null) {
                    dst.appendChild(this.importNode(ctx, deep));
                    ctx = ctx.getNextSibling();
                }
                break;
            }
            case 2: {
                String attr_nsuri = src.getNamespaceURI();
                dst = attr_nsuri != null ? this.createAttributeNS(attr_nsuri, src.getNodeName()) : this.createAttribute(src.getNodeName());
                Node ctx = src.getFirstChild();
                while (ctx != null) {
                    dst.appendChild(this.importNode(ctx, false));
                    ctx = ctx.getNextSibling();
                }
                break;
            }
            case 1: {
                String elem_nsuri = src.getNamespaceURI();
                dst = elem_nsuri != null ? this.createElementNS(elem_nsuri, src.getNodeName()) : this.createElement(src.getNodeName());
                NamedNodeMap srcAttrs = src.getAttributes();
                NamedNodeMap dstAttrs = dst.getAttributes();
                int len = srcAttrs.getLength();
                int i = 0;
                while (i < len) {
                    Attr a = (Attr)srcAttrs.item(i);
                    Attr dflt = (Attr)dstAttrs.getNamedItem(a.getNodeName());
                    if (dflt != null) {
                        String newval = a.getNodeValue();
                        if (!dflt.getNodeValue().equals(newval) || a.getSpecified()) {
                            dflt.setNodeValue(newval);
                        }
                    } else {
                        dstAttrs.setNamedItem((Attr)this.importNode(a, false));
                    }
                    ++i;
                }
                if (!deep) break;
                Node ctx = src.getFirstChild();
                while (ctx != null) {
                    dst.appendChild(this.importNode(ctx, true));
                    ctx = ctx.getNextSibling();
                }
                break;
            }
            default: {
                throw new DomDOMException(9, null, src, 0);
            }
        }
        if (src instanceof DomNode) {
            ((DomNode)src).notifyUserDataHandlers((short)2, src, dst);
        }
        return dst;
    }

    public NodeIterator createNodeIterator(Node root, int whatToShow, NodeFilter filter, boolean expandEntities) {
        return new DomNodeIterator(root, whatToShow, filter, expandEntities, false);
    }

    public TreeWalker createTreeWalker(Node root, int whatToShow, NodeFilter filter, boolean expandEntities) {
        return new DomNodeIterator(root, whatToShow, filter, expandEntities, true);
    }

    public String getInputEncoding() {
        return this.inputEncoding;
    }

    public void setInputEncoding(String inputEncoding) {
        this.inputEncoding = inputEncoding;
    }

    public String getXmlEncoding() {
        return this.encoding;
    }

    public void setXmlEncoding(String encoding) {
        this.encoding = encoding;
    }

    public boolean getXmlStandalone() {
        return this.standalone;
    }

    public void setXmlStandalone(boolean xmlStandalone) {
        this.standalone = xmlStandalone;
    }

    public String getXmlVersion() {
        return this.version;
    }

    public void setXmlVersion(String xmlVersion) {
        if (xmlVersion == null) {
            xmlVersion = "1.0";
        }
        if (!"1.0".equals(xmlVersion) && !"1.1".equals(xmlVersion)) {
            throw new DomDOMException(9);
        }
        this.version = xmlVersion;
    }

    public boolean getStrictErrorChecking() {
        return this.checkingCharacters;
    }

    public void setStrictErrorChecking(boolean strictErrorChecking) {
        this.checkingCharacters = strictErrorChecking;
    }

    public String lookupPrefix(String namespaceURI) {
        Element root = this.getDocumentElement();
        return root == null ? null : root.lookupPrefix(namespaceURI);
    }

    public boolean isDefaultNamespace(String namespaceURI) {
        Element root = this.getDocumentElement();
        return root == null ? false : root.isDefaultNamespace(namespaceURI);
    }

    public String lookupNamespaceURI(String prefix) {
        Element root = this.getDocumentElement();
        return root == null ? null : root.lookupNamespaceURI(prefix);
    }

    public String getBaseURI() {
        return this.getDocumentURI();
    }

    public String getDocumentURI() {
        return this.systemId;
    }

    public void setDocumentURI(String documentURI) {
        this.systemId = documentURI;
    }

    public Node adoptNode(Node source) {
        short sourceNodeType = source.getNodeType();
        switch (sourceNodeType) {
            case 9: 
            case 10: {
                throw new DomDOMException(9);
            }
            case 6: 
            case 12: {
                throw new DomDOMException(7);
            }
        }
        if (source instanceof DomNode) {
            DomNode src;
            DomNode dst = src = (DomNode)source;
            if (dst.parent != null) {
                dst = (DomNode)dst.cloneNode(true);
            }
            dst.setOwner(this);
            src.notifyUserDataHandlers((short)5, src, dst);
            return dst;
        }
        Node dst = null;
        switch (sourceNodeType) {
            case 2: {
                Attr src = (Attr)source;
                String nodeName = src.getNodeName();
                String localName = src.getLocalName();
                String namespaceUri = src.getNamespaceURI();
                dst = localName == null ? this.createAttribute(nodeName) : this.createAttributeNS(namespaceUri, nodeName);
                this.adoptChildren(src, dst);
                break;
            }
            case 4: {
                CDATASection src = (CDATASection)source;
                dst = this.createCDATASection(src.getData());
                break;
            }
            case 8: {
                Comment src = (Comment)source;
                dst = this.createComment(src.getData());
                break;
            }
            case 11: {
                DocumentFragment src = (DocumentFragment)source;
                dst = this.createDocumentFragment();
                this.adoptChildren(src, dst);
                break;
            }
            case 1: {
                Element src = (Element)source;
                String nodeName = src.getNodeName();
                String localName = src.getLocalName();
                String namespaceUri = src.getNamespaceURI();
                dst = localName == null ? this.createElement(nodeName) : this.createElementNS(namespaceUri, nodeName);
                this.adoptAttributes(src, dst);
                this.adoptChildren(src, dst);
                break;
            }
            case 5: {
                EntityReference src = (EntityReference)source;
                dst = this.createEntityReference(src.getNodeName());
                this.adoptChildren(src, dst);
                break;
            }
            case 7: {
                ProcessingInstruction src = (ProcessingInstruction)source;
                dst = this.createProcessingInstruction(src.getTarget(), src.getData());
                break;
            }
            case 3: {
                Text src = (Text)source;
                dst = this.createTextNode(src.getData());
            }
        }
        return dst;
    }

    void adoptChildren(Node src, Node dst) {
        Node node2 = src.getFirstChild();
        while (node2 != null) {
            Node next = node2.getNextSibling();
            dst.appendChild(this.adoptNode(node2));
            node2 = next;
        }
    }

    void adoptAttributes(Node src, Node dst) {
        NamedNodeMap srcAttrs = src.getAttributes();
        NamedNodeMap dstAttrs = dst.getAttributes();
        int len = srcAttrs.getLength();
        int i = 0;
        while (i < len) {
            Node node2 = srcAttrs.item(i);
            String localName = node2.getLocalName();
            if (localName == null) {
                dstAttrs.setNamedItem(this.adoptNode(node2));
            } else {
                dstAttrs.setNamedItemNS(this.adoptNode(node2));
            }
            ++i;
        }
    }

    public DOMConfiguration getDomConfig() {
        if (this.config == null) {
            this.config = new DomDocumentConfiguration();
        }
        return this.config;
    }

    public boolean isEqualNode(Node arg) {
        if (!super.isEqualNode(arg)) {
            return false;
        }
        Document d = (Document)arg;
        String dversion = d.getXmlVersion();
        if (dversion == null || !dversion.equals(this.version)) {
            return false;
        }
        boolean dstandalone = d.getXmlStandalone();
        if (dstandalone != this.standalone) {
            return false;
        }
        String dencoding = d.getXmlEncoding();
        return !(dencoding == null || dencoding.equalsIgnoreCase("UTF-8") ? this.encoding != null && !this.encoding.equalsIgnoreCase("UTF-8") : !dencoding.equals(this.encoding));
    }

    public void normalizeDocument() {
        boolean save = this.building;
        this.building = true;
        this.normalizeNode(this);
        this.building = save;
    }

    void normalizeNode(DomNode node2) {
        DomNode ctx;
        node2.normalize();
        if (this.config != null) {
            switch (node2.nodeType) {
                case 4: {
                    if (!this.config.cdataSections) {
                        Text text = this.createTextNode(node2.getNodeValue());
                        node2.parent.insertBefore(text, node2);
                        node2.parent.removeChild(node2);
                        String data = text.getWholeText();
                        node2 = (DomNode)((Object)text.replaceWholeText(data));
                        break;
                    }
                    if (!this.config.splitCdataSections) break;
                    String value = node2.getNodeValue();
                    int i = value.indexOf("]]>");
                    while (i != -1) {
                        CDATASection node22 = this.createCDATASection(value.substring(0, i));
                        node2.parent.insertBefore(node22, node2);
                        value = value.substring(i + 3);
                        node2.setNodeValue(value);
                        i = value.indexOf("]]>");
                    }
                    break;
                }
                case 8: {
                    if (this.config.comments) break;
                    node2.parent.removeChild(node2);
                    break;
                }
                case 3: {
                    if (this.config.elementContentWhitespace || !((Text)((Object)node2)).isElementContentWhitespace()) break;
                    node2.parent.removeChild(node2);
                    break;
                }
                case 5: {
                    if (this.config.entities) break;
                    ctx = node2.first;
                    while (ctx != null) {
                        DomNode ctxNext = ctx.next;
                        node2.parent.insertBefore(ctx, node2);
                        ctx = ctxNext;
                    }
                    node2.parent.removeChild(node2);
                    break;
                }
                case 1: {
                    if (this.config.namespaceDeclarations) break;
                    DomNamedNodeMap attrs = (DomNamedNodeMap)node2.getAttributes();
                    boolean aro = attrs.readonly;
                    attrs.readonly = false;
                    int len = attrs.getLength();
                    int i = 0;
                    while (i < len) {
                        Node attr = attrs.item(i);
                        String namespace = attr.getNamespaceURI();
                        if ("http://www.w3.org/2000/xmlns/".equals(namespace)) {
                            attrs.removeNamedItemNS(namespace, attr.getLocalName());
                            --i;
                            --len;
                        }
                        ++i;
                    }
                    attrs.readonly = aro;
                }
            }
        }
        ctx = node2.first;
        while (ctx != null) {
            DomNode ctxNext = ctx.next;
            this.normalizeNode(ctx);
            ctx = ctxNext;
        }
    }

    public Node renameNode(Node n, String namespaceURI, String qualifiedName) throws DOMException {
        if (n instanceof DomNsNode) {
            DomNsNode src = (DomNsNode)n;
            if (src == null) {
                throw new DomDOMException(8);
            }
            if (src.owner != this) {
                throw new DomDOMException(4, null, src, 0);
            }
            boolean xml11 = "1.1".equals(this.version);
            DomDocument.checkName(qualifiedName, xml11);
            int ci = qualifiedName.indexOf(58);
            if ("".equals(namespaceURI)) {
                namespaceURI = null;
            }
            if (namespaceURI != null) {
                String prefix;
                DomDocument.checkNCName(qualifiedName, xml11);
                String string = prefix = ci == -1 ? "" : qualifiedName.substring(0, ci);
                if ("xml".equals(prefix) && !"http://www.w3.org/XML/1998/namespace".equals(namespaceURI)) {
                    throw new DomDOMException(14, "xml namespace must be http://www.w3.org/XML/1998/namespace", src, 0);
                }
                if (src.nodeType == 2 && ("xmlns".equals(prefix) || "xmlns".equals(qualifiedName)) && !"http://www.w3.org/2000/xmlns/".equals(namespaceURI)) {
                    throw new DomDOMException(14, "xmlns namespace must be http://www.w3.org/2000/xmlns/", src, 0);
                }
                if ("http://www.w3.org/XML/1998/namespace".equals(namespaceURI) && !"xml".equals(prefix)) {
                    throw new DomDOMException(14, "xml namespace must be http://www.w3.org/XML/1998/namespace", src, 0);
                }
                if (src.nodeType == 2 && "http://www.w3.org/2000/xmlns/".equals(namespaceURI) && !"xmlns".equals(prefix) && !"xmlns".equals(qualifiedName)) {
                    throw new DomDOMException(14, "xmlns namespace must be http://www.w3.org/2000/xmlns/", src, 0);
                }
            }
            src.setNodeName(qualifiedName);
            src.setNamespaceURI(namespaceURI);
            src.notifyUserDataHandlers((short)4, src, src);
            return src;
        }
        throw new DomDOMException(9, null, n, 0);
    }

    public XPathExpression createExpression(String expression, XPathNSResolver resolver) throws XPathException, DOMException {
        return new DomXPathExpression(this, expression, resolver);
    }

    public XPathNSResolver createNSResolver(Node nodeResolver) {
        return new DomXPathNSResolver(nodeResolver);
    }

    public Object evaluate(String expression, Node contextNode, XPathNSResolver resolver, short type, Object result) throws XPathException, DOMException {
        DomXPathExpression xpe = new DomXPathExpression(this, expression, resolver);
        return xpe.evaluate(contextNode, type, result);
    }
}

