/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.util.regex;

import gnu.java.util.regex.CharIndexed;
import gnu.java.util.regex.REMatch;
import gnu.java.util.regex.REToken;

final class RETokenRange
extends REToken {
    private char lo;
    private char hi;
    private boolean insens;

    RETokenRange(int subIndex, char lo, char hi, boolean ins) {
        super(subIndex);
        this.insens = ins;
        this.lo = lo;
        this.hi = hi;
    }

    int getMinimumLength() {
        return 1;
    }

    int getMaximumLength() {
        return 1;
    }

    REMatch matchThis(CharIndexed input, REMatch mymatch) {
        char c = input.charAt(mymatch.index);
        if (this.matchOneChar(c)) {
            ++mymatch.index;
            return mymatch;
        }
        return null;
    }

    boolean matchOneChar(char c) {
        boolean matches;
        if (c == '\uffff') {
            return false;
        }
        boolean bl = matches = c >= this.lo && c <= this.hi;
        if (!matches && this.insens) {
            char c1 = RETokenRange.toLowerCase(c, this.unicodeAware);
            boolean bl2 = matches = c1 >= this.lo && c1 <= this.hi;
            if (!matches) {
                c1 = RETokenRange.toUpperCase(c, this.unicodeAware);
                matches = c1 >= this.lo && c1 <= this.hi;
            }
        }
        return matches;
    }

    boolean returnsFixedLengthMatches() {
        return true;
    }

    int findFixedLengthMatches(CharIndexed input, REMatch mymatch, int max) {
        char ch;
        int numRepeats;
        int index = mymatch.index;
        for (numRepeats = 0; numRepeats < max && this.matchOneChar(ch = input.charAt(index++)); ++numRepeats) {
        }
        return numRepeats;
    }

    void dump(StringBuffer os) {
        os.append(this.lo).append('-').append(this.hi);
    }
}

