/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.util.regex;

import gnu.java.util.regex.BacktrackStack;
import gnu.java.util.regex.CharIndexed;
import gnu.java.util.regex.REMatch;
import gnu.java.util.regex.REToken;
import gnu.java.util.regex.RETokenChar;
import java.util.Stack;
import java.util.Vector;

final class RETokenOneOf
extends REToken {
    private Vector options;
    private boolean negative;
    private boolean matchesOneChar;
    private Vector addition;

    RETokenOneOf(int subIndex, String optionsStr, boolean negative, boolean insens) {
        super(subIndex);
        this.options = new Vector();
        this.negative = negative;
        int i = 0;
        while (i < optionsStr.length()) {
            this.options.addElement(new RETokenChar(subIndex, optionsStr.charAt(i), insens));
            ++i;
        }
        this.matchesOneChar = true;
    }

    RETokenOneOf(int subIndex, Vector options, boolean negative) {
        super(subIndex);
        this.options = options;
        this.negative = negative;
        this.matchesOneChar = negative;
    }

    RETokenOneOf(int subIndex, Vector options, Vector addition, boolean negative) {
        super(subIndex);
        this.options = options;
        this.addition = addition;
        this.negative = negative;
        this.matchesOneChar = negative || addition != null;
    }

    int getMinimumLength() {
        if (this.matchesOneChar) {
            return 1;
        }
        int min = Integer.MAX_VALUE;
        int i = 0;
        while (i < this.options.size()) {
            int x = ((REToken)this.options.elementAt(i)).getMinimumLength();
            if (x < min) {
                min = x;
            }
            ++i;
        }
        return min;
    }

    int getMaximumLength() {
        if (this.matchesOneChar) {
            return 1;
        }
        int max = 0;
        int i = 0;
        while (i < this.options.size()) {
            int x = ((REToken)this.options.elementAt(i)).getMaximumLength();
            if (x > max) {
                max = x;
            }
            ++i;
        }
        return max;
    }

    boolean match(CharIndexed input, REMatch mymatch) {
        this.setHitEnd(input, mymatch);
        if (this.matchesOneChar) {
            return this.matchOneChar(input, mymatch);
        }
        return this.matchOneRE(input, mymatch);
    }

    boolean matchOneChar(CharIndexed input, REMatch mymatch) {
        boolean b;
        boolean tryOnly;
        REMatch tryMatch;
        if (this.addition == null) {
            tryMatch = mymatch;
            tryOnly = false;
        } else {
            tryMatch = (REMatch)mymatch.clone();
            tryOnly = true;
        }
        boolean bl = b = this.negative ? this.matchN(input, tryMatch, tryOnly) : this.matchP(input, tryMatch, tryOnly);
        if (this.addition == null) {
            return b;
        }
        Stack<Boolean> stack = new Stack<Boolean>();
        stack.push(new Boolean(b));
        int i = 0;
        while (i < this.addition.size()) {
            Object obj = this.addition.elementAt(i);
            if (obj instanceof REToken) {
                b = ((REToken)obj).match(input, (REMatch)mymatch.clone());
                stack.push(new Boolean(b));
            } else if (obj instanceof Boolean) {
                stack.push((Boolean)obj);
            } else if (obj.equals("|")) {
                b = (Boolean)stack.pop();
                b = (Boolean)stack.pop() != false || b;
                stack.push(new Boolean(b));
            } else if (obj.equals("&")) {
                b = (Boolean)stack.pop();
                b = (Boolean)stack.pop() != false && b;
                stack.push(new Boolean(b));
            } else {
                throw new RuntimeException("Invalid object found");
            }
            ++i;
        }
        b = (Boolean)stack.pop();
        if (b) {
            ++mymatch.index;
            return this.next(input, mymatch);
        }
        return false;
    }

    private boolean matchN(CharIndexed input, REMatch mymatch, boolean tryOnly) {
        if (input.charAt(mymatch.index) == '\uffff') {
            return false;
        }
        int i = 0;
        while (i < this.options.size()) {
            REMatch tryMatch;
            REToken tk = (REToken)this.options.elementAt(i);
            if (tk.match(input, tryMatch = (REMatch)mymatch.clone())) {
                return false;
            }
            ++i;
        }
        if (tryOnly) {
            return true;
        }
        ++mymatch.index;
        return this.next(input, mymatch);
    }

    private boolean matchP(CharIndexed input, REMatch mymatch, boolean tryOnly) {
        int i = 0;
        while (i < this.options.size()) {
            REMatch tryMatch;
            REToken tk = (REToken)this.options.elementAt(i);
            if (tk.match(input, tryMatch = (REMatch)mymatch.clone())) {
                if (tryOnly) {
                    return true;
                }
                if (this.next(input, tryMatch)) {
                    mymatch.assignFrom(tryMatch);
                    return true;
                }
            }
            ++i;
        }
        return false;
    }

    private boolean matchOneRE(CharIndexed input, REMatch mymatch) {
        REMatch newMatch = this.findMatch(input, mymatch);
        if (newMatch != null) {
            mymatch.assignFrom(newMatch);
            return true;
        }
        return false;
    }

    REMatch findMatch(CharIndexed input, REMatch mymatch) {
        if (this.matchesOneChar) {
            return super.findMatch(input, mymatch);
        }
        return this.findMatch(input, mymatch, 0);
    }

    REMatch backtrack(CharIndexed input, REMatch mymatch, Object param) {
        return this.findMatch(input, mymatch, (Integer)param);
    }

    private REMatch findMatch(CharIndexed input, REMatch mymatch, int optionIndex) {
        int i = optionIndex;
        while (i < this.options.size()) {
            boolean b;
            REToken tk = (REToken)this.options.elementAt(i);
            tk = (REToken)tk.clone();
            tk.chain(this.getNext());
            REMatch tryMatch = (REMatch)mymatch.clone();
            if (tryMatch.backtrackStack == null) {
                tryMatch.backtrackStack = new BacktrackStack();
            }
            boolean stackPushed = false;
            if (i + 1 < this.options.size()) {
                tryMatch.backtrackStack.push(new BacktrackStack.Backtrack(this, input, mymatch, new Integer(i + 1)));
                stackPushed = true;
            }
            if (b = tk.match(input, tryMatch)) {
                return tryMatch;
            }
            if (stackPushed) {
                tryMatch.backtrackStack.pop();
            }
            ++i;
        }
        return null;
    }

    boolean returnsFixedLengthMatches() {
        return this.matchesOneChar;
    }

    int findFixedLengthMatches(CharIndexed input, REMatch mymatch, int max) {
        int numRepeats;
        if (!this.matchesOneChar) {
            return super.findFixedLengthMatches(input, mymatch, max);
        }
        REMatch m = (REMatch)mymatch.clone();
        REToken tk = (REToken)this.clone();
        tk.chain(null);
        for (numRepeats = 0; numRepeats < max && (m = tk.findMatch(input, m)) != null; ++numRepeats) {
        }
        return numRepeats;
    }

    void dump(StringBuffer os) {
        os.append(this.negative ? "[^" : "(?:");
        int i = 0;
        while (i < this.options.size()) {
            if (!this.negative && i > 0) {
                os.append('|');
            }
            ((REToken)this.options.elementAt(i)).dumpAll(os);
            ++i;
        }
        os.append(this.negative ? (char)']' : ')');
    }
}

