/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.security.jce.prng;

import gnu.java.security.prng.LimitReachedException;
import gnu.java.security.prng.MDGenerator;
import java.security.SecureRandomSpi;
import java.util.Collections;

abstract class SecureRandomAdapter
extends SecureRandomSpi {
    private MDGenerator adaptee = new MDGenerator();
    private String mdName;

    protected SecureRandomAdapter(String mdName) {
        this.mdName = mdName;
        this.adaptee.init(Collections.singletonMap("gnu.crypto.prng.md.hash.name", mdName));
    }

    public byte[] engineGenerateSeed(int numBytes) {
        if (numBytes < 1) {
            return new byte[0];
        }
        byte[] result = new byte[numBytes];
        this.engineNextBytes(result);
        return result;
    }

    public void engineNextBytes(byte[] bytes) {
        if (!this.adaptee.isInitialised()) {
            this.engineSetSeed(new byte[0]);
        }
        try {
            this.adaptee.nextBytes(bytes, 0, bytes.length);
        }
        catch (LimitReachedException limitReachedException) {}
    }

    public void engineSetSeed(byte[] seed) {
        this.adaptee.addRandomBytes(seed);
    }
}

