/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.rmi.server;

import gnu.java.rmi.server.CombinedClassLoader;
import java.lang.reflect.Proxy;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.rmi.server.RMIClassLoaderSpi;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Map;
import java.util.StringTokenizer;

public class RMIClassLoaderImpl
extends RMIClassLoaderSpi {
    private static RMIClassLoaderImpl instance = null;
    private static Map cacheLoaders = new Hashtable(89);
    private static Map cacheAnnotations = new Hashtable(89);
    private static MyClassLoader defaultClassLoader;
    private static String defaultAnnotation;
    private static URL defaultCodebase;

    static {
        defaultAnnotation = System.getProperty("java.rmi.server.defaultAnnotation");
        try {
            if (defaultAnnotation != null) {
                defaultCodebase = new URL(defaultAnnotation);
            }
        }
        catch (Exception exception) {
            defaultCodebase = null;
        }
        if (defaultCodebase != null) {
            defaultClassLoader = new MyClassLoader(new URL[]{defaultCodebase}, null, defaultAnnotation);
            cacheLoaders.put(new CacheKey(defaultAnnotation, Thread.currentThread().getContextClassLoader()), defaultClassLoader);
        }
    }

    private RMIClassLoaderImpl() {
    }

    public static RMIClassLoaderSpi getInstance() {
        if (instance == null) {
            instance = new RMIClassLoaderImpl();
        }
        return instance;
    }

    public Class loadClass(String codeBase, String name, ClassLoader defaultLoader) throws MalformedURLException, ClassNotFoundException {
        try {
            if (defaultLoader != null) {
                return Class.forName(name, false, defaultLoader);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {}
        return Class.forName(name, false, this.getClassLoader(codeBase));
    }

    public Class loadProxyClass(String codeBase, String[] interfaces, ClassLoader defaultLoader) throws MalformedURLException, ClassNotFoundException {
        Class[] clss = new Class[interfaces.length];
        int i = 0;
        while (i < interfaces.length) {
            clss[i] = this.loadClass(codeBase, interfaces[i], defaultLoader);
            ++i;
        }
        ArrayList<ClassLoader> loaders = new ArrayList<ClassLoader>(clss.length);
        ClassLoader loader = null;
        int i2 = 0;
        while (i2 < clss.length) {
            loader = clss[i2].getClassLoader();
            if (!loaders.contains(loader)) {
                loaders.add(0, loader);
            }
            ++i2;
        }
        if (loaders.size() > 1) {
            loader = new CombinedClassLoader(loaders);
        }
        try {
            return Proxy.getProxyClass(loader, clss);
        }
        catch (IllegalArgumentException e) {
            throw new ClassNotFoundException(null, e);
        }
    }

    public ClassLoader getClassLoader(String codebase) throws MalformedURLException {
        if (codebase == null || codebase.length() == 0) {
            return Thread.currentThread().getContextClassLoader();
        }
        CacheKey loaderKey = new CacheKey(codebase, Thread.currentThread().getContextClassLoader());
        ClassLoader loader = (ClassLoader)cacheLoaders.get(loaderKey);
        if (loader == null) {
            StringTokenizer tok = new StringTokenizer(codebase, " ");
            ArrayList<URL> urls = new ArrayList<URL>();
            while (tok.hasMoreTokens()) {
                urls.add(new URL(tok.nextToken()));
            }
            loader = new MyClassLoader(urls.toArray(new URL[urls.size()]), Thread.currentThread().getContextClassLoader(), codebase);
            cacheLoaders.put(loaderKey, loader);
        }
        return loader;
    }

    public String getClassAnnotation(Class cl) {
        ClassLoader loader = cl.getClassLoader();
        if (loader == null || loader == ClassLoader.getSystemClassLoader()) {
            return System.getProperty("java.rmi.server.codebase");
        }
        if (loader instanceof MyClassLoader) {
            return ((MyClassLoader)loader).getClassAnnotation();
        }
        String s = (String)cacheAnnotations.get(loader);
        if (s != null) {
            return s;
        }
        if (loader instanceof URLClassLoader) {
            URL[] urls = ((URLClassLoader)loader).getURLs();
            if (urls.length == 0) {
                return null;
            }
            StringBuffer annotation = new StringBuffer(64 * urls.length);
            int i = 0;
            while (i < urls.length) {
                annotation.append(urls[i].toExternalForm());
                annotation.append(' ');
                ++i;
            }
            s = annotation.toString();
            cacheAnnotations.put(loader, s);
            return s;
        }
        return System.getProperty("java.rmi.server.codebase");
    }

    private static class CacheKey {
        private String mCodeBase;
        private ClassLoader mContextClassLoader;

        public CacheKey(String theCodebase, ClassLoader theContextClassLoader) {
            this.mCodeBase = theCodebase;
            this.mContextClassLoader = theContextClassLoader;
        }

        public boolean equals(Object theOther) {
            if (theOther instanceof CacheKey) {
                CacheKey key = (CacheKey)theOther;
                return this.equals(this.mCodeBase, key.mCodeBase) && this.equals(this.mContextClassLoader, key.mContextClassLoader);
            }
            return false;
        }

        private boolean equals(Object theOne, Object theOther) {
            return theOne != null ? theOne.equals(theOther) : theOther == null;
        }

        public int hashCode() {
            return (this.mCodeBase != null ? this.mCodeBase.hashCode() : 0) ^ (this.mContextClassLoader != null ? this.mContextClassLoader.hashCode() : -1);
        }

        public String toString() {
            return "[" + this.mCodeBase + "," + this.mContextClassLoader + "]";
        }
    }

    private static class MyClassLoader
    extends URLClassLoader {
        private final String annotation;

        MyClassLoader(URL[] urls, ClassLoader parent, String annotation) {
            super(urls, parent);
            this.annotation = annotation;
        }

        private MyClassLoader(URL[] urls, ClassLoader parent) {
            super(urls, parent);
            this.annotation = MyClassLoader.urlToAnnotation(urls);
        }

        public static String urlToAnnotation(URL[] urls) {
            if (urls.length == 0) {
                return null;
            }
            StringBuffer annotation = new StringBuffer(64 * urls.length);
            int i = 0;
            while (i < urls.length) {
                annotation.append(urls[i].toExternalForm());
                annotation.append(' ');
                ++i;
            }
            return annotation.toString();
        }

        public final String getClassAnnotation() {
            return this.annotation;
        }
    }
}

