/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.awt.peer.gtk;

import gnu.classpath.Pointer;
import gnu.java.awt.peer.gtk.AsyncImage;
import gnu.java.awt.peer.gtk.CairoGraphics2D;
import gnu.java.awt.peer.gtk.CairoSurface;
import gnu.java.awt.peer.gtk.ComponentGraphicsCopy;
import gnu.java.awt.peer.gtk.GtkComponentPeer;
import gnu.java.awt.peer.gtk.GtkImage;
import gnu.java.awt.peer.gtk.GtkVolatileImage;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Toolkit;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ImageObserver;
import java.awt.image.ImageProducer;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.util.Hashtable;

public class ComponentGraphics
extends CairoGraphics2D {
    private static final boolean hasXRenderExtension = ComponentGraphics.hasXRender();
    private GtkComponentPeer component;
    protected long cairo_t;
    private BufferedImage buffer;
    private BufferedImage componentBuffer;
    private static ThreadLocal<Integer> hasLock = new ThreadLocal();
    private static Integer ONE = 1;

    ComponentGraphics() {
    }

    private ComponentGraphics(GtkComponentPeer component) {
        this.component = component;
        this.cairo_t = this.initState(component);
        this.setup(this.cairo_t);
        Rectangle bounds = component.awtComponent.getBounds();
        this.setClip(new Rectangle(0, 0, bounds.width, bounds.height));
        this.setBackground(component.awtComponent.getBackground());
        this.setColor(component.awtComponent.getForeground());
    }

    private ComponentGraphics(ComponentGraphics cg) {
        this.component = cg.component;
        this.cairo_t = this.initState(this.component);
        this.copy(cg, this.cairo_t);
        Rectangle bounds = this.component.awtComponent.getBounds();
        this.setClip(new Rectangle(0, 0, bounds.width, bounds.height));
        this.setBackground(this.component.awtComponent.getBackground());
        this.setColor(this.component.awtComponent.getForeground());
    }

    private native long initState(GtkComponentPeer var1);

    private void lock() {
        Integer i = hasLock.get();
        if (i == null) {
            this.start_gdk_drawing();
            hasLock.set(ONE);
        } else {
            hasLock.set(i + 1);
        }
    }

    private void unlock() {
        Integer i = hasLock.get();
        if (i == null) {
            throw new IllegalStateException();
        }
        if (i == ONE) {
            hasLock.set(null);
            this.end_gdk_drawing();
        } else if (i == 2) {
            hasLock.set(ONE);
        } else {
            hasLock.set(i - 1);
        }
    }

    protected native long initFromVolatile(long var1, int var3, int var4);

    private native void start_gdk_drawing();

    private native void end_gdk_drawing();

    public static native boolean hasXRender();

    private static native Pointer nativeGrab(GtkComponentPeer var0);

    private native void copyAreaNative(GtkComponentPeer var1, int var2, int var3, int var4, int var5, int var6, int var7);

    private native void drawVolatile(GtkComponentPeer var1, long var2, int var4, int var5, int var6, int var7, int var8, int var9, int var10, int var11);

    public static GtkImage grab(GtkComponentPeer component) {
        return new GtkImage(ComponentGraphics.nativeGrab(component));
    }

    public static Graphics2D getComponentGraphics(GtkComponentPeer component) {
        if (hasXRenderExtension) {
            return new ComponentGraphics(component);
        }
        Rectangle r = component.awtComponent.getBounds();
        return new ComponentGraphicsCopy(r.width, r.height, component);
    }

    public GraphicsConfiguration getDeviceConfiguration() {
        return this.component.getGraphicsConfiguration();
    }

    public Graphics create() {
        return new ComponentGraphics(this);
    }

    protected Rectangle2D getRealBounds() {
        return this.component.awtComponent.getBounds();
    }

    public void copyAreaImpl(int x, int y, int width, int height, int dx, int dy) {
        this.copyAreaNative(this.component, x, y, width, height, dx, dy);
    }

    public void draw(Shape s) {
        if (this.comp == null || this.comp instanceof AlphaComposite) {
            super.draw(s);
        } else {
            this.createBuffer();
            Graphics2D g2d = (Graphics2D)this.buffer.getGraphics();
            g2d.setStroke(this.getStroke());
            g2d.setColor(this.getColor());
            g2d.draw(s);
            this.drawComposite(s.getBounds2D(), null);
        }
    }

    public void fill(Shape s) {
        if (this.comp == null || this.comp instanceof AlphaComposite) {
            super.fill(s);
        } else {
            this.createBuffer();
            Graphics2D g2d = (Graphics2D)this.buffer.getGraphics();
            g2d.setPaint(this.getPaint());
            g2d.setColor(this.getColor());
            g2d.fill(s);
            this.drawComposite(s.getBounds2D(), null);
        }
    }

    public void drawRenderedImage(RenderedImage image, AffineTransform xform) {
        if (this.comp == null || this.comp instanceof AlphaComposite) {
            super.drawRenderedImage(image, xform);
        } else {
            this.createBuffer();
            Graphics2D g2d = (Graphics2D)this.buffer.getGraphics();
            g2d.setRenderingHints(this.getRenderingHints());
            g2d.drawRenderedImage(image, xform);
            this.drawComposite(this.buffer.getRaster().getBounds(), null);
        }
    }

    protected boolean drawImage(Image img, AffineTransform xform, Color bgcolor, ImageObserver obs) {
        boolean rv;
        if (this.comp == null || this.comp instanceof AlphaComposite) {
            rv = super.drawImage(img, xform, bgcolor, obs);
        } else {
            if (!(img instanceof BufferedImage)) {
                ImageProducer source = img.getSource();
                if (source == null) {
                    return false;
                }
                img = Toolkit.getDefaultToolkit().createImage(source);
            }
            BufferedImage bImg = (BufferedImage)img;
            Point2D origin = new Point2D.Double(bImg.getMinX(), bImg.getMinY());
            Point2D pt = new Point2D.Double(bImg.getWidth() + bImg.getMinX(), bImg.getHeight() + bImg.getMinY());
            if (xform != null) {
                origin = xform.transform(origin, origin);
                pt = xform.transform(pt, pt);
            }
            this.createBuffer();
            Graphics2D g2d = (Graphics2D)this.buffer.getGraphics();
            g2d.setRenderingHints(this.getRenderingHints());
            g2d.drawImage(img, xform, obs);
            rv = this.drawComposite(new Rectangle2D.Double(origin.getX(), origin.getY(), pt.getX(), pt.getY()), obs);
        }
        return rv;
    }

    public void drawGlyphVector(GlyphVector gv, float x, float y) {
        if (this.comp == null || this.comp instanceof AlphaComposite) {
            super.drawGlyphVector(gv, x, y);
        } else {
            this.createBuffer();
            Graphics2D g2d = (Graphics2D)this.buffer.getGraphics();
            g2d.setPaint(this.getPaint());
            g2d.setStroke(this.getStroke());
            g2d.drawGlyphVector(gv, x, y);
            Rectangle2D bounds = gv.getLogicalBounds();
            bounds = new Rectangle2D.Double((double)x + bounds.getX(), (double)y + bounds.getY(), bounds.getWidth(), bounds.getHeight());
            this.drawComposite(bounds, null);
        }
    }

    public boolean drawImage(Image img, int x, int y, ImageObserver observer) {
        BufferedImage bimg;
        if (img instanceof GtkVolatileImage) {
            GtkVolatileImage vimg = (GtkVolatileImage)img;
            int type = this.transform.getType();
            if (!(type != 0 && type != 1 || this.clip != null && !(this.clip instanceof Rectangle2D))) {
                Rectangle2D r = (Rectangle2D)this.clip;
                if (r == null) {
                    r = this.getRealBounds();
                }
                x = (int)((double)x + this.transform.getTranslateX());
                y = (int)((double)y + this.transform.getTranslateY());
                this.drawVolatile(this.component, vimg.nativePointer, x, y, vimg.width, vimg.height, (int)(r.getX() + this.transform.getTranslateX()), (int)(r.getY() + this.transform.getTranslateY()), (int)r.getWidth(), (int)r.getHeight());
                return true;
            }
            return super.drawImage((Image)vimg.getSnapshot(), x, y, observer);
        }
        if (img instanceof BufferedImage) {
            bimg = (BufferedImage)img;
        } else {
            ImageProducer source = img.getSource();
            if (source == null) {
                return false;
            }
            bimg = (BufferedImage)Toolkit.getDefaultToolkit().createImage(source);
        }
        return super.drawImage((Image)bimg, x, y, observer);
    }

    public boolean drawImage(Image img, int x, int y, int width, int height, ImageObserver observer) {
        BufferedImage bimg;
        if (img instanceof GtkVolatileImage && (this.clip == null || this.clip instanceof Rectangle2D)) {
            GtkVolatileImage vimg = (GtkVolatileImage)img;
            int type = this.transform.getType();
            if (!(type != 0 && type != 1 || this.clip != null && !(this.clip instanceof Rectangle2D))) {
                Rectangle2D r = (Rectangle2D)this.clip;
                if (r == null) {
                    r = this.getRealBounds();
                }
                x = (int)((double)x + this.transform.getTranslateX());
                y = (int)((double)y + this.transform.getTranslateY());
                this.drawVolatile(this.component, vimg.nativePointer, x, y, width, height, (int)(r.getX() + this.transform.getTranslateX()), (int)(r.getY() + this.transform.getTranslateY()), (int)r.getWidth(), (int)r.getHeight());
                return true;
            }
            return super.drawImage(vimg.getSnapshot(), x, y, width, height, observer);
        }
        if ((img = AsyncImage.realImage(img, observer)) instanceof BufferedImage) {
            bimg = (BufferedImage)img;
        } else {
            ImageProducer source = img.getSource();
            if (source == null) {
                return false;
            }
            bimg = (BufferedImage)Toolkit.getDefaultToolkit().createImage(source);
        }
        return super.drawImage(bimg, x, y, width, height, observer);
    }

    private boolean drawComposite(Rectangle2D bounds, ImageObserver observer) {
        Rectangle clip = this.getClipBounds();
        Rectangle2D.intersect(bounds, clip, bounds);
        clip = new Rectangle(this.buffer.getMinX(), this.buffer.getMinY(), this.buffer.getWidth(), this.buffer.getHeight());
        Rectangle2D.intersect(bounds, clip, bounds);
        BufferedImage buffer2 = this.buffer;
        if (!bounds.equals(buffer2.getRaster().getBounds())) {
            buffer2 = buffer2.getSubimage((int)bounds.getX(), (int)bounds.getY(), (int)bounds.getWidth(), (int)bounds.getHeight());
        }
        double[] points = new double[]{bounds.getX(), bounds.getY(), bounds.getMaxX(), bounds.getMaxY()};
        this.transform.transform(points, 0, points, 0, 2);
        Rectangle2D.Double deviceBounds = new Rectangle2D.Double(points[0], points[1], points[2] - points[0], points[3] - points[1]);
        Rectangle2D.intersect(deviceBounds, this.getClipInDevSpace(), deviceBounds);
        GtkImage img = ComponentGraphics.grab(this.component);
        Graphics2D gr = this.componentBuffer.createGraphics();
        gr.drawImage(img, 0, 0, null);
        gr.dispose();
        BufferedImage cBuffer = this.componentBuffer;
        if (!deviceBounds.equals(cBuffer.getRaster().getBounds())) {
            cBuffer = cBuffer.getSubimage((int)((RectangularShape)deviceBounds).getX(), (int)((RectangularShape)deviceBounds).getY(), (int)((RectangularShape)deviceBounds).getWidth(), (int)((RectangularShape)deviceBounds).getHeight());
        }
        this.compCtx.compose(buffer2.getRaster(), cBuffer.getRaster(), cBuffer.getRaster());
        boolean rv = super.drawImage((Image)cBuffer, AffineTransform.getTranslateInstance(bounds.getX(), bounds.getY()), null, null);
        return rv;
    }

    private void createBuffer() {
        WritableRaster rst;
        if (this.buffer == null) {
            rst = Raster.createWritableRaster(GtkVolatileImage.createGdkSampleModel(this.component.awtComponent.getWidth(), this.component.awtComponent.getHeight()), new Point(0, 0));
            this.buffer = new BufferedImage(GtkVolatileImage.gdkColorModel, rst, GtkVolatileImage.gdkColorModel.isAlphaPremultiplied(), new Hashtable());
        } else {
            Graphics2D g2d = (Graphics2D)this.buffer.getGraphics();
            g2d.setBackground(new Color(0, 0, 0, 0));
            g2d.clearRect(0, 0, this.buffer.getWidth(), this.buffer.getHeight());
        }
        if (this.componentBuffer == null) {
            rst = Raster.createWritableRaster(GtkVolatileImage.createGdkSampleModel(this.component.awtComponent.getWidth(), this.component.awtComponent.getHeight()), new Point(0, 0));
            this.componentBuffer = new BufferedImage(GtkVolatileImage.gdkColorModel, rst, GtkVolatileImage.gdkColorModel.isAlphaPremultiplied(), new Hashtable());
        }
    }

    protected ColorModel getNativeCM() {
        return GtkVolatileImage.gdkColorModel;
    }

    protected long init(long pointer) {
        long ret;
        try {
            this.lock();
            ret = super.init(pointer);
        }
        finally {
            this.unlock();
        }
        return ret;
    }

    protected void drawPixels(long pointer, int[] pixels, int w, int h, int stride, double[] i2u, double alpha, int interpolation) {
        try {
            this.lock();
            super.drawPixels(pointer, pixels, w, h, stride, i2u, alpha, interpolation);
        }
        finally {
            this.unlock();
        }
    }

    protected void setGradient(long pointer, double x1, double y1, double x2, double y2, int r1, int g1, int b1, int a1, int r2, int g2, int b2, int a2, boolean cyclic) {
        try {
            this.lock();
            super.setGradient(pointer, x1, y1, x2, y2, r1, g1, b1, a1, r2, g2, b2, a2, cyclic);
        }
        finally {
            this.unlock();
        }
    }

    protected void setPaintPixels(long pointer, int[] pixels, int w, int h, int stride, boolean repeat, int x, int y) {
        try {
            this.lock();
            super.setPaintPixels(pointer, pixels, w, h, stride, repeat, x, y);
        }
        finally {
            this.unlock();
        }
    }

    protected void cairoSetMatrix(long pointer, double[] m) {
        try {
            this.lock();
            super.cairoSetMatrix(pointer, m);
        }
        finally {
            this.unlock();
        }
    }

    protected void cairoScale(long pointer, double x, double y) {
        try {
            this.lock();
            super.cairoScale(pointer, x, y);
        }
        finally {
            this.unlock();
        }
    }

    protected void cairoSetOperator(long pointer, int cairoOperator) {
        try {
            this.lock();
            super.cairoSetOperator(pointer, cairoOperator);
        }
        finally {
            this.unlock();
        }
    }

    protected void cairoSetRGBAColor(long pointer, double red, double green, double blue, double alpha) {
        try {
            this.lock();
            super.cairoSetRGBAColor(pointer, red, green, blue, alpha);
        }
        finally {
            this.unlock();
        }
    }

    protected void cairoSetFillRule(long pointer, int cairoFillRule) {
        try {
            this.lock();
            super.cairoSetFillRule(pointer, cairoFillRule);
        }
        finally {
            this.unlock();
        }
    }

    protected void cairoSetLine(long pointer, double width, int cap, int join, double miterLimit) {
        try {
            this.lock();
            super.cairoSetLine(pointer, width, cap, join, miterLimit);
        }
        finally {
            this.unlock();
        }
    }

    protected void cairoSetDash(long pointer, double[] dashes, int ndash, double offset) {
        try {
            this.lock();
            super.cairoSetDash(pointer, dashes, ndash, offset);
        }
        finally {
            this.unlock();
        }
    }

    protected void cairoRectangle(long pointer, double x, double y, double width, double height) {
        try {
            this.lock();
            super.cairoRectangle(pointer, x, y, width, height);
        }
        finally {
            this.unlock();
        }
    }

    protected void cairoArc(long pointer, double x, double y, double radius, double angle1, double angle2) {
        try {
            this.lock();
            super.cairoArc(pointer, x, y, radius, angle1, angle2);
        }
        finally {
            this.unlock();
        }
    }

    protected void cairoSave(long pointer) {
        try {
            this.lock();
            super.cairoSave(pointer);
        }
        finally {
            this.unlock();
        }
    }

    protected void cairoRestore(long pointer) {
        try {
            this.lock();
            super.cairoRestore(pointer);
        }
        finally {
            this.unlock();
        }
    }

    protected void cairoNewPath(long pointer) {
        try {
            this.lock();
            super.cairoNewPath(pointer);
        }
        finally {
            this.unlock();
        }
    }

    protected void cairoClosePath(long pointer) {
        try {
            this.lock();
            super.cairoClosePath(pointer);
        }
        finally {
            this.unlock();
        }
    }

    protected void cairoMoveTo(long pointer, double x, double y) {
        try {
            this.lock();
            super.cairoMoveTo(pointer, x, y);
        }
        finally {
            this.unlock();
        }
    }

    protected void cairoLineTo(long pointer, double x, double y) {
        try {
            this.lock();
            super.cairoLineTo(pointer, x, y);
        }
        finally {
            this.unlock();
        }
    }

    protected void cairoCurveTo(long pointer, double x1, double y1, double x2, double y2, double x3, double y3) {
        try {
            this.lock();
            super.cairoCurveTo(pointer, x1, y1, x2, y2, x3, y3);
        }
        finally {
            this.unlock();
        }
    }

    protected void cairoStroke(long pointer) {
        try {
            this.lock();
            super.cairoStroke(pointer);
        }
        finally {
            this.unlock();
        }
    }

    protected void cairoFill(long pointer, double alpha) {
        try {
            this.lock();
            super.cairoFill(pointer, alpha);
        }
        finally {
            this.unlock();
        }
    }

    protected void cairoClip(long pointer) {
        try {
            this.lock();
            super.cairoClip(pointer);
        }
        finally {
            this.unlock();
        }
    }

    protected void cairoResetClip(long pointer) {
        try {
            this.lock();
            super.cairoResetClip(pointer);
        }
        finally {
            this.unlock();
        }
    }

    protected void cairoSetAntialias(long pointer, boolean aa) {
        try {
            this.lock();
            super.cairoSetAntialias(pointer, aa);
        }
        finally {
            this.unlock();
        }
    }

    protected void drawCairoSurface(CairoSurface surface, AffineTransform tx, double alpha, int interpolation) {
        try {
            this.lock();
            super.drawCairoSurface(surface, tx, alpha, interpolation);
        }
        finally {
            this.unlock();
        }
    }
}

