/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.awt.font.opentype.truetype;

import gnu.java.awt.font.opentype.truetype.Fixed;
import gnu.java.awt.font.opentype.truetype.Zone;
import java.awt.FontFormatException;
import java.awt.geom.AffineTransform;
import java.nio.ByteBuffer;
import java.nio.ShortBuffer;

class VirtualMachine {
    private static final boolean PATENTED_HINTING = false;
    private static final boolean TRACE_EXECUTION = false;
    private static final short ONE_214 = 16384;
    private final int[] storage;
    private int[] stack;
    private final int maxStackElements;
    private int sp;
    private ByteBuffer[] fdefBuffer;
    private int[] fdefEntryPoint;
    private ShortBuffer controlValueTable;
    private int[] cvt;
    private int engineCompensation = 0;
    private ByteBuffer fontProgram;
    private ByteBuffer preProgram;
    private int numTwilightPoints;
    private int pointSize;
    private AffineTransform deviceTransform;
    private int scaleX;
    private int scaleY;
    private int shearX;
    private int shearY;
    private boolean antialiased;
    private int cvtCutIn;
    private int deltaBase;
    private int deltaShift;
    private short freeX;
    private short freeY;
    private int loop;
    private int minimumDistance;
    private short projX;
    private short projY;
    private short dualX;
    private short dualY;
    private int rp0;
    private int rp1;
    private int rp2;
    private boolean scanControl;
    private int scanType;
    private int singleWidthValue;
    private Zone zp0;
    private Zone zp1;
    private Zone zp2;
    private Zone twilightZone;
    private Zone glyphZone;
    private boolean executeGlyphInstructions;
    private boolean ignoreCVTProgram;
    private int roundPeriod;
    private int roundPhase;
    private int roundThreshold;
    private int cachedPixelsPerEM;
    private int unitsPerEm;
    private static final String[] INST_NAME = new String[]{"SVTCA[0]", "SVTCA[1]", "SPVTCA[0]", "SPVTCA[1]", "INST_04", "INST_05", "INST_06", "INST_07", "INST_08", "INST_09", "INST_0A", "INST_0B", "GPV", "GFV", "INST_0E", "ISECT", "SRP0", "SRP1", "SRP2", "SZP0", "SZP1", "SZP2", "SZPS", "SLOOP", "RTG", "RTHG", "SMD", "ELSE", "JMPR", "SCVTCI", "INST_1E", "SSW", "DUP", "POP", "CLEAR", "SWAP", "DEPTH", "CINDEX", "MINDEX", "INST_27", "INST_28", "INST_29", "LOOPCALL", "CALL", "FDEF", "ENDF", "MDAP[0]", "MDAP[1]", "IUP[0]", "IUP[1]", "SHP[0]", "SHP[1]", "INST_34", "INST_35", "INST_36", "INST_37", "INST_38", "IP", "INST_3A", "INST_3B", "INST_3C", "RTDG", "MIAP[0]", "MIAP[1]", "NPUSHB", "NPUSHW", "WS", "RS", "WCVTP", "RCVT", "GC[0]", "GC[1]", "INST_48", "INST_49", "INST_4A", "MPPEM", "MPS", "FLIPON", "FLIPOFF", "DEBUG", "LT", "LTEQ", "GT", "GTEQ", "EQ", "NEQ", "INST_56", "INST_57", "IF", "EIF", "AND", "OR", "NOT", "INST_5D", "SDB", "SDS", "ADD", "SUB", "DIV", "MUL", "ABS", "NEG", "FLOOR", "CEILING", "ROUND[0]", "ROUND[1]", "ROUND[2]", "ROUND[3]", "NROUND[0]", "NROUND[1]", "NROUND[2]", "NROUND[3]", "WCVTF", "INST_71", "INST_72", "DELTAC1", "DELTAC2", "DELTAC3", "SROUND", "S45ROUND", "JROT", "JROF", "ROFF", "INST_7B", "RUTG", "RDTG", "SANGW", "AA", "FLIPPT", "FLIPRGON", "FLIPRGOFF", "INST_83", "INST_84", "SCANCTRL", "INST_86", "INST_87", "GETINFO", "INST_89", "ROLL", "MAX", "MIN", "SCANTYPE", "INSTCTRL", "INST_8F", "INST_90", "INST_91", "INST_92", "INST_93", "INST_94", "INST_95", "INST_96", "INST_97", "INST_98", "INST_99", "INST_9A", "INST_9B", "INST_9C", "INST_9D", "INST_9E", "INST_9F", "INST_A0", "INST_A1", "INST_A2", "INST_A3", "INST_A4", "INST_A5", "INST_A6", "INST_A7", "INST_A8", "INST_A9", "INST_AA", "INST_AB", "INST_AC", "INST_AD", "INST_AE", "INST_AF", "PUSHB[0]", "PUSHB[1]", "PUSHB[2]", "PUSHB[3]", "PUSHB[4]", "PUSHB[5]", "PUSHB[6]", "PUSHB[7]", "PUSHW[0]", "PUSHW[1]", "PUSHW[2]", "PUSHW[3]", "PUSHW[4]", "PUSHW[5]", "PUSHW[6]", "PUSHW[7]", "INST_C0", "INST_C1", "INST_C2", "INST_C3", "INST_C4", "INST_C5", "INST_C6", "INST_C7", "INST_C8", "INST_C9", "INST_CA", "INST_CB", "INST_CC", "INST_CD", "INST_CE", "INST_CF", "INST_D0", "INST_D1", "INST_D2", "INST_D3", "INST_D4", "INST_D5", "INST_D6", "INST_D7", "INST_D8", "INST_D9", "INST_DA", "INST_DB", "INST_DC", "INST_DD", "INST_DE", "INST_DF", "MIRP00000", "MIRP00001", "MIRP00010", "MIRP00011", "MIRP00100", "MIRP00101", "MIRP00110", "MIRP00111", "MIRP01000", "MIRP01001", "MIRP01010", "MIRP01011", "MIRP01100", "MIRP01101", "MIRP01110", "MIRP01111", "MIRP10000", "MIRP10001", "MIRP10010", "MIRP10011", "MIRP10100", "MIRP10101", "MIRP10110", "MIRP10111", "MIRP11000", "MIRP11001", "MIRP11010", "MIRP11011", "MIRP11100", "MIRP11101", "MIRP11110", "MIRP11111"};

    VirtualMachine(int unitsPerEm, ByteBuffer maxp, ByteBuffer controlValueTable, ByteBuffer fontProgram, ByteBuffer preProgram) throws FontFormatException {
        if (maxp.getInt(0) != 65536) {
            throw new FontFormatException("unsupported maxp version");
        }
        this.unitsPerEm = unitsPerEm;
        char maxStorage = maxp.getChar(18);
        int numFunctionDefs = maxp.getChar(20);
        if (numFunctionDefs == 0) {
            numFunctionDefs = 64;
        }
        this.fdefBuffer = new ByteBuffer[numFunctionDefs];
        this.fdefEntryPoint = new int[numFunctionDefs];
        if (controlValueTable != null) {
            this.controlValueTable = controlValueTable.asShortBuffer();
        }
        maxp.getChar(22);
        this.maxStackElements = maxp.getChar(24);
        this.storage = new int[maxStorage];
        this.fontProgram = fontProgram;
        this.preProgram = preProgram;
        this.numTwilightPoints = maxp.getChar(16);
    }

    private void resetGraphicsState() {
        this.dualX = (short)16384;
        this.projX = (short)16384;
        this.freeX = (short)16384;
        this.dualX = 0;
        this.projY = 0;
        this.freeY = 0;
        this.cachedPixelsPerEM = 0;
        this.cvtCutIn = 68;
        this.deltaBase = 9;
        this.deltaShift = 3;
        this.loop = 1;
        this.minimumDistance = 64;
        this.singleWidthValue = 0;
        this.rp2 = 0;
        this.rp1 = 0;
        this.rp0 = 0;
        this.scanControl = false;
        this.scanType = 2;
        this.zp1 = this.zp2 = this.getZone(1);
        this.zp0 = this.zp2;
        this.setRoundingMode(64, 72);
    }

    private void reloadControlValueTable() {
        if (this.controlValueTable == null) {
            return;
        }
        if (this.cvt == null) {
            this.cvt = new int[this.controlValueTable.capacity()];
        }
        int i = 0;
        while (i < this.cvt.length) {
            this.cvt[i] = this.funitsToPixels(this.controlValueTable.get(i));
            ++i;
        }
    }

    private int funitsToPixels(int funits) {
        return (int)(((long)funits * (long)this.scaleY + (long)(this.unitsPerEm >> 1)) / (long)this.unitsPerEm);
    }

    public boolean setup(double pointSize, AffineTransform deviceTransform, boolean antialiased) {
        int pointSize_Fixed;
        boolean changeCTM;
        if (this.stack == null) {
            this.stack = new int[this.maxStackElements];
        }
        if (this.twilightZone == null) {
            this.twilightZone = new Zone(this.numTwilightPoints);
        }
        if (this.fontProgram != null) {
            this.resetGraphicsState();
            this.sp = -1;
            this.execute(this.fontProgram, 0);
            this.fontProgram = null;
        }
        boolean bl = changeCTM = (pointSize_Fixed = Fixed.valueOf(pointSize)) != this.pointSize || !deviceTransform.equals(this.deviceTransform) || antialiased != this.antialiased;
        if (changeCTM) {
            this.pointSize = pointSize_Fixed;
            this.deviceTransform = deviceTransform;
            this.antialiased = antialiased;
            this.scaleX = (int)(deviceTransform.getScaleX() * pointSize * 64.0);
            this.scaleY = (int)(deviceTransform.getScaleY() * pointSize * 64.0);
            this.shearX = (int)(deviceTransform.getShearX() * pointSize * 64.0);
            this.shearY = (int)(deviceTransform.getShearY() * pointSize * 64.0);
            this.resetGraphicsState();
            this.reloadControlValueTable();
            this.executeGlyphInstructions = true;
            this.ignoreCVTProgram = false;
            if (this.preProgram != null) {
                this.sp = -1;
                this.execute(this.preProgram, 0);
                if (this.ignoreCVTProgram) {
                    this.reloadControlValueTable();
                }
            }
        }
        return this.executeGlyphInstructions;
    }

    private void execute(ByteBuffer instructions, int pos) {
        instructions.position(pos);
        while (instructions.hasRemaining() && this.executeInstruction(instructions)) {
        }
    }

    private void dumpInstruction(ByteBuffer inst) {
        int count;
        StringBuffer sbuf = new StringBuffer(40);
        int pc = inst.position();
        int bcode = inst.get(pc) & 0xFF;
        int pcPrefix = 99;
        int i = 0;
        while (i < this.fdefBuffer.length) {
            if (this.fdefBuffer[i] == inst) {
                pcPrefix = 102;
                break;
            }
            ++i;
        }
        sbuf.append((char)pcPrefix);
        sbuf.append(VirtualMachine.getHex((short)inst.position()));
        sbuf.append(": ");
        sbuf.append(VirtualMachine.getHex((byte)bcode));
        sbuf.append("  ");
        sbuf.append(INST_NAME[bcode]);
        if (bcode == 64) {
            count = inst.get(pc + 1) & 0xFF;
            sbuf.append(" (");
            sbuf.append(count);
            sbuf.append(") ");
            i = 0;
            while (i < count) {
                if (i > 0) {
                    sbuf.append(" ");
                }
                sbuf.append('$');
                sbuf.append(VirtualMachine.getHex(inst.get(pc + 2 + i)));
                ++i;
            }
        }
        if (bcode == 65) {
            count = inst.get(pc + 1) & 0xFF;
            sbuf.append(" (");
            sbuf.append(count);
            sbuf.append(") ");
            i = 0;
            while (i < count) {
                if (i > 0) {
                    sbuf.append(' ');
                }
                sbuf.append('$');
                sbuf.append(VirtualMachine.getHex(inst.getShort(pc + 2 + 2 * i)));
                ++i;
            }
        } else {
            count = VirtualMachine.getInstructionLength(bcode) - 1;
            i = 0;
            while (i < count) {
                sbuf.append(" $");
                sbuf.append(VirtualMachine.getHex(inst.get(pc + 1 + i)));
                ++i;
            }
        }
        while (sbuf.length() < 30) {
            sbuf.append(' ');
        }
        sbuf.append('|');
        sbuf.append(this.sp + 1);
        sbuf.append("| ");
        i = this.sp;
        while (i >= Math.max(0, this.sp - 5)) {
            if (i < this.sp) {
                sbuf.append(" ");
            }
            if (this.stack[i] >> 16 != 0) {
                sbuf.append(VirtualMachine.getHex((short)(this.stack[i] >> 16)));
            }
            sbuf.append(VirtualMachine.getHex((short)this.stack[i]));
            --i;
        }
        System.out.println(sbuf);
    }

    private static char getNibble(int i, int rightShift) {
        if ((i = i >> rightShift & 0xF) < 10) {
            return (char)(i + 48);
        }
        return (char)(i + 97 - 10);
    }

    private static String getHex(byte b) {
        char[] a = new char[]{VirtualMachine.getNibble(b, 4), VirtualMachine.getNibble(b, 0)};
        return new String(a);
    }

    private static String getHex(short b) {
        char[] a = new char[]{VirtualMachine.getNibble(b, 12), VirtualMachine.getNibble(b, 8), VirtualMachine.getNibble(b, 4), VirtualMachine.getNibble(b, 0)};
        return new String(a);
    }

    private static void skipAfter(ByteBuffer inst, int opcode1, int opcode2, int illegalCode1, int illegalCode2, boolean handleNestedIfClauses) {
        int pos;
        block2: {
            int curOpcode;
            pos = inst.position();
            int nestingLevel = 0;
            do {
                curOpcode = inst.get(pos) & 0xFF;
                int instLen = VirtualMachine.getInstructionLength(curOpcode);
                pos = curOpcode == 64 ? (pos += 1 + (inst.get(pos + 1) & 0xFF)) : (curOpcode == 65 ? (pos += 1 + 2 * (inst.get(pos + 1) & 0xFF)) : (pos += instLen));
                if (nestingLevel == 0 && (curOpcode == opcode1 || curOpcode == opcode2)) break block2;
                if (!handleNestedIfClauses) continue;
                if (curOpcode == 88) {
                    ++nestingLevel;
                    continue;
                }
                if (curOpcode != 89) continue;
                --nestingLevel;
            } while (nestingLevel >= 0 && curOpcode != illegalCode1 && curOpcode != illegalCode2);
            throw new IllegalStateException();
        }
        inst.position(pos);
    }

    private static int getInstructionLength(int opcode) {
        if (opcode == 64 || opcode == 65) {
            return -1;
        }
        if (opcode >= 176 && opcode <= 183) {
            return opcode - 174;
        }
        if (opcode >= 184 && opcode <= 191) {
            return 1 + (opcode - 183 << 1);
        }
        return 1;
    }

    private boolean executeInstruction(ByteBuffer inst) {
        int bcode = inst.get() & 0xFF;
        switch (bcode) {
            case 0: {
                this.setFreedomVector((short)0, (short)16384);
                this.setProjectionVector((short)0, (short)16384);
                break;
            }
            case 1: {
                this.setFreedomVector((short)16384, (short)0);
                this.setProjectionVector((short)16384, (short)0);
                break;
            }
            case 2: {
                this.setProjectionVector((short)0, (short)16384);
                break;
            }
            case 3: {
                this.setProjectionVector((short)16384, (short)0);
                break;
            }
            case 12: {
                this.stack[++this.sp] = this.projX;
                this.stack[++this.sp] = this.projY;
                break;
            }
            case 13: {
                this.stack[++this.sp] = this.freeX;
                this.stack[++this.sp] = this.freeY;
                break;
            }
            case 15: {
                this.sp -= 4;
                this.handleISECT(this.stack[this.sp], this.stack[this.sp + 1], this.stack[this.sp + 2], this.stack[this.sp + 3], this.stack[this.sp + 4]);
                break;
            }
            case 16: {
                this.rp0 = this.stack[this.sp--];
                break;
            }
            case 17: {
                this.rp1 = this.stack[this.sp--];
                break;
            }
            case 18: {
                this.rp2 = this.stack[this.sp--];
                break;
            }
            case 19: {
                this.zp0 = this.getZone(this.stack[this.sp--]);
                break;
            }
            case 20: {
                this.zp1 = this.getZone(this.stack[this.sp--]);
                break;
            }
            case 21: {
                this.zp2 = this.getZone(this.stack[this.sp--]);
                break;
            }
            case 22: {
                this.zp1 = this.zp2 = this.getZone(this.stack[this.sp--]);
                this.zp0 = this.zp2;
                break;
            }
            case 23: {
                this.loop = this.stack[this.sp--];
                break;
            }
            case 24: {
                this.setRoundingMode(64, 72);
                break;
            }
            case 25: {
                this.setRoundingMode(64, 104);
                break;
            }
            case 26: {
                this.minimumDistance = this.stack[this.sp--];
                break;
            }
            case 27: {
                VirtualMachine.skipAfter(inst, 89, -1, -1, -1, true);
                break;
            }
            case 28: {
                inst.position(inst.position() - 1 + this.stack[this.sp--]);
                break;
            }
            case 29: {
                this.cvtCutIn = this.stack[this.sp--];
                break;
            }
            case 31: {
                this.singleWidthValue = this.stack[this.sp--];
                break;
            }
            case 32: {
                int e1 = this.stack[this.sp];
                this.stack[++this.sp] = e1;
                break;
            }
            case 33: {
                --this.sp;
                break;
            }
            case 34: {
                this.sp = -1;
                break;
            }
            case 35: {
                int e1 = this.stack[this.sp--];
                int e2 = this.stack[this.sp];
                this.stack[this.sp] = e1;
                this.stack[++this.sp] = e2;
                break;
            }
            case 36: {
                this.stack[++this.sp] = this.sp + 1;
                break;
            }
            case 37: {
                this.stack[this.sp] = this.stack[this.sp - this.stack[this.sp]];
                break;
            }
            case 38: {
                int i = this.stack[this.sp];
                int e1 = this.stack[this.sp - i];
                System.arraycopy(this.stack, this.sp - i + 1, this.stack, this.sp - i, i - 1);
                --this.sp;
                this.stack[this.sp] = e1;
                break;
            }
            case 42: {
                int i = this.stack[this.sp--];
                int count = this.stack[this.sp--];
                int e1 = inst.position();
                int e2 = this.sp;
                int j = 0;
                while (j < count) {
                    this.execute(this.fdefBuffer[i], this.fdefEntryPoint[i]);
                    ++j;
                }
                inst.position(e1);
                break;
            }
            case 43: {
                int i = this.stack[this.sp--];
                int e1 = inst.position();
                int e2 = this.sp;
                this.execute(this.fdefBuffer[i], this.fdefEntryPoint[i]);
                inst.position(e1);
                break;
            }
            case 44: {
                int i = this.stack[this.sp--];
                this.fdefBuffer[i] = inst;
                this.fdefEntryPoint[i] = inst.position();
                VirtualMachine.skipAfter(inst, 45, -1, 137, 44, false);
                break;
            }
            case 45: {
                return false;
            }
            case 46: {
                this.handleMDAP(this.stack[this.sp--], false);
                break;
            }
            case 47: {
                this.handleMDAP(this.stack[this.sp--], true);
                break;
            }
            case 57: {
                this.handleIP();
                break;
            }
            case 61: {
                this.setRoundingMode(64, 8);
                this.roundThreshold /= 64;
                break;
            }
            case 62: {
                int e1 = this.stack[this.sp--];
                this.handleMIAP(e1, this.stack[this.sp--], false);
                break;
            }
            case 63: {
                int e1 = this.stack[this.sp--];
                this.handleMIAP(e1, this.stack[this.sp--], true);
                break;
            }
            case 64: {
                int count = inst.get() & 0xFF;
                int i = 0;
                while (i < count) {
                    this.stack[++this.sp] = inst.get() & 0xFF;
                    ++i;
                }
                break;
            }
            case 65: {
                int count = inst.get() & 0xFF;
                int i = 0;
                while (i < count) {
                    this.stack[++this.sp] = inst.getShort();
                    ++i;
                }
                break;
            }
            case 66: {
                int e1 = this.stack[this.sp--];
                int i = this.stack[this.sp--];
                this.storage[i] = e1;
                break;
            }
            case 67: {
                this.stack[this.sp] = this.storage[this.stack[this.sp]];
                break;
            }
            case 68: {
                int e1 = this.stack[this.sp--];
                int i = this.stack[this.sp--];
                if (i >= this.cvt.length) break;
                this.cvt[i] = e1;
                break;
            }
            case 69: {
                if (this.stack[this.sp] < this.cvt.length) {
                    this.stack[this.sp] = this.cvt[this.stack[this.sp]];
                    break;
                }
                this.stack[this.sp] = 0;
                break;
            }
            case 70: {
                this.stack[this.sp] = this.getProjection(this.zp2, this.stack[this.sp]);
                break;
            }
            case 71: {
                this.stack[this.sp] = this.getOriginalProjection(this.zp2, this.stack[this.sp]);
                break;
            }
            case 75: {
                this.stack[++this.sp] = this.getPixelsPerEM();
                break;
            }
            case 76: {
                this.stack[++this.sp] = this.pointSize;
                break;
            }
            case 79: {
                --this.sp;
                break;
            }
            case 80: {
                int e1 = this.stack[this.sp--];
                this.stack[this.sp] = this.stack[this.sp] < e1 ? 1 : 0;
                break;
            }
            case 81: {
                int e1 = this.stack[this.sp--];
                this.stack[this.sp] = this.stack[this.sp] <= e1 ? 1 : 0;
                break;
            }
            case 82: {
                int e1 = this.stack[this.sp--];
                this.stack[this.sp] = this.stack[this.sp] > e1 ? 1 : 0;
                break;
            }
            case 83: {
                int e1 = this.stack[this.sp--];
                this.stack[this.sp] = this.stack[this.sp] >= e1 ? 1 : 0;
                break;
            }
            case 84: {
                int e1 = this.stack[this.sp--];
                this.stack[this.sp] = this.stack[this.sp] == e1 ? 1 : 0;
                break;
            }
            case 85: {
                int e1 = this.stack[this.sp--];
                this.stack[this.sp] = this.stack[this.sp] != e1 ? 1 : 0;
                break;
            }
            case 88: {
                if (this.stack[this.sp--] != 0) break;
                VirtualMachine.skipAfter(inst, 27, 89, -1, -1, true);
                break;
            }
            case 89: {
                break;
            }
            case 90: {
                int e1 = this.stack[this.sp--];
                this.stack[this.sp] = e1 != 0 && this.stack[this.sp] != 0 ? 1 : 0;
                break;
            }
            case 91: {
                int e1 = this.stack[this.sp--];
                this.stack[this.sp] = e1 != 0 || this.stack[this.sp] != 0 ? 1 : 0;
                break;
            }
            case 92: {
                this.stack[this.sp] = this.stack[this.sp] != 0 ? 0 : 1;
                break;
            }
            case 94: {
                this.deltaBase = this.stack[this.sp--];
                break;
            }
            case 95: {
                this.deltaShift = this.stack[this.sp--];
                break;
            }
            case 96: {
                int e1 = this.stack[this.sp--];
                int n = this.sp;
                this.stack[n] = this.stack[n] + e1;
                break;
            }
            case 97: {
                int e1 = this.stack[this.sp--];
                int n = this.sp;
                this.stack[n] = this.stack[n] - e1;
                break;
            }
            case 98: {
                int e1 = this.stack[this.sp--];
                this.stack[this.sp] = Fixed.div(e1, this.stack[this.sp]);
                break;
            }
            case 99: {
                int e1 = this.stack[this.sp--];
                this.stack[this.sp] = Fixed.mul(e1, this.stack[this.sp]);
                break;
            }
            case 100: {
                this.stack[this.sp] = Math.abs(this.stack[this.sp]);
                break;
            }
            case 101: {
                this.stack[this.sp] = -this.stack[this.sp];
                break;
            }
            case 102: {
                this.stack[this.sp] = Fixed.floor(this.stack[this.sp]);
                break;
            }
            case 103: {
                this.stack[this.sp] = Fixed.ceil(this.stack[this.sp]);
                break;
            }
            case 104: {
                this.stack[this.sp] = this.round(this.stack[this.sp], 0);
                break;
            }
            case 105: {
                this.stack[this.sp] = this.round(this.stack[this.sp], -this.engineCompensation);
                break;
            }
            case 106: {
                this.stack[this.sp] = this.round(this.stack[this.sp], this.engineCompensation);
                break;
            }
            case 107: {
                this.stack[this.sp] = this.round(this.stack[this.sp], 0);
                break;
            }
            case 108: {
                this.stack[this.sp] = VirtualMachine.nround(this.stack[this.sp], 0);
                break;
            }
            case 109: {
                this.stack[this.sp] = VirtualMachine.nround(this.stack[this.sp], -this.engineCompensation);
                break;
            }
            case 110: {
                this.stack[this.sp] = VirtualMachine.nround(this.stack[this.sp], this.engineCompensation);
                break;
            }
            case 111: {
                this.stack[this.sp] = VirtualMachine.nround(this.stack[this.sp], 0);
                break;
            }
            case 112: {
                int e1 = this.stack[this.sp--];
                this.cvt[this.stack[this.sp--]] = e1 * this.getPixelsPerEM();
                break;
            }
            case 115: {
                int count = this.stack[this.sp--];
                this.sp -= 2 * count;
                this.deltaC(this.stack, this.sp + 1, count, 0);
                break;
            }
            case 116: {
                int count = this.stack[this.sp--];
                this.sp -= 2 * count;
                this.deltaC(this.stack, this.sp + 1, count, 16);
                break;
            }
            case 117: {
                int count = this.stack[this.sp--];
                this.sp -= 2 * count;
                this.deltaC(this.stack, this.sp + 1, count, 32);
                break;
            }
            case 118: {
                this.setRoundingMode(64, this.stack[this.sp--]);
                break;
            }
            case 119: {
                this.setRoundingMode(45, this.stack[this.sp--]);
                break;
            }
            case 120: {
                int e1 = this.stack[this.sp--];
                int i = inst.position() - 1 + this.stack[this.sp--];
                if (e1 == 0) break;
                inst.position(i);
                break;
            }
            case 121: {
                int e1 = this.stack[this.sp--];
                int i = inst.position() - 1 + this.stack[this.sp--];
                if (e1 != 0) break;
                inst.position(i);
                break;
            }
            case 122: {
                this.roundPeriod = 0;
                break;
            }
            case 124: {
                this.setRoundingMode(64, 64);
                break;
            }
            case 125: {
                this.setRoundingMode(64, 64);
                this.roundThreshold = 0;
                break;
            }
            case 126: 
            case 127: {
                --this.sp;
                break;
            }
            case 133: {
                boolean ppemCondition;
                int e1 = this.stack[this.sp--];
                int ppemThreshold = e1 & 0xFF;
                this.scanControl = false;
                boolean bl = ppemCondition = ppemThreshold == 255 || ppemThreshold != 0 && this.getPixelsPerEM() > ppemThreshold;
                if ((e1 & 0x100) != 0 && ppemCondition) {
                    this.scanControl = true;
                }
                if ((e1 & 0x200) != 0 && this.isRotated()) {
                    this.scanControl = true;
                }
                if ((e1 & 0x400) != 0 && this.isStretched()) {
                    this.scanControl = true;
                }
                if ((e1 & 0x800) != 0 && !ppemCondition) {
                    this.scanControl = false;
                }
                if ((e1 & 0x1000) != 0 && !this.isRotated()) {
                    this.scanControl = false;
                }
                if ((e1 & 0x2000) == 0 || this.isStretched()) break;
                this.scanControl = false;
                break;
            }
            case 136: {
                int e1 = 0;
                if ((this.stack[this.sp] & 1) != 0) {
                    e1 |= 0x23;
                }
                if ((this.stack[this.sp] & 2) != 0 && this.isRotated()) {
                    e1 |= 0x100;
                }
                if ((this.stack[this.sp] & 4) != 0 && this.isStretched()) {
                    e1 |= 0x200;
                }
                if ((this.stack[this.sp] & 0x20) != 0 && this.antialiased) {
                    e1 |= 0x1000;
                }
                this.stack[this.sp] = e1;
                break;
            }
            case 138: {
                int e1 = this.stack[this.sp - 2];
                this.stack[this.sp - 2] = this.stack[this.sp - 1];
                this.stack[this.sp - 1] = this.stack[this.sp];
                this.stack[this.sp] = e1;
                break;
            }
            case 139: {
                int e1 = this.stack[this.sp--];
                this.stack[this.sp] = Math.max(e1, this.stack[this.sp]);
                break;
            }
            case 140: {
                int e1 = this.stack[this.sp--];
                this.stack[this.sp] = Math.min(e1, this.stack[this.sp]);
                break;
            }
            case 141: {
                this.scanType = this.stack[this.sp--];
                break;
            }
            case 142: {
                int e1 = this.stack[this.sp--];
                int e2 = this.stack[this.sp--];
                switch (e1) {
                    case 1: {
                        this.executeGlyphInstructions = e2 == 0;
                        break;
                    }
                    case 2: {
                        this.ignoreCVTProgram = e2 != 0;
                    }
                }
                break;
            }
            case 176: 
            case 177: 
            case 178: 
            case 179: 
            case 180: 
            case 181: 
            case 182: 
            case 183: {
                int count = bcode - 176 + 1;
                int i = 0;
                while (i < count) {
                    this.stack[++this.sp] = inst.get() & 0xFF;
                    ++i;
                }
                break;
            }
            case 184: 
            case 185: 
            case 186: 
            case 187: 
            case 188: 
            case 189: 
            case 190: 
            case 191: {
                int count = bcode - 184 + 1;
                int i = 0;
                while (i < count) {
                    this.stack[++this.sp] = inst.getShort();
                    ++i;
                }
                break;
            }
            case 224: 
            case 225: 
            case 226: 
            case 227: 
            case 228: 
            case 229: 
            case 230: 
            case 231: 
            case 232: 
            case 233: 
            case 234: 
            case 235: 
            case 236: 
            case 237: 
            case 238: 
            case 239: 
            case 240: 
            case 241: 
            case 242: 
            case 243: 
            case 244: 
            case 245: 
            case 246: 
            case 247: 
            case 248: 
            case 249: 
            case 250: 
            case 251: 
            case 252: 
            case 253: 
            case 254: 
            case 255: {
                int e1 = this.stack[this.sp--];
                this.handleMIRP(bcode, e1, this.stack[this.sp--]);
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        return true;
    }

    private void setRoundingMode(int period, int mode) {
        switch ((mode & 0xC0) >> 6) {
            case 0: {
                this.roundPeriod = period / 2;
                break;
            }
            case 2: {
                this.roundPeriod = period * 2;
                break;
            }
            default: {
                this.roundPeriod = period;
            }
        }
        switch ((mode & 0x30) >> 4) {
            case 0: {
                this.roundPhase = 0;
                break;
            }
            case 1: {
                this.roundPhase = this.roundPeriod >> 2;
                break;
            }
            case 2: {
                this.roundPhase = this.roundPeriod >> 1;
                break;
            }
            case 3: {
                this.roundPhase = (this.roundPeriod >> 1) + (this.roundPeriod >> 2);
            }
        }
        int threshold = mode & 0xF;
        this.roundThreshold = threshold == 0 ? this.roundPeriod - 64 : (threshold - 4) * this.roundPeriod / 8;
    }

    private void deltaC(int[] pairs, int offset, int numPairs, int base) {
        int ppemTrigger = this.getPixelsPerEM() - (this.deltaBase + base);
        int i = 0;
        while (i < numPairs) {
            int arg = pairs[offset + 2 * i];
            int relativePpem = arg >> 4 & 0xF;
            if (relativePpem == ppemTrigger) {
                int rightShift;
                int delta = (arg & 0xF) - 8;
                if (delta >= 0) {
                    ++delta;
                }
                if ((rightShift = this.deltaShift - 6) > 0) {
                    delta >>= rightShift;
                } else if (rightShift < 0) {
                    delta <<= -rightShift;
                }
                int n = pairs[offset + 2 * i + 1];
                this.cvt[n] = this.cvt[n] + delta;
                break;
            }
            ++i;
        }
    }

    private Zone getZone(int zoneNumber) {
        return zoneNumber == 0 ? this.twilightZone : this.glyphZone;
    }

    private int getProjection(int x, int y) {
        return (int)((long)x * (long)this.projX + (long)y * (long)this.projY >> 14);
    }

    private int getDualProjection(int x, int y) {
        return (int)((long)x * (long)this.dualX + (long)y * (long)this.dualY >> 14);
    }

    private int getProjection(Zone zone, int point) {
        return this.getProjection(zone.getX(point), zone.getY(point));
    }

    private int getOriginalProjection(Zone zone, int point) {
        return this.getDualProjection(zone.getOriginalX(point), zone.getOriginalY(point));
    }

    private void handleISECT(int a0, int a1, int b0, int b1, int p) {
        System.out.println("FIXME: Unimplemented ISECT " + p);
    }

    private static int muldiv(int a, int b, int c) {
        int s = a;
        a = Math.abs(a);
        s ^= b;
        b = Math.abs(b);
        s ^= c;
        c = Math.abs(c);
        a = (int)(((long)a * (long)b + (long)(c >> 1)) / (long)c);
        return s < 0 ? -a : a;
    }

    private int getFreeDotProj() {
        int result = (this.projX * this.freeX << 2) + (this.projY * this.freeY << 2);
        if (Math.abs(result) < 0x4000000) {
            result = 0x40000000;
        }
        return result;
    }

    private void movePoint(Zone zone, int point, int distance) {
        int c;
        int freeDotProj = this.getFreeDotProj();
        if (this.freeX != 0) {
            c = zone.getX(point);
            zone.setX(point, c += VirtualMachine.muldiv(distance, this.freeX << 16, freeDotProj), true);
        }
        if (this.freeY != 0) {
            c = zone.getY(point);
            zone.setY(point, c += VirtualMachine.muldiv(distance, this.freeY << 16, freeDotProj), true);
        }
    }

    private void dumpVectors() {
        System.out.println("  proj=" + Fixed.toString(this.projX >> 8, this.projY >> 8) + ", free=" + Fixed.toString(this.freeX >> 8, this.freeY >> 8));
    }

    private void handleIP() {
        int org_a = this.getOriginalProjection(this.zp0, this.rp1);
        int cur_a = this.getProjection(this.zp0, this.rp1);
        int org_b = this.getOriginalProjection(this.zp1, this.rp2);
        int cur_b = this.getProjection(this.zp1, this.rp2);
        while (--this.loop >= 0) {
            int p = this.stack[this.sp--];
            int org_x = this.getOriginalProjection(this.zp2, p);
            int cur_x = this.getProjection(this.zp2, p);
            int distance = org_a <= org_b && org_x <= org_a || org_a > org_b && org_x >= org_a ? cur_a - org_a + (org_x - cur_x) : (org_a <= org_b && org_x >= org_b || org_a > org_b && org_x < org_b ? cur_b - org_b + (org_x - cur_x) : VirtualMachine.muldiv(cur_b - cur_a, org_x - org_a, org_b - org_a) + (cur_a - cur_x));
            this.movePoint(this.zp2, p, distance);
        }
        this.loop = 1;
    }

    private void handleMDAP(int point, boolean round) {
        System.out.println("FIXME: Unimplemented MDAP: point " + point + "/" + this.zp0);
    }

    private void handleMIAP(int cvtIndex, int point, boolean round) {
        int previousPos = this.getProjection(this.zp0, point);
        int pos = this.cvt[cvtIndex];
        if (round) {
            if (Math.abs(pos - previousPos) > this.cvtCutIn) {
                pos = previousPos;
            }
            pos = this.round(pos, 0);
        }
        this.movePoint(this.zp0, point, pos - previousPos);
        this.rp0 = this.rp1 = point;
    }

    private void handleMIRP(int bcode, int point, int cvtIndex) {
        System.out.println("FIXME: Unimplemented mirp " + point + ", " + cvtIndex);
    }

    private int round(int distance, int compensation) {
        if (this.roundPeriod == 0) {
            return VirtualMachine.nround(distance, compensation);
        }
        if (distance >= 0) {
            int result = distance + compensation - this.roundPhase + this.roundThreshold;
            return Math.max(result &= -this.roundPeriod, 0) + this.roundPhase;
        }
        int result = compensation - this.roundPhase + this.roundThreshold - distance;
        return Math.max(-(result &= -this.roundPeriod), 0) - this.roundPhase;
    }

    private static int nround(int distance, int compensation) {
        if (distance >= 0) {
            return Math.max(distance + compensation, 0);
        }
        return Math.min(distance - compensation, 0);
    }

    private boolean isRotated() {
        return this.shearX != 0 || this.shearY != 0;
    }

    private boolean isStretched() {
        return this.scaleX != this.scaleY;
    }

    private int getPixelsPerEM() {
        if (this.cachedPixelsPerEM == 0) {
            this.cachedPixelsPerEM = Fixed.intValue(Fixed.vectorLength(this.applyCTM_x(this.projX >> 8, this.projY >> 8), this.applyCTM_y(this.projX >> 8, this.projY >> 8)));
        }
        return this.cachedPixelsPerEM;
    }

    private void setProjectionVector(short x, short y) {
    }

    private void setFreedomVector(short x, short y) {
    }

    private void setDualVector(short x, short y) {
    }

    private int applyCTM_x(int x, int y) {
        return (int)((long)this.scaleX * (long)x + (long)this.shearX * (long)y >> 6);
    }

    private int applyCTM_y(int x, int y) {
        return (int)((long)this.shearY * (long)x + (long)this.scaleY * (long)y >> 6);
    }
}

