/*
 * Decompiled with CFR 0.152.
 */
package gnu.CORBA.NamingService;

import gnu.CORBA.NamingService.NameValidator;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.omg.CORBA.IntHolder;
import org.omg.CosNaming.NameComponent;
import org.omg.CosNaming.NamingContextPackage.InvalidName;

public class NameTransformer {
    public static final String ESCAPE = "\\";

    public NameComponent[] toName(String a_name) throws InvalidName {
        ArrayList<NameComponent> components = new ArrayList<NameComponent>();
        StringTokenizer st = new StringTokenizer(a_name, "./\\", true);
        String[] n = new String[st.countTokens() + 1];
        int pp = 0;
        while (st.hasMoreTokens()) {
            n[pp++] = st.nextToken();
        }
        IntHolder p = new IntHolder();
        NameComponent node2 = this.readNode(p, n);
        while (node2 != null) {
            components.add(node2);
            node2 = this.readNode(p, n);
        }
        NameComponent[] name = new NameComponent[components.size()];
        int i = 0;
        while (i < name.length) {
            name[i] = (NameComponent)components.get(i);
            ++i;
        }
        NameValidator.check(name);
        return name;
    }

    public String toString(NameComponent[] a_name) throws InvalidName {
        NameValidator.check(a_name);
        StringBuffer b = new StringBuffer();
        int ni = 0;
        while (ni < a_name.length) {
            NameComponent n = a_name[ni];
            this.appEscaping(b, n.id);
            if (n.kind.length() > 0) {
                b.append('.');
                this.appEscaping(b, n.kind);
            }
            if (ni < a_name.length - 1) {
                b.append('/');
            }
            ++ni;
        }
        return b.toString();
    }

    private void appEscaping(StringBuffer b, String s) {
        int i = 0;
        while (i < s.length()) {
            char c = s.charAt(i);
            switch (c) {
                case '.': 
                case '/': 
                case '\\': {
                    b.append('\\');
                    b.append(c);
                    break;
                }
                default: {
                    b.append(c);
                }
            }
            ++i;
        }
    }

    private void assertEndOfNode(IntHolder p, String[] t) throws InvalidName {
        if (t[p.value] != null && !t[p.value].equals("/")) {
            throw new InvalidName("End of node expected at token " + p.value);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private NameComponent readNode(IntHolder p, String[] t) throws InvalidName {
        if (t[p.value] == null) {
            return null;
        }
        NameComponent n = new NameComponent();
        if (t[p.value].equals(".")) {
            n.id = "";
            ++p.value;
            n.kind = this.readPart(p, t);
            this.assertEndOfNode(p, t);
            if (t[p.value] == null) return n;
            ++p.value;
            return n;
        } else {
            if (t[p.value].equals("/")) {
                throw new InvalidName("Unexpected '/' token " + p.value);
            }
            n.id = this.readPart(p, t);
            if (t[p.value] != null) {
                if (t[p.value].equals(".")) {
                    ++p.value;
                    n.kind = this.readPart(p, t);
                    this.assertEndOfNode(p, t);
                    if (t[p.value] == null) return n;
                    ++p.value;
                    return n;
                } else {
                    if (!t[p.value].equals("/")) throw new InvalidName("Unexpected '" + t[p.value] + "' at token " + p.value);
                    n.kind = "";
                    ++p.value;
                }
                return n;
            } else {
                n.kind = "";
            }
        }
        return n;
    }

    private String readPart(IntHolder p, String[] t) {
        StringBuffer part = new StringBuffer();
        while (t[p.value] != null && !t[p.value].equals(".") && !t[p.value].equals("/")) {
            if (t[p.value].equals(ESCAPE)) {
                ++p.value;
                part.append(t[p.value]);
            } else {
                part.append(t[p.value]);
            }
            ++p.value;
        }
        return part.toString();
    }

    public static void main(String[] args) {
        NameComponent a = new NameComponent("a", "ak");
        NameComponent b = new NameComponent("b/z", "b.k");
        NameComponent c = new NameComponent("c", "");
        NameTransformer sn = new NameTransformer();
        try {
            String s = sn.toString(new NameComponent[]{a, b, c});
            System.out.println(s);
            NameComponent[] k = sn.toName(s);
            System.out.println("ToString");
            int i = 0;
            while (i < k.length) {
                System.out.println(String.valueOf(k[i].id) + ":" + k[i].kind);
                ++i;
            }
        }
        catch (InvalidName ex) {
            ex.printStackTrace();
        }
    }
}

