/*
 * Decompiled with CFR 0.152.
 */
package gnu.CORBA.GIOP;

import gnu.CORBA.CDR.BigEndianInputStream;
import gnu.CORBA.CDR.BigEndianOutputStream;
import gnu.CORBA.CDR.LittleEndianInputStream;
import gnu.CORBA.CDR.LittleEndianOutputStream;
import gnu.CORBA.GIOP.ErrorMessage;
import gnu.CORBA.GIOP.v1_0.CancelHeader;
import gnu.CORBA.GIOP.v1_0.RequestHeader;
import gnu.CORBA.GIOP.v1_2.ReplyHeader;
import gnu.CORBA.Version;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.util.Arrays;
import org.omg.CORBA.MARSHAL;
import org.omg.CORBA.portable.IDLEntity;

public class MessageHeader
implements IDLEntity {
    private static final long serialVersionUID = 1L;
    public static final byte REQUEST = 0;
    public static final byte REPLY = 1;
    public static final byte CANCEL_REQUEST = 2;
    public static final byte LOCATE_REQUEST = 3;
    public static final byte LOCATE_REPLY = 4;
    public static final byte CLOSE_CONNECTION = 5;
    public static final byte MESSAGE_ERROR = 6;
    public static final byte FRAGMENT = 7;
    public static final byte[] MAGIC = new byte[]{71, 73, 79, 80};
    protected static String[] types = new String[]{"Request", "Reply", "Cancel", "Locate request", "Locate reply", "Close connection", "Error", "Fragment"};
    public Version version;
    public byte flags = 0;
    public byte message_type = 0;
    public int message_size = 0;

    public MessageHeader() {
        this.version = new Version(1, 0);
    }

    public MessageHeader(int major, int minor) {
        this.version = new Version(major, minor);
    }

    public boolean isBigEndian() {
        return (this.flags & 1) == 0;
    }

    public boolean moreFragmentsFollow() {
        return (this.flags & 2) != 0;
    }

    public void setBigEndian(boolean use_big_endian) {
        this.flags = use_big_endian ? (byte)(this.flags & 0xFFFFFFFE) : (byte)(this.flags | 1);
    }

    public int getHeaderSize() {
        return 12;
    }

    public String getTypeString(int type) {
        try {
            return types[type];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return "unknown type (" + type + ")";
        }
    }

    public gnu.CORBA.GIOP.ReplyHeader create_reply_header() {
        if (this.version.since_inclusive(1, 2)) {
            return new ReplyHeader();
        }
        return new gnu.CORBA.GIOP.v1_0.ReplyHeader();
    }

    public gnu.CORBA.GIOP.RequestHeader create_request_header() {
        if (this.version.since_inclusive(1, 2)) {
            return new gnu.CORBA.GIOP.v1_2.RequestHeader();
        }
        return new RequestHeader();
    }

    public gnu.CORBA.GIOP.CancelHeader create_cancel_header() {
        return new CancelHeader();
    }

    public ErrorMessage create_error_message() {
        return new ErrorMessage(this.version);
    }

    public void read(InputStream istream) throws MARSHAL, EOFException {
        try {
            byte[] xMagic = new byte[MAGIC.length];
            int r = istream.read(xMagic);
            if (!Arrays.equals(xMagic, MAGIC)) {
                int minor;
                StringBuffer b = new StringBuffer();
                if (r == -1) {
                    b.append("Immediate EOF");
                    minor = 1195573251;
                } else {
                    minor = 1195573249;
                    b.append(String.valueOf(r) + " bytes: ");
                    int i = 0;
                    while (i < xMagic.length) {
                        b.append(Integer.toHexString(xMagic[i] & 0xFF));
                        b.append(' ');
                        ++i;
                    }
                }
                MARSHAL m = new MARSHAL("Not a GIOP message: " + b);
                m.minor = minor;
                throw m;
            }
            this.version = Version.read_version(istream);
            this.flags = (byte)istream.read();
            FilterInputStream din = this.isBigEndian() ? new BigEndianInputStream(istream) : new LittleEndianInputStream(istream);
            this.message_type = (byte)din.read();
            this.message_size = din.readInt();
        }
        catch (IOException ex) {
            MARSHAL t = new MARSHAL();
            t.minor = 1195573250;
            t.initCause(ex);
            throw t;
        }
    }

    public String toString() {
        return "GIOP " + this.version + ", " + (this.isBigEndian() ? "Big" : "Little") + " endian, " + this.getTypeString(this.message_type) + ", " + this.message_size + " bytes. ";
    }

    public void write(OutputStream out) {
        try {
            FilterOutputStream dout = this.isBigEndian() ? new BigEndianOutputStream(out) : new LittleEndianOutputStream(out);
            dout.write(MAGIC);
            this.version.write(dout);
            dout.write(this.flags);
            dout.write(this.message_type);
            dout.writeInt(this.message_size);
        }
        catch (IOException ex) {
            MARSHAL t = new MARSHAL(ex.getMessage());
            t.minor = 1195573250;
            t.initCause(ex);
            throw t;
        }
    }

    public byte[] readMessage(InputStream source, Socket service, int to_read, int to_pause) {
        try {
            byte[] r = new byte[this.message_size];
            int n = 0;
            if (service != null) {
                service.setSoTimeout(to_read);
            }
            while (n < r.length) {
                n += source.read(r, n, r.length - n);
            }
            if (service != null) {
                service.setSoTimeout(to_pause);
            }
            if (this.moreFragmentsFollow()) {
                ByteArrayOutputStream buffer = new ByteArrayOutputStream(2 * r.length);
                buffer.write(r);
                if (r.length < 10) {
                    r = new byte[1024];
                }
                MessageHeader h2 = new MessageHeader();
                do {
                    h2.read(source);
                    n = 0;
                    while (n < h2.message_size) {
                        int dn = source.read(r, 0, h2.message_size - n);
                        if (n == 0 && service != null) {
                            service.setSoTimeout(to_read);
                        }
                        if (n == 0 && this.version.since_inclusive(1, 2)) {
                            buffer.write(r, 4, dn - 4);
                        } else {
                            buffer.write(r, 0, dn);
                        }
                        n = dn;
                    }
                    if (service == null) continue;
                    service.setSoTimeout(to_pause);
                } while (h2.moreFragmentsFollow());
                return buffer.toByteArray();
            }
            return r;
        }
        catch (IOException ioex) {
            MARSHAL m = new MARSHAL("Unable to read the message continuation.");
            m.minor = 1195573250;
            m.initCause(ioex);
            throw m;
        }
    }
}

