/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.ftp;

import ch.cyberduck.core.Path;
import ch.cyberduck.core.date.MDTMSecondsDateFormatter;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.Timestamp;
import ch.cyberduck.core.ftp.FTPClient;
import ch.cyberduck.core.ftp.FTPException;
import ch.cyberduck.core.ftp.FTPExceptionMappingService;
import ch.cyberduck.core.ftp.FTPSession;
import ch.cyberduck.core.shared.DefaultTimestampFeature;
import ch.cyberduck.core.transfer.TransferStatus;
import java.io.IOException;
import java.util.TimeZone;
import org.apache.log4j.Logger;

public class FTPMFMTTimestampFeature
extends DefaultTimestampFeature
implements Timestamp {
    private static final Logger log = Logger.getLogger(FTPMFMTTimestampFeature.class);
    private final FTPSession session;
    private FTPException failure;

    public FTPMFMTTimestampFeature(FTPSession session) {
        this.session = session;
    }

    public void setTimestamp(Path file, TransferStatus status) throws BackgroundException {
        if (this.failure != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Skip setting timestamp for %s due to previous failure %s", file, this.failure.getMessage()));
            }
            throw new FTPExceptionMappingService().map("Cannot change timestamp of {0}", this.failure, file);
        }
        try {
            MDTMSecondsDateFormatter formatter = new MDTMSecondsDateFormatter();
            if (!((FTPClient)((Object)this.session.getClient())).setModificationTime(file.getAbsolute(), formatter.format(status.getTimestamp().longValue(), TimeZone.getTimeZone("UTC")))) {
                this.failure = new FTPException(((FTPClient)((Object)this.session.getClient())).getReplyCode(), ((FTPClient)((Object)this.session.getClient())).getReplyString());
                throw this.failure;
            }
        }
        catch (IOException e) {
            throw new FTPExceptionMappingService().map("Cannot change timestamp of {0}", e, file);
        }
    }
}

