/*
 * Decompiled with CFR 0.152.
 */
package at.favre.lib.crypto;

import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import javax.crypto.Mac;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;

public interface HkdfMacFactory {
    public Mac createInstance(SecretKey var1);

    public int getMacLengthBytes();

    public SecretKey createSecretKey(byte[] var1);

    public static final class Default
    implements HkdfMacFactory {
        private final String macAlgorithmName;
        private final Provider provider;

        public static HkdfMacFactory hmacSha256() {
            return new Default("HmacSHA256", null);
        }

        public static HkdfMacFactory hmacSha512() {
            return new Default("HmacSHA512", null);
        }

        @Deprecated
        public static HkdfMacFactory hmacSha1() {
            return new Default("HmacSHA1", null);
        }

        public Default(String macAlgorithmName) {
            this(macAlgorithmName, null);
        }

        public Default(String macAlgorithmName, Provider provider) {
            this.macAlgorithmName = macAlgorithmName;
            this.provider = provider;
        }

        @Override
        public Mac createInstance(SecretKey key) {
            try {
                Mac mac = this.createMacInstance();
                mac.init(key);
                return mac;
            }
            catch (Exception e) {
                throw new IllegalStateException("could not make hmac hasher in hkdf", e);
            }
        }

        private Mac createMacInstance() {
            try {
                Mac hmacInstance = this.provider == null ? Mac.getInstance(this.macAlgorithmName) : Mac.getInstance(this.macAlgorithmName, this.provider);
                return hmacInstance;
            }
            catch (NoSuchAlgorithmException e) {
                throw new IllegalStateException("defined mac algorithm was not found", e);
            }
            catch (Exception e) {
                throw new IllegalStateException("could not create mac instance in hkdf", e);
            }
        }

        @Override
        public int getMacLengthBytes() {
            return this.createMacInstance().getMacLength();
        }

        @Override
        public SecretKey createSecretKey(byte[] rawKeyMaterial) {
            if (rawKeyMaterial == null || rawKeyMaterial.length <= 0) {
                return null;
            }
            return new SecretKeySpec(rawKeyMaterial, this.macAlgorithmName);
        }
    }
}

