/*
 * Decompiled with CFR 0.152.
 */
package synapticloop.b2.request;

import java.io.IOException;
import org.apache.http.impl.client.CloseableHttpClient;
import synapticloop.b2.exception.B2ApiException;
import synapticloop.b2.request.BaseB2Request;
import synapticloop.b2.response.B2AuthorizeAccountResponse;
import synapticloop.b2.response.B2DownloadFileResponse;
import synapticloop.b2.util.URLEncoder;

public class B2DownloadFileByNameRequest
extends BaseB2Request {
    public B2DownloadFileByNameRequest(CloseableHttpClient client, B2AuthorizeAccountResponse b2AuthorizeAccountResponse, String bucketName, String fileName) {
        this(client, b2AuthorizeAccountResponse, bucketName, fileName, -1L, -1L);
    }

    public B2DownloadFileByNameRequest(CloseableHttpClient client, B2AuthorizeAccountResponse b2AuthorizeAccountResponse, String bucketName, String fileName, long rangeStart, long rangeEnd) {
        super(client, b2AuthorizeAccountResponse, b2AuthorizeAccountResponse.getDownloadUrl() + "/file/" + URLEncoder.encode(bucketName) + "/" + URLEncoder.encode(fileName));
        if (rangeStart > -1L) {
            if (rangeEnd > -1L) {
                this.addHeader("Range", String.format("bytes=%d-%d", rangeStart, rangeEnd));
            } else {
                this.addHeader("Range", String.format("bytes=%d-", rangeStart));
            }
        }
    }

    public B2DownloadFileResponse getResponse() throws B2ApiException, IOException {
        return new B2DownloadFileResponse(this.executeGet());
    }
}

