/*
 * Decompiled with CFR 0.152.
 */
package ch.iterate.openstack.swift.handler;

import ch.iterate.openstack.swift.AuthenticationResponse;
import ch.iterate.openstack.swift.Response;
import ch.iterate.openstack.swift.exception.AuthorizationException;
import ch.iterate.openstack.swift.exception.GenericException;
import ch.iterate.openstack.swift.model.Region;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.HashSet;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.ResponseHandler;
import org.apache.http.entity.ContentType;
import org.apache.http.protocol.HTTP;

public class AuthenticationJson20ResponseHandler
implements ResponseHandler<AuthenticationResponse> {
    public AuthenticationResponse handleResponse(HttpResponse response) throws IOException {
        if (response.getStatusLine().getStatusCode() == 200) {
            Charset charset = HTTP.DEF_CONTENT_CHARSET;
            ContentType contentType = ContentType.get((HttpEntity)response.getEntity());
            if (contentType != null && contentType.getCharset() != null) {
                charset = contentType.getCharset();
            }
            try {
                String publicUrl;
                String regionId;
                JsonObject serviceCatalog;
                JsonParser parser = new JsonParser();
                JsonObject json = parser.parse((Reader)new InputStreamReader(response.getEntity().getContent(), charset)).getAsJsonObject();
                JsonObject auth = json.getAsJsonObject("access");
                JsonObject user = auth.getAsJsonObject("user");
                String defaultRegion = null;
                if (user.get("RAX-AUTH:defaultRegion") != null) {
                    defaultRegion = user.get("RAX-AUTH:defaultRegion").getAsString();
                }
                String token = auth.getAsJsonObject("token").get("id").getAsString();
                JsonArray serviceCatalogs = auth.getAsJsonArray("serviceCatalog");
                HashSet<Region> regions = new HashSet<Region>();
                HashMap<String, String> cdnUrls = new HashMap<String, String>();
                for (JsonElement e : serviceCatalogs) {
                    serviceCatalog = e.getAsJsonObject();
                    if (serviceCatalog.get("type").getAsString().equals("rax:object-cdn")) {
                        for (JsonElement endpoint : serviceCatalog.getAsJsonArray("endpoints")) {
                            regionId = endpoint.getAsJsonObject().get("region").getAsString();
                            publicUrl = endpoint.getAsJsonObject().get("publicURL").getAsString();
                            cdnUrls.put(regionId, publicUrl);
                        }
                    }
                    if (!serviceCatalog.get("type").getAsString().equals("hpext:cdn")) continue;
                    for (JsonElement endpoint : serviceCatalog.getAsJsonArray("endpoints")) {
                        regionId = endpoint.getAsJsonObject().get("region").getAsString();
                        publicUrl = endpoint.getAsJsonObject().get("publicURL").getAsString();
                        cdnUrls.put(regionId, publicUrl);
                    }
                }
                for (JsonElement e : serviceCatalogs) {
                    serviceCatalog = e.getAsJsonObject();
                    if (!serviceCatalog.get("type").getAsString().equals("object-store")) continue;
                    for (JsonElement endpoint : serviceCatalog.getAsJsonArray("endpoints")) {
                        regionId = endpoint.getAsJsonObject().get("region").getAsString();
                        publicUrl = endpoint.getAsJsonObject().get("publicURL").getAsString();
                        String cdnUrl = cdnUrls.containsKey(regionId) ? (String)cdnUrls.get(regionId) : null;
                        regions.add(new Region(regionId, URI.create(publicUrl), cdnUrl == null ? null : URI.create(cdnUrl), regionId.equals(defaultRegion)));
                    }
                }
                return new AuthenticationResponse(response, token, regions);
            }
            catch (JsonParseException e) {
                throw new IOException(e.getMessage(), e);
            }
        }
        if (response.getStatusLine().getStatusCode() == 401 || response.getStatusLine().getStatusCode() == 403) {
            throw new AuthorizationException(new Response(response));
        }
        throw new GenericException(new Response(response));
    }
}

