/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.dav;

import ch.cyberduck.core.PasswordCallback;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.dav.DAVClient;
import ch.cyberduck.core.dav.DAVExceptionMappingService;
import ch.cyberduck.core.dav.DAVPathEncoder;
import ch.cyberduck.core.dav.DAVSession;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.Delete;
import ch.cyberduck.core.features.Lock;
import ch.cyberduck.core.http.HttpExceptionMappingService;
import ch.cyberduck.core.transfer.TransferStatus;
import com.github.sardine.impl.SardineException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;

public class DAVDeleteFeature
implements Delete {
    private final DAVSession session;

    public DAVDeleteFeature(DAVSession session) {
        this.session = session;
    }

    public void delete(Map<Path, TransferStatus> files, PasswordCallback prompt, Delete.Callback callback) throws BackgroundException {
        ArrayList<Path> deleted = new ArrayList<Path>();
        for (Map.Entry<Path, TransferStatus> file : files.entrySet()) {
            boolean skip = false;
            for (Path d : deleted) {
                if (!file.getKey().isChild(d)) continue;
                skip = true;
                break;
            }
            if (skip) continue;
            deleted.add(file.getKey());
            callback.delete(file.getKey());
            try {
                if (this.session.getFeature(Lock.class) != null && file.getValue().getLockId() != null) {
                    ((DAVClient)((Object)this.session.getClient())).delete(new DAVPathEncoder().encode(file.getKey()), Collections.singletonMap("If", String.format("(<%s>)", file.getValue().getLockId())));
                    continue;
                }
                ((DAVClient)((Object)this.session.getClient())).delete(new DAVPathEncoder().encode(file.getKey()));
            }
            catch (SardineException e) {
                throw new DAVExceptionMappingService().map("Cannot delete {0}", e, file.getKey());
            }
            catch (IOException e) {
                throw new HttpExceptionMappingService().map(e, file.getKey());
            }
        }
    }

    public boolean isRecursive() {
        return true;
    }
}

