/*
 * Decompiled with CFR 0.152.
 */
package org.jets3t.servlets.gatekeeper.impl;

import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import org.jets3t.service.S3ServiceException;
import org.jets3t.service.impl.rest.httpclient.RestS3Service;
import org.jets3t.service.model.S3Object;
import org.jets3t.service.security.AWSCredentials;
import org.jets3t.service.security.ProviderCredentials;
import org.jets3t.service.utils.ServiceUtils;
import org.jets3t.service.utils.gatekeeper.GatekeeperMessage;
import org.jets3t.service.utils.gatekeeper.SignatureRequest;
import org.jets3t.servlets.gatekeeper.BucketLister;
import org.jets3t.servlets.gatekeeper.ClientInformation;

public class DefaultBucketLister
extends BucketLister {
    protected ProviderCredentials credentials = null;
    private String s3BucketName = null;

    public DefaultBucketLister(ServletConfig servletConfig) throws ServletException {
        super(servletConfig);
        String awsAccessKey = servletConfig.getInitParameter("AwsAccessKey");
        String awsSecretKey = servletConfig.getInitParameter("AwsSecretKey");
        boolean missingInitParam = false;
        String errorMessage = "Missing required servlet init parameters for UrlSigner: ";
        if (awsAccessKey == null || awsAccessKey.length() == 0) {
            errorMessage = errorMessage + "AwsAccessKey ";
            missingInitParam = true;
        }
        if (awsSecretKey == null || awsSecretKey.length() == 0) {
            errorMessage = errorMessage + "AwsSecretKey ";
            missingInitParam = true;
        }
        if (missingInitParam) {
            throw new ServletException(errorMessage);
        }
        this.credentials = new AWSCredentials(awsAccessKey, awsSecretKey);
        this.s3BucketName = servletConfig.getInitParameter("S3BucketName");
        if (this.s3BucketName == null || this.s3BucketName.length() == 0) {
            throw new ServletException("Missing required servlet init parameters for DefaultBucketLister: S3BucketName");
        }
    }

    @Override
    public void listObjects(GatekeeperMessage gatekeeperMessage, ClientInformation clientInformation) throws S3ServiceException {
        String prefix = null;
        if (gatekeeperMessage.getApplicationProperties().containsKey("Prefix")) {
            prefix = gatekeeperMessage.getApplicationProperties().getProperty("Prefix");
        }
        RestS3Service service = new RestS3Service(this.credentials);
        S3Object[] objects = service.listObjects(this.s3BucketName, prefix, null, 1000L);
        for (int i = 0; i < objects.length; ++i) {
            SignatureRequest sr = new SignatureRequest();
            sr.setObjectMetadata(objects[i].getMetadataMap());
            sr.addObjectMetadata("Last-Modified", ServiceUtils.formatIso8601Date(objects[i].getLastModifiedDate()));
            sr.setObjectKey(objects[i].getKey());
            gatekeeperMessage.addSignatureRequest(sr);
        }
        gatekeeperMessage.addApplicationProperty("AccountDescription", "<html>Bucket: <b>" + this.s3BucketName + "</b></html>");
        gatekeeperMessage.addApplicationProperty("S3BucketName", this.s3BucketName);
        gatekeeperMessage.addApplicationProperty("UserCanUpload", "true");
        gatekeeperMessage.addApplicationProperty("UserCanDownload", "true");
        gatekeeperMessage.addApplicationProperty("UserCanDelete", "true");
        gatekeeperMessage.addApplicationProperty("UserCanACL", "true");
    }
}

