/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.ui.browser;

import ch.cyberduck.core.Filter;
import ch.cyberduck.core.Path;
import java.util.Locale;
import java.util.Objects;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class SearchFilter
implements Filter<Path> {
    private final String input;

    public SearchFilter(String input) {
        this.input = input;
    }

    @Override
    public boolean accept(Path file) {
        if (file.getName().toLowerCase(Locale.ROOT).contains(this.input.toLowerCase(Locale.ROOT))) {
            return true;
        }
        return StringUtils.isNotBlank((CharSequence)file.attributes().getVersionId()) && file.attributes().getVersionId().toLowerCase(Locale.ROOT).contains(this.input.toLowerCase(Locale.ROOT));
    }

    @Override
    public Pattern toPattern() {
        return Pattern.compile(this.input);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("SearchFilter{");
        sb.append("input='").append(this.input).append('\'');
        sb.append('}');
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SearchFilter)) {
            return false;
        }
        SearchFilter that = (SearchFilter)o;
        return Objects.equals(this.input, that.input);
    }

    public int hashCode() {
        return Objects.hash(this.input);
    }
}

