/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.vault.registry;

import ch.cyberduck.core.Local;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.Timestamp;
import ch.cyberduck.core.transfer.TransferStatus;
import ch.cyberduck.core.vault.VaultRegistry;

public class VaultRegistryTimestampFeature
implements Timestamp {
    private final Session<?> session;
    private final Timestamp proxy;
    private final VaultRegistry registry;

    public VaultRegistryTimestampFeature(Session<?> session, Timestamp proxy, VaultRegistry registry) {
        this.registry = registry;
        this.session = session;
        this.proxy = proxy;
    }

    @Override
    public void setTimestamp(Path file, TransferStatus status) throws BackgroundException {
        this.registry.find(this.session, file).getFeature(this.session, Timestamp.class, this.proxy).setTimestamp(file, status);
    }

    @Override
    public Long getDefault(Local file) {
        return this.proxy.getDefault(file);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("VaultRegistryTimestampFeature{");
        sb.append("proxy=").append(this.proxy);
        sb.append('}');
        return sb.toString();
    }
}

