/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.socket;

import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.cyberduck.core.socket.HttpProxyAwareSocket;
import java.io.IOException;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.InterfaceAddress;
import java.net.NetworkInterface;
import java.net.Proxy;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import javax.net.SocketFactory;
import org.apache.commons.net.DefaultSocketFactory;
import org.apache.log4j.Logger;

public class NetworkInterfaceAwareSocketFactory
extends SocketFactory {
    private static final Logger log = Logger.getLogger(NetworkInterfaceAwareSocketFactory.class);
    private final Proxy proxy;
    private final List<String> blacklisted;
    private final SocketFactory delegate;

    public NetworkInterfaceAwareSocketFactory() {
        this((SocketFactory)new DefaultSocketFactory());
    }

    public NetworkInterfaceAwareSocketFactory(SocketFactory delegate) {
        this(delegate, PreferencesFactory.get().getList("network.interface.blacklist"), null);
    }

    public NetworkInterfaceAwareSocketFactory(Proxy proxy) {
        this((SocketFactory)new DefaultSocketFactory(), proxy);
    }

    public NetworkInterfaceAwareSocketFactory(SocketFactory delegate, Proxy proxy) {
        this(delegate, PreferencesFactory.get().getList("network.interface.blacklist"), proxy);
    }

    public NetworkInterfaceAwareSocketFactory(List<String> blacklisted) {
        this((SocketFactory)new DefaultSocketFactory(), blacklisted);
    }

    public NetworkInterfaceAwareSocketFactory(SocketFactory delegate, List<String> blacklisted) {
        this(delegate, blacklisted, null);
    }

    public NetworkInterfaceAwareSocketFactory(SocketFactory delegate, List<String> blacklisted, Proxy proxy) {
        this.delegate = delegate;
        this.blacklisted = blacklisted;
        this.proxy = null == proxy ? Proxy.NO_PROXY : proxy;
    }

    @Override
    public Socket createSocket() {
        return new HttpProxyAwareSocket(this.proxy){

            @Override
            public void connect(SocketAddress endpoint, int timeout) throws IOException {
                NetworkInterface network;
                InetSocketAddress address;
                if (endpoint instanceof InetSocketAddress && (address = (InetSocketAddress)endpoint).getAddress() instanceof Inet6Address && null != (network = NetworkInterfaceAwareSocketFactory.this.findIPv6Interface((Inet6Address)address.getAddress()))) {
                    super.connect(new InetSocketAddress(NetworkInterfaceAwareSocketFactory.this.getByAddressForInterface(network, address.getAddress()), address.getPort()), timeout);
                    return;
                }
                super.connect(endpoint, timeout);
            }
        };
    }

    @Override
    public Socket createSocket(String host, int port, InetAddress localAddr, int localPort) throws IOException {
        return this.createSocket(InetAddress.getByName(host), port, localAddr, localPort);
    }

    @Override
    public Socket createSocket(InetAddress address, int port, InetAddress localAddr, int localPort) throws IOException {
        if (address instanceof Inet6Address) {
            NetworkInterface network = this.findIPv6Interface((Inet6Address)address);
            if (null == network) {
                return this.delegate.createSocket(address, port, localAddr, localPort);
            }
            return this.delegate.createSocket(this.getByAddressForInterface(network, address), port, localAddr, localPort);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Use default network interface to bind %s", address));
        }
        return this.delegate.createSocket(address, port, localAddr, localPort);
    }

    @Override
    public Socket createSocket(String host, int port) throws IOException {
        return this.createSocket(InetAddress.getByName(host), port);
    }

    @Override
    public Socket createSocket(InetAddress address, int port) throws IOException {
        if (address instanceof Inet6Address) {
            NetworkInterface network = this.findIPv6Interface((Inet6Address)address);
            if (null == network) {
                return this.delegate.createSocket(address, port);
            }
            return this.delegate.createSocket(this.getByAddressForInterface(network, address), port);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Use default network interface to bind %s", address));
        }
        return this.delegate.createSocket(address, port);
    }

    private Inet6Address getByAddressForInterface(NetworkInterface network, InetAddress address) throws UnknownHostException {
        return Inet6Address.getByAddress(address.getHostAddress(), address.getAddress(), network);
    }

    private NetworkInterface findIPv6Interface(Inet6Address address) throws IOException {
        if (this.blacklisted.isEmpty()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Ignore IP6 default network interface setup with empty blacklist");
            }
            return null;
        }
        if (address.getScopeId() != 0) {
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Ignore IP6 default network interface setup for address with scope identifier %d", address.getScopeId()));
            }
            return null;
        }
        ArrayList<Integer> indexes = new ArrayList<Integer>();
        Enumeration<NetworkInterface> enumeration = NetworkInterface.getNetworkInterfaces();
        while (enumeration.hasMoreElements()) {
            indexes.add(enumeration.nextElement().getIndex());
        }
        for (Integer index : indexes) {
            NetworkInterface n = NetworkInterface.getByIndex(index);
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Evaluate interface with %s index %d", n, index));
            }
            if (!n.isUp()) {
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)String.format("Ignore interface %s not up", n));
                continue;
            }
            if (this.blacklisted.contains(n.getName())) {
                log.warn((Object)String.format("Ignore network interface %s disabled with blacklist", n));
                continue;
            }
            for (InterfaceAddress i : n.getInterfaceAddresses()) {
                if (!(i.getAddress() instanceof Inet6Address)) continue;
                if (log.isInfoEnabled()) {
                    log.info((Object)String.format("Selected network interface %s", n));
                }
                return n;
            }
            log.warn((Object)String.format("No IPv6 for interface %s", n));
        }
        log.warn((Object)"No network interface found for IPv6");
        return null;
    }
}

