/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core;

import ch.cyberduck.core.LocaleFactory;
import ch.cyberduck.core.exception.ConnectionCanceledException;
import ch.cyberduck.core.exception.ResolveCanceledException;
import ch.cyberduck.core.exception.ResolveFailedException;
import ch.cyberduck.core.threading.CancelCallback;
import ch.cyberduck.core.threading.NamedThreadFactory;
import com.google.common.util.concurrent.Uninterruptibles;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.MessageFormat;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.log4j.Logger;

public final class Resolver {
    private static final Logger log = Logger.getLogger(Resolver.class);
    private final ThreadFactory threadFactory = new NamedThreadFactory("resolver");

    public InetAddress resolve(final String hostname, CancelCallback callback) throws ResolveFailedException, ResolveCanceledException {
        final CountDownLatch signal = new CountDownLatch(1);
        final AtomicReference resolved = new AtomicReference();
        final AtomicReference failure = new AtomicReference();
        Thread resolver = this.threadFactory.newThread(new Runnable(){

            @Override
            public void run() {
                try {
                    InetAddress address = InetAddress.getByName(hostname);
                    resolved.set(address);
                    if (log.isInfoEnabled()) {
                        log.info((Object)String.format("Resolved %s to %s", hostname, address.getHostAddress()));
                    }
                }
                catch (UnknownHostException e) {
                    log.warn((Object)String.format("Failed resolving %s", hostname));
                    failure.set(e);
                }
                finally {
                    signal.countDown();
                }
            }
        });
        resolver.start();
        log.debug((Object)String.format("Waiting for resolving of %s", hostname));
        while (!Uninterruptibles.awaitUninterruptibly((CountDownLatch)signal, (long)500L, (TimeUnit)TimeUnit.MILLISECONDS)) {
            try {
                callback.verify();
            }
            catch (ConnectionCanceledException c) {
                throw new ResolveCanceledException(MessageFormat.format(LocaleFactory.localizedString("DNS lookup for {0} failed", "Error"), hostname), c);
            }
        }
        try {
            callback.verify();
        }
        catch (ConnectionCanceledException c) {
            throw new ResolveCanceledException(MessageFormat.format(LocaleFactory.localizedString("DNS lookup for {0} failed", "Error"), hostname), c);
        }
        if (null == resolved.get()) {
            if (null == failure.get()) {
                log.warn((Object)String.format("Canceled resolving %s", hostname));
                throw new ResolveCanceledException(MessageFormat.format(LocaleFactory.localizedString("DNS lookup for {0} failed", "Error"), hostname));
            }
            throw new ResolveFailedException(MessageFormat.format(LocaleFactory.localizedString("DNS lookup for {0} failed", "Error"), hostname), (Throwable)failure.get());
        }
        return (InetAddress)resolved.get();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Resolver{");
        sb.append('}');
        return sb.toString();
    }
}

