/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.b2;

import ch.cyberduck.core.Local;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.b2.B2AttributesFinderFeature;
import ch.cyberduck.core.b2.B2FileidProvider;
import ch.cyberduck.core.b2.B2Session;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.Headers;
import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.cyberduck.core.transfer.TransferStatus;
import java.util.Map;

public class B2MetadataFeature
implements Headers {
    public static final String X_BZ_INFO_SRC_LAST_MODIFIED_MILLIS = "src_last_modified_millis";
    public static final String X_BZ_INFO_LARGE_FILE_SHA1 = "large_file_sha1";
    private final B2Session session;
    private final B2FileidProvider fileid;

    public B2MetadataFeature(B2Session session, B2FileidProvider fileid) {
        this.session = session;
        this.fileid = fileid;
    }

    public Map<String, String> getDefault(Local file) {
        Map metadata = PreferencesFactory.get().getMap("b2.metadata.default");
        metadata.put(X_BZ_INFO_SRC_LAST_MODIFIED_MILLIS, String.valueOf(file.attributes().getModificationDate()));
        return metadata;
    }

    public Map<String, String> getMetadata(Path file) throws BackgroundException {
        return new B2AttributesFinderFeature(this.session, this.fileid).find(file).getMetadata();
    }

    public void setMetadata(Path file, TransferStatus status) {
    }
}

