/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.b2;

import ch.cyberduck.core.ConnectionCallback;
import ch.cyberduck.core.DefaultIOExceptionMappingService;
import ch.cyberduck.core.DisabledListProgressListener;
import ch.cyberduck.core.ListProgressListener;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathAttributes;
import ch.cyberduck.core.PathContainerService;
import ch.cyberduck.core.b2.B2ExceptionMappingService;
import ch.cyberduck.core.b2.B2FileidProvider;
import ch.cyberduck.core.b2.B2PathContainerService;
import ch.cyberduck.core.b2.B2Session;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.ConnectionCanceledException;
import ch.cyberduck.core.features.Copy;
import ch.cyberduck.core.http.HttpRange;
import ch.cyberduck.core.io.Checksum;
import ch.cyberduck.core.io.StreamCancelation;
import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.cyberduck.core.threading.BackgroundExceptionCallable;
import ch.cyberduck.core.threading.DefaultRetryCallable;
import ch.cyberduck.core.threading.ThreadPool;
import ch.cyberduck.core.threading.ThreadPoolFactory;
import ch.cyberduck.core.transfer.TransferStatus;
import ch.cyberduck.core.worker.DefaultExceptionMappingService;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.apache.log4j.Logger;
import synapticloop.b2.B2ApiClient;
import synapticloop.b2.exception.B2ApiException;
import synapticloop.b2.response.B2StartLargeFileResponse;
import synapticloop.b2.response.B2UploadPartResponse;

public class B2LargeCopyFeature
implements Copy {
    private static final Logger log = Logger.getLogger(B2LargeCopyFeature.class);
    private final PathContainerService containerService = new B2PathContainerService();
    private final B2Session session;
    private final B2FileidProvider fileid;
    private final Long partSize;
    private final Integer concurrency;

    public B2LargeCopyFeature(B2Session session, B2FileidProvider fileid) {
        this(session, fileid, PreferencesFactory.get().getLong("b2.copy.largeobject.size"), PreferencesFactory.get().getInteger("b2.upload.largeobject.concurrency"));
    }

    public B2LargeCopyFeature(B2Session session, B2FileidProvider fileid, Long partSize, Integer concurrency) {
        this.session = session;
        this.fileid = fileid;
        this.partSize = partSize;
        this.concurrency = concurrency;
    }

    public Path copy(Path source, Path target, TransferStatus status, ConnectionCallback callback) throws BackgroundException {
        ThreadPool pool = ThreadPoolFactory.get((String)"largeupload", (int)this.concurrency);
        try {
            Checksum checksum;
            HashMap<String, String> fileinfo = new HashMap<String, String>(status.getMetadata());
            if (null != status.getTimestamp()) {
                fileinfo.put("src_last_modified_millis", String.valueOf(status.getTimestamp()));
            }
            if (Checksum.NONE != (checksum = status.getChecksum())) {
                switch (checksum.algorithm) {
                    case sha1: {
                        fileinfo.put("large_file_sha1", status.getChecksum().hash);
                    }
                }
            }
            B2StartLargeFileResponse response = ((B2ApiClient)this.session.getClient()).startLargeFileUpload(this.fileid.getFileid(this.containerService.getContainer(target), (ListProgressListener)new DisabledListProgressListener()), this.containerService.getKey(target), status.getMime(), fileinfo);
            long size = status.getLength();
            ArrayList<Future<B2UploadPartResponse>> parts = new ArrayList<Future<B2UploadPartResponse>>();
            long remaining = status.getLength();
            long offset = 0L;
            ArrayList<B2UploadPartResponse> completed = new ArrayList<B2UploadPartResponse>();
            int partNumber = 1;
            while (remaining > 0L) {
                Long path = Math.min(Math.max(size / 10000L, this.partSize), remaining);
                parts.add(this.submit(pool, source, response.getFileId(), status, partNumber, offset, path, callback));
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("Part %s submitted with size %d and offset %d", partNumber, path, offset));
                }
                remaining -= path.longValue();
                offset += path.longValue();
                ++partNumber;
            }
            try {
                for (Future future : parts) {
                    completed.add((B2UploadPartResponse)future.get());
                }
            }
            catch (InterruptedException e) {
                log.error((Object)"Part upload failed with interrupt failure");
                status.setCanceled();
                throw new ConnectionCanceledException((Throwable)e);
            }
            catch (ExecutionException e) {
                log.warn((Object)String.format("Part upload failed with execution failure %s", e.getMessage()));
                if (e.getCause() instanceof BackgroundException) {
                    throw (BackgroundException)e.getCause();
                }
                throw new DefaultExceptionMappingService().map(e.getCause());
            }
            completed.sort(new Comparator<B2UploadPartResponse>(){

                @Override
                public int compare(B2UploadPartResponse o1, B2UploadPartResponse o2) {
                    return o1.getPartNumber().compareTo(o2.getPartNumber());
                }
            });
            ArrayList<String> checksums = new ArrayList<String>();
            for (B2UploadPartResponse part : completed) {
                checksums.add(part.getContentSha1());
            }
            ((B2ApiClient)this.session.getClient()).finishLargeFileUpload(response.getFileId(), checksums.toArray(new String[checksums.size()]));
            if (log.isInfoEnabled()) {
                log.info((Object)String.format("Finished large file upload %s with %d parts", target, completed.size()));
            }
            Path path = new Path(target.getParent(), target.getName(), target.getType(), new PathAttributes(source.attributes()).withVersionId(response.getFileId()));
            return path;
        }
        catch (B2ApiException e) {
            throw new B2ExceptionMappingService().map("Cannot copy {0}", e, source);
        }
        catch (IOException e) {
            throw new DefaultIOExceptionMappingService().map(e);
        }
        finally {
            pool.shutdown(false);
        }
    }

    private Future<B2UploadPartResponse> submit(ThreadPool pool, final Path file, final String largeFileId, final TransferStatus overall, final int partNumber, final Long offset, final Long length, ConnectionCallback callback) {
        if (log.isInfoEnabled()) {
            log.info((Object)String.format("Submit part %d of %s to queue with offset %d and length %d", partNumber, file, offset, length));
        }
        return pool.execute((Callable)new DefaultRetryCallable(this.session.getHost(), (BackgroundExceptionCallable)new BackgroundExceptionCallable<B2UploadPartResponse>(){

            public B2UploadPartResponse call() throws BackgroundException {
                overall.validate();
                try {
                    HttpRange range = HttpRange.byLength((long)offset, (long)length);
                    return ((B2ApiClient)B2LargeCopyFeature.this.session.getClient()).copyLargePart(B2LargeCopyFeature.this.fileid.getFileid(file, (ListProgressListener)new DisabledListProgressListener()), largeFileId, partNumber, String.format("bytes=%d-%d", range.getStart(), range.getEnd()));
                }
                catch (B2ApiException e) {
                    throw new B2ExceptionMappingService().map("Cannot copy {0}", e, file);
                }
                catch (IOException e) {
                    throw new DefaultIOExceptionMappingService().map(e);
                }
            }
        }, (StreamCancelation)overall));
    }
}

