/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.sds.io.swagger.client.model;

import ch.cyberduck.core.sds.io.swagger.client.model.ObjectExpiration;
import ch.cyberduck.core.sds.io.swagger.client.model.UserAuthDataUpdateRequest;
import ch.cyberduck.core.sds.io.swagger.client.model.UserAuthMethod;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@Schema(description="Request model for updating user's metadata")
public class UpdateUserRequest {
    @JsonProperty(value="firstName")
    private String firstName = null;
    @JsonProperty(value="lastName")
    private String lastName = null;
    @JsonProperty(value="userName")
    private String userName = null;
    @JsonProperty(value="email")
    private String email = null;
    @JsonProperty(value="isLocked")
    private Boolean isLocked = false;
    @JsonProperty(value="phone")
    private String phone = null;
    @JsonProperty(value="receiverLanguage")
    private String receiverLanguage = null;
    @JsonProperty(value="expiration")
    private ObjectExpiration expiration = null;
    @JsonProperty(value="authData")
    private UserAuthDataUpdateRequest authData = null;
    @JsonProperty(value="title")
    private String title = null;
    @JsonProperty(value="lockStatus")
    private Integer lockStatus = null;
    @JsonProperty(value="gender")
    private String gender = "n";
    @JsonProperty(value="authMethods")
    private List<UserAuthMethod> authMethods = null;

    public UpdateUserRequest firstName(String firstName) {
        this.firstName = firstName;
        return this;
    }

    @Schema(description="User first name")
    public String getFirstName() {
        return this.firstName;
    }

    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    public UpdateUserRequest lastName(String lastName) {
        this.lastName = lastName;
        return this;
    }

    @Schema(description="User last name")
    public String getLastName() {
        return this.lastName;
    }

    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    public UpdateUserRequest userName(String userName) {
        this.userName = userName;
        return this;
    }

    @Schema(description="&#128640; Since v4.13.0  Username")
    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public UpdateUserRequest email(String email) {
        this.email = email;
        return this;
    }

    @Schema(description="Email ")
    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public UpdateUserRequest isLocked(Boolean isLocked) {
        this.isLocked = isLocked;
        return this;
    }

    @Schema(description="User is locked:  * `false` - unlocked  * `true` - locked    User is locked and can not login anymore.")
    public Boolean isIsLocked() {
        return this.isLocked;
    }

    public void setIsLocked(Boolean isLocked) {
        this.isLocked = isLocked;
    }

    public UpdateUserRequest phone(String phone) {
        this.phone = phone;
        return this;
    }

    @Schema(description="Phone number")
    public String getPhone() {
        return this.phone;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }

    public UpdateUserRequest receiverLanguage(String receiverLanguage) {
        this.receiverLanguage = receiverLanguage;
        return this;
    }

    @Schema(description="IETF language tag")
    public String getReceiverLanguage() {
        return this.receiverLanguage;
    }

    public void setReceiverLanguage(String receiverLanguage) {
        this.receiverLanguage = receiverLanguage;
    }

    public UpdateUserRequest expiration(ObjectExpiration expiration) {
        this.expiration = expiration;
        return this;
    }

    @Schema(description="")
    public ObjectExpiration getExpiration() {
        return this.expiration;
    }

    public void setExpiration(ObjectExpiration expiration) {
        this.expiration = expiration;
    }

    public UpdateUserRequest authData(UserAuthDataUpdateRequest authData) {
        this.authData = authData;
        return this;
    }

    @Schema(description="")
    public UserAuthDataUpdateRequest getAuthData() {
        return this.authData;
    }

    public void setAuthData(UserAuthDataUpdateRequest authData) {
        this.authData = authData;
    }

    public UpdateUserRequest title(String title) {
        this.title = title;
        return this;
    }

    @Schema(description="&#128679; Deprecated since v4.18.0  Job title")
    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public UpdateUserRequest lockStatus(Integer lockStatus) {
        this.lockStatus = lockStatus;
        return this;
    }

    @Schema(description="&#128679; Deprecated since v4.7.0  User lock status:  * `0` - locked  * `1` - Web access allowed  * `2` - Web and mobile access allowed    Please use `isLocked` instead.")
    public Integer getLockStatus() {
        return this.lockStatus;
    }

    public void setLockStatus(Integer lockStatus) {
        this.lockStatus = lockStatus;
    }

    public UpdateUserRequest gender(String gender) {
        this.gender = gender;
        return this;
    }

    @Schema(description="&#128679; Deprecated since v4.12.0  Gender  Do NOT use `gender`! It will be ignored.")
    public String getGender() {
        return this.gender;
    }

    public void setGender(String gender) {
        this.gender = gender;
    }

    public UpdateUserRequest authMethods(List<UserAuthMethod> authMethods) {
        this.authMethods = authMethods;
        return this;
    }

    public UpdateUserRequest addAuthMethodsItem(UserAuthMethod authMethodsItem) {
        if (this.authMethods == null) {
            this.authMethods = new ArrayList<UserAuthMethod>();
        }
        this.authMethods.add(authMethodsItem);
        return this;
    }

    @Schema(description="&#128679; Deprecated since v4.13.0  Authentication methods:  * `sql`  * `active_directory`  * `radius`  * `openid`  use `authData` instead")
    public List<UserAuthMethod> getAuthMethods() {
        return this.authMethods;
    }

    public void setAuthMethods(List<UserAuthMethod> authMethods) {
        this.authMethods = authMethods;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UpdateUserRequest updateUserRequest = (UpdateUserRequest)o;
        return Objects.equals(this.firstName, updateUserRequest.firstName) && Objects.equals(this.lastName, updateUserRequest.lastName) && Objects.equals(this.userName, updateUserRequest.userName) && Objects.equals(this.email, updateUserRequest.email) && Objects.equals(this.isLocked, updateUserRequest.isLocked) && Objects.equals(this.phone, updateUserRequest.phone) && Objects.equals(this.receiverLanguage, updateUserRequest.receiverLanguage) && Objects.equals(this.expiration, updateUserRequest.expiration) && Objects.equals(this.authData, updateUserRequest.authData) && Objects.equals(this.title, updateUserRequest.title) && Objects.equals(this.lockStatus, updateUserRequest.lockStatus) && Objects.equals(this.gender, updateUserRequest.gender) && Objects.equals(this.authMethods, updateUserRequest.authMethods);
    }

    public int hashCode() {
        return Objects.hash(this.firstName, this.lastName, this.userName, this.email, this.isLocked, this.phone, this.receiverLanguage, this.expiration, this.authData, this.title, this.lockStatus, this.gender, this.authMethods);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UpdateUserRequest {\n");
        sb.append("    firstName: ").append(this.toIndentedString(this.firstName)).append("\n");
        sb.append("    lastName: ").append(this.toIndentedString(this.lastName)).append("\n");
        sb.append("    userName: ").append(this.toIndentedString(this.userName)).append("\n");
        sb.append("    email: ").append(this.toIndentedString(this.email)).append("\n");
        sb.append("    isLocked: ").append(this.toIndentedString(this.isLocked)).append("\n");
        sb.append("    phone: ").append(this.toIndentedString(this.phone)).append("\n");
        sb.append("    receiverLanguage: ").append(this.toIndentedString(this.receiverLanguage)).append("\n");
        sb.append("    expiration: ").append(this.toIndentedString(this.expiration)).append("\n");
        sb.append("    authData: ").append(this.toIndentedString(this.authData)).append("\n");
        sb.append("    title: ").append(this.toIndentedString(this.title)).append("\n");
        sb.append("    lockStatus: ").append(this.toIndentedString(this.lockStatus)).append("\n");
        sb.append("    gender: ").append(this.toIndentedString(this.gender)).append("\n");
        sb.append("    authMethods: ").append(this.toIndentedString(this.authMethods)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

