/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.sds.io.swagger.client.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@Schema(description="Password character rules")
public class CharacterRules {
    @JsonProperty(value="mustContainCharacters")
    private List<MustContainCharactersEnum> mustContainCharacters = new ArrayList<MustContainCharactersEnum>();
    @JsonProperty(value="numberOfCharacteristicsToEnforce")
    private Integer numberOfCharacteristicsToEnforce = null;

    public CharacterRules mustContainCharacters(List<MustContainCharactersEnum> mustContainCharacters) {
        this.mustContainCharacters = mustContainCharacters;
        return this;
    }

    public CharacterRules addMustContainCharactersItem(MustContainCharactersEnum mustContainCharactersItem) {
        this.mustContainCharacters.add(mustContainCharactersItem);
        return this;
    }

    @Schema(required=true, description="Characters which a password must contain:  * `alpha` - at least one alphabetical character (`uppercase` OR `lowercase`)  * `uppercase` - at least one uppercase character  * `lowercase` - at least one lowercase character  * `numeric` - at least one numeric character  * `special` - at least one special character (letters and digits excluded)  * `all` - combination of `uppercase`, `lowercase`, `numeric` and `special` (available only in request models)  * `none` - none of the above")
    public List<MustContainCharactersEnum> getMustContainCharacters() {
        return this.mustContainCharacters;
    }

    public void setMustContainCharacters(List<MustContainCharactersEnum> mustContainCharacters) {
        this.mustContainCharacters = mustContainCharacters;
    }

    public CharacterRules numberOfCharacteristicsToEnforce(Integer numberOfCharacteristicsToEnforce) {
        this.numberOfCharacteristicsToEnforce = numberOfCharacteristicsToEnforce;
        return this;
    }

    @Schema(required=true, description="Number of characteristics to enforce  e.g. from `[\"uppercase\", \"lowercase\", \"numeric\", \"special\"]`  all 4 character sets can be enforced; but also only 2 of them")
    public Integer getNumberOfCharacteristicsToEnforce() {
        return this.numberOfCharacteristicsToEnforce;
    }

    public void setNumberOfCharacteristicsToEnforce(Integer numberOfCharacteristicsToEnforce) {
        this.numberOfCharacteristicsToEnforce = numberOfCharacteristicsToEnforce;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CharacterRules characterRules = (CharacterRules)o;
        return Objects.equals(this.mustContainCharacters, characterRules.mustContainCharacters) && Objects.equals(this.numberOfCharacteristicsToEnforce, characterRules.numberOfCharacteristicsToEnforce);
    }

    public int hashCode() {
        return Objects.hash(this.mustContainCharacters, this.numberOfCharacteristicsToEnforce);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CharacterRules {\n");
        sb.append("    mustContainCharacters: ").append(this.toIndentedString(this.mustContainCharacters)).append("\n");
        sb.append("    numberOfCharacteristicsToEnforce: ").append(this.toIndentedString(this.numberOfCharacteristicsToEnforce)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum MustContainCharactersEnum {
        ALPHA("alpha"),
        UPPERCASE("uppercase"),
        LOWERCASE("lowercase"),
        NUMERIC("numeric"),
        SPECIAL("special"),
        ALL("all"),
        NONE("none");

        private String value;

        private MustContainCharactersEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static MustContainCharactersEnum fromValue(String text) {
            for (MustContainCharactersEnum b : MustContainCharactersEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }
    }
}

