/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.auth;

import com.dropbox.core.stone.UnionSerializer;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;

public enum PaperAccessError {
    PAPER_DISABLED,
    NOT_PAPER_USER,
    OTHER;


    public static class Serializer
    extends UnionSerializer<PaperAccessError> {
        public static final Serializer INSTANCE = new Serializer();

        @Override
        public void serialize(PaperAccessError value, JsonGenerator g) throws IOException, JsonGenerationException {
            switch (value) {
                case PAPER_DISABLED: {
                    g.writeString("paper_disabled");
                    break;
                }
                case NOT_PAPER_USER: {
                    g.writeString("not_paper_user");
                    break;
                }
                default: {
                    g.writeString("other");
                }
            }
        }

        @Override
        public PaperAccessError deserialize(JsonParser p) throws IOException, JsonParseException {
            String tag;
            boolean collapsed;
            if (p.getCurrentToken() == JsonToken.VALUE_STRING) {
                collapsed = true;
                tag = Serializer.getStringValue(p);
                p.nextToken();
            } else {
                collapsed = false;
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
            }
            if (tag == null) {
                throw new JsonParseException(p, "Required field missing: .tag");
            }
            PaperAccessError value = "paper_disabled".equals(tag) ? PAPER_DISABLED : ("not_paper_user".equals(tag) ? NOT_PAPER_USER : OTHER);
            if (!collapsed) {
                Serializer.skipFields(p);
                Serializer.expectEndObject(p);
            }
            return value;
        }
    }
}

