/*
 * Decompiled with CFR 0.152.
 */
package org.irods.jargon.core.transfer;

import org.irods.jargon.core.exception.JargonException;
import org.irods.jargon.core.packinstr.TransferOptions;
import org.irods.jargon.core.transfer.TransferControlBlock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultTransferControlBlock
implements TransferControlBlock {
    private static final Logger log = LoggerFactory.getLogger(DefaultTransferControlBlock.class);
    private String restartAbsolutePath = "";
    private boolean cancelled = false;
    private boolean restartHit = false;
    private boolean paused = false;
    private int maximumErrorsBeforeCanceling = 5;
    private int errorCount = 0;
    private int totalFilesSkippedSoFar = 0;
    private int totalFilesToTransfer = 0;
    private int totalFilesTransferredSoFar = 0;
    private TransferOptions transferOptions = null;
    private long totalBytesTransferredSoFar = 0L;
    private long totalBytesToTransfer = 0L;

    @Override
    public synchronized void resetTransferData() {
        this.restartHit = false;
        this.restartAbsolutePath = "";
        this.errorCount = 0;
        this.totalFilesToTransfer = 0;
        this.totalFilesTransferredSoFar = 0;
        this.totalBytesTransferredSoFar = 0L;
        this.totalBytesToTransfer = 0L;
    }

    public static final TransferControlBlock instance(String restartAbsolutePath, int maxErrorsBeforeCancelling) throws JargonException {
        return new DefaultTransferControlBlock(restartAbsolutePath, maxErrorsBeforeCancelling);
    }

    public static final TransferControlBlock instance(String restartAbsolutePath) throws JargonException {
        return new DefaultTransferControlBlock(restartAbsolutePath, 5);
    }

    public static final TransferControlBlock instance() throws JargonException {
        return new DefaultTransferControlBlock(null, 5);
    }

    private DefaultTransferControlBlock(String restartAbsolutePath, int maximumErrorsBeforeCancelling) throws JargonException {
        if (maximumErrorsBeforeCancelling < -1) {
            throw new JargonException("maximumErrorsBeforeCancelling must be >= -1");
        }
        this.maximumErrorsBeforeCanceling = maximumErrorsBeforeCancelling;
        this.restartAbsolutePath = restartAbsolutePath;
    }

    @Override
    public synchronized boolean filter(String absolutePath) throws JargonException {
        log.info("filtering: {}", (Object)absolutePath);
        if (this.restartAbsolutePath == null || this.restartAbsolutePath.isEmpty()) {
            log.info("no filter");
            return true;
        }
        if (this.restartHit) {
            log.info("filter passes");
            return true;
        }
        if (absolutePath.equals(this.restartAbsolutePath)) {
            log.info("hit the restart path");
            this.restartHit = true;
            return false;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isCancelled() {
        DefaultTransferControlBlock defaultTransferControlBlock = this;
        synchronized (defaultTransferControlBlock) {
            return this.cancelled;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setCancelled(boolean cancelled) {
        DefaultTransferControlBlock defaultTransferControlBlock = this;
        synchronized (defaultTransferControlBlock) {
            this.cancelled = cancelled;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isPaused() {
        DefaultTransferControlBlock defaultTransferControlBlock = this;
        synchronized (defaultTransferControlBlock) {
            return this.paused;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setPaused(boolean paused) {
        DefaultTransferControlBlock defaultTransferControlBlock = this;
        synchronized (defaultTransferControlBlock) {
            this.paused = paused;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getMaximumErrorsBeforeCanceling() {
        DefaultTransferControlBlock defaultTransferControlBlock = this;
        synchronized (defaultTransferControlBlock) {
            return this.maximumErrorsBeforeCanceling;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setMaximumErrorsBeforeCanceling(int maximumErrorsBeforeCanceling) throws JargonException {
        if (maximumErrorsBeforeCanceling < -1) {
            throw new JargonException("maximumErrorsBeforeCancelling must be >= -1");
        }
        DefaultTransferControlBlock defaultTransferControlBlock = this;
        synchronized (defaultTransferControlBlock) {
            this.maximumErrorsBeforeCanceling = maximumErrorsBeforeCanceling;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getErrorCount() {
        DefaultTransferControlBlock defaultTransferControlBlock = this;
        synchronized (defaultTransferControlBlock) {
            return this.errorCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reportErrorInTransfer() {
        DefaultTransferControlBlock defaultTransferControlBlock = this;
        synchronized (defaultTransferControlBlock) {
            ++this.errorCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean shouldTransferBeAbandonedDueToNumberOfErrors() {
        boolean cancelForErrors = false;
        DefaultTransferControlBlock defaultTransferControlBlock = this;
        synchronized (defaultTransferControlBlock) {
            if (this.maximumErrorsBeforeCanceling > 0) {
                cancelForErrors = this.errorCount >= this.maximumErrorsBeforeCanceling;
            }
        }
        return cancelForErrors;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getTotalFilesToTransfer() {
        DefaultTransferControlBlock defaultTransferControlBlock = this;
        synchronized (defaultTransferControlBlock) {
            if (this.shouldTransferBeAbandonedDueToNumberOfErrors()) {
                log.warn("cancelling transfer due to error threshold");
                this.setCancelled(true);
            }
            return this.totalFilesToTransfer;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setTotalFilesToTransfer(int totalFilesToTransfer) {
        DefaultTransferControlBlock defaultTransferControlBlock = this;
        synchronized (defaultTransferControlBlock) {
            this.totalFilesToTransfer = totalFilesToTransfer;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getTotalFilesTransferredSoFar() {
        DefaultTransferControlBlock defaultTransferControlBlock = this;
        synchronized (defaultTransferControlBlock) {
            return this.totalFilesTransferredSoFar;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int incrementFilesTransferredSoFar() {
        DefaultTransferControlBlock defaultTransferControlBlock = this;
        synchronized (defaultTransferControlBlock) {
            return ++this.totalFilesTransferredSoFar;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int incrementFilesSkippedSoFar() {
        DefaultTransferControlBlock defaultTransferControlBlock = this;
        synchronized (defaultTransferControlBlock) {
            ++this.totalFilesTransferredSoFar;
            return ++this.totalFilesSkippedSoFar;
        }
    }

    @Override
    public synchronized TransferOptions getTransferOptions() {
        return this.transferOptions;
    }

    @Override
    public synchronized void setTransferOptions(TransferOptions transferOptions) {
        this.transferOptions = transferOptions;
    }

    @Override
    public synchronized long getTotalBytesTransferredSoFar() {
        return this.totalBytesTransferredSoFar;
    }

    @Override
    public synchronized void incrementTotalBytesTransferredSoFar(long totalBytesTransferredSoFar) {
        this.totalBytesTransferredSoFar += totalBytesTransferredSoFar;
    }

    @Override
    public synchronized long getTotalBytesToTransfer() {
        return this.totalBytesToTransfer;
    }

    @Override
    public synchronized void setTotalBytesToTransfer(long totalBytesToTransfer) {
        this.totalBytesToTransfer = totalBytesToTransfer;
    }

    @Override
    public synchronized String getRestartAbsolutePath() {
        return this.restartAbsolutePath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setRestartAbsolutePath(String restartAbsolutePath) {
        if (restartAbsolutePath == null) {
            throw new IllegalArgumentException("null restartAbsolutePath, set to blank if not required");
        }
        DefaultTransferControlBlock defaultTransferControlBlock = this;
        synchronized (defaultTransferControlBlock) {
            this.restartAbsolutePath = restartAbsolutePath;
        }
    }

    @Override
    public synchronized int getTotalFilesSkippedSoFar() {
        return this.totalFilesSkippedSoFar;
    }

    @Override
    public synchronized void setTotalFilesSkippedSoFar(int totalFilesSkippedSoFar) {
        this.totalFilesSkippedSoFar = totalFilesSkippedSoFar;
    }

    @Override
    public int getActualFilesTransferredWithoutSkippedSoFar() {
        return this.totalFilesTransferredSoFar - this.totalFilesSkippedSoFar;
    }
}

