/*
 * Decompiled with CFR 0.152.
 */
package org.irods.jargon.core.connection;

import org.irods.jargon.core.connection.ClientServerNegotiationPolicy;
import org.irods.jargon.core.connection.DefaultPropertiesJargonConfig;
import org.irods.jargon.core.connection.JargonProperties;
import org.irods.jargon.core.exception.JargonException;
import org.irods.jargon.core.protovalues.ChecksumEncodingEnum;
import org.irods.jargon.core.protovalues.EncryptionAlgorithmEnum;

public class SettableJargonProperties
implements JargonProperties {
    private boolean useParallelTransfer = true;
    private final boolean useNIOForParallelTransfers = false;
    private int maxParallelThreads = 4;
    private int maxFilesAndDirsQueryMax = 5000;
    private boolean useTransferThreadsPool = false;
    private int transferThreadPoolMaxSimultaneousTransfers = 4;
    private int transferThreadPoolTimeoutMillis = 60000;
    private boolean allowPutGetResourceRedirects = false;
    private boolean computeChecksumAfterTransfer = false;
    private boolean computeAndVerifyChecksumAfterTransfer = false;
    private boolean intraFileStatusCallbacks = false;
    private int irodsSocketTimeout = 0;
    private int irodsParallelSocketTimeout = 0;
    private int internalInputStreamBufferSize = 0;
    private int internalOutputStreamBufferSize = -1;
    private int internalCacheBufferSize = 65535;
    private int sendInputStreamBufferSize = 0;
    private int localFileOutputStreamBufferSize = 0;
    private int localFileInputStreamBufferSize = 0;
    private int putBufferSize = 0x400000;
    private int getBufferSize = 0x400000;
    private int inputToOutputCopyBufferByteSize = 65536;
    private String encoding = "UTF-8";
    private boolean instrument = false;
    private boolean reconnect = false;
    private boolean defaultToPublicIfNothingUnderRootWhenListing = true;
    private long reconnectTimeInMillis = 600000L;
    private boolean usingDiscoveredServerPropertiesCache = true;
    private boolean usingSpecificQueryForCollectionListingsWithPermissions = true;
    private boolean usingSpecQueryForDataObjPermissionsForUserInGroup = false;
    private int pamTimeToLive = 0;
    private boolean forcePamFlush = false;
    private String connectionFactory = "tcp";
    private ChecksumEncodingEnum checksumEncoding = ChecksumEncodingEnum.DEFAULT;
    private boolean parallelTcpKeepAlive;
    private int parallelTcpSendWindowSize;
    private int parallelTcpReceiveWindowSize;
    private int parallelTcpPerformancePrefsConnectionTime;
    private int parallelTcpPerformancePrefsLatency;
    private int parallelTcpPerformancePrefsBandwidth;
    private boolean primaryTcpKeepAlive;
    private int primaryTcpSendWindowSize;
    private int primaryTcpReceiveWindowSize;
    private int primaryTcpPerformancePrefsConnectionTime;
    private int primaryTcpPerformancePrefsLatency;
    private int primaryTcpPerformancePrefsBandwidth;
    private int socketRenewalIntervalInSeconds;
    private boolean longTransferRestart = true;
    private int parallelCopyBufferSize;
    private int intraFileStatusCallbacksNumberCallsInterval = 5;
    private long intraFileStatusCallbacksTotalBytesInterval = 0x400000L;
    private ClientServerNegotiationPolicy.SslNegotiationPolicy negotiationPolicy = ClientServerNegotiationPolicy.SslNegotiationPolicy.NO_NEGOTIATION;
    private EncryptionAlgorithmEnum encryptionAlgorithmEnum = EncryptionAlgorithmEnum.AES_256_CBC;
    private int encryptionKeySize = 32;
    private int encryptionSaltSize = 8;
    private int encryptionNumberHashRounds = 16;
    private boolean bypassSslCertChecks;

    public SettableJargonProperties(JargonProperties jargonProperties) {
        this.initialize(jargonProperties);
    }

    public SettableJargonProperties() throws JargonException {
        DefaultPropertiesJargonConfig jargonProperties = new DefaultPropertiesJargonConfig();
        this.initialize(jargonProperties);
    }

    private void initialize(JargonProperties jargonProperties) {
        if (jargonProperties == null) {
            throw new IllegalArgumentException("null jargonProperties");
        }
        this.useParallelTransfer = jargonProperties.isUseParallelTransfer();
        this.maxFilesAndDirsQueryMax = jargonProperties.getMaxFilesAndDirsQueryMax();
        this.allowPutGetResourceRedirects = jargonProperties.isAllowPutGetResourceRedirects();
        this.computeAndVerifyChecksumAfterTransfer = jargonProperties.isComputeAndVerifyChecksumAfterTransfer();
        this.computeChecksumAfterTransfer = jargonProperties.isComputeChecksumAfterTransfer();
        this.intraFileStatusCallbacks = jargonProperties.isIntraFileStatusCallbacks();
        this.irodsParallelSocketTimeout = jargonProperties.getIRODSParallelTransferSocketTimeout();
        this.irodsSocketTimeout = jargonProperties.getIRODSSocketTimeout();
        this.maxParallelThreads = jargonProperties.getMaxParallelThreads();
        this.transferThreadPoolTimeoutMillis = jargonProperties.getTransferThreadPoolTimeoutMillis();
        this.transferThreadPoolMaxSimultaneousTransfers = jargonProperties.getTransferThreadPoolMaxSimultaneousTransfers();
        this.internalInputStreamBufferSize = jargonProperties.getInternalInputStreamBufferSize();
        this.internalOutputStreamBufferSize = jargonProperties.getInternalOutputStreamBufferSize();
        this.internalCacheBufferSize = jargonProperties.getInternalCacheBufferSize();
        this.sendInputStreamBufferSize = jargonProperties.getSendInputStreamBufferSize();
        this.localFileOutputStreamBufferSize = jargonProperties.getLocalFileOutputStreamBufferSize();
        this.localFileInputStreamBufferSize = jargonProperties.getLocalFileInputStreamBufferSize();
        this.putBufferSize = jargonProperties.getPutBufferSize();
        this.getBufferSize = jargonProperties.getGetBufferSize();
        this.encoding = jargonProperties.getEncoding();
        this.inputToOutputCopyBufferByteSize = jargonProperties.getInputToOutputCopyBufferByteSize();
        this.setInstrument(jargonProperties.isInstrument());
        this.setReconnect(jargonProperties.isReconnect());
        this.setDefaultToPublicIfNothingUnderRootWhenListing(jargonProperties.isDefaultToPublicIfNothingUnderRootWhenListing());
        this.setUsingSpecQueryForDataObjPermissionsForUserInGroup(jargonProperties.isUsingSpecQueryForDataObjPermissionsForUserInGroup());
        this.setForcePamFlush(jargonProperties.isForcePamFlush());
        this.connectionFactory = jargonProperties.getConnectionFactory();
        this.checksumEncoding = jargonProperties.getChecksumEncoding();
        this.parallelTcpKeepAlive = jargonProperties.isParallelTcpKeepAlive();
        this.parallelTcpPerformancePrefsBandwidth = jargonProperties.getParallelTcpPerformancePrefsBandwidth();
        this.parallelTcpPerformancePrefsConnectionTime = jargonProperties.getParallelTcpPerformancePrefsConnectionTime();
        this.parallelTcpPerformancePrefsLatency = jargonProperties.getParallelTcpPerformancePrefsLatency();
        this.parallelTcpReceiveWindowSize = jargonProperties.getParallelTcpReceiveWindowSize();
        this.parallelTcpSendWindowSize = jargonProperties.getParallelTcpSendWindowSize();
        this.primaryTcpKeepAlive = jargonProperties.isPrimaryTcpKeepAlive();
        this.primaryTcpPerformancePrefsBandwidth = jargonProperties.getPrimaryTcpPerformancePrefsBandwidth();
        this.primaryTcpPerformancePrefsConnectionTime = jargonProperties.getPrimaryTcpPerformancePrefsConnectionTime();
        this.primaryTcpPerformancePrefsLatency = jargonProperties.getPrimaryTcpPerformancePrefsLatency();
        this.primaryTcpReceiveWindowSize = jargonProperties.getPrimaryTcpReceiveWindowSize();
        this.primaryTcpSendWindowSize = jargonProperties.getPrimaryTcpSendWindowSize();
        this.socketRenewalIntervalInSeconds = jargonProperties.getSocketRenewalIntervalInSeconds();
        this.longTransferRestart = jargonProperties.isLongTransferRestart();
        this.parallelCopyBufferSize = jargonProperties.getParallelCopyBufferSize();
        this.intraFileStatusCallbacksNumberCallsInterval = jargonProperties.getIntraFileStatusCallbacksNumberCallsInterval();
        this.intraFileStatusCallbacksTotalBytesInterval = jargonProperties.getIntraFileStatusCallbacksTotalBytesInterval();
        this.negotiationPolicy = jargonProperties.getNegotiationPolicy();
        this.encryptionAlgorithmEnum = jargonProperties.getEncryptionAlgorithmEnum();
        this.encryptionKeySize = jargonProperties.getEncryptionKeySize();
        this.encryptionNumberHashRounds = jargonProperties.getEncryptionNumberHashRounds();
        this.encryptionSaltSize = jargonProperties.getEncryptionSaltSize();
        this.bypassSslCertChecks = jargonProperties.isBypassSslCertChecks();
    }

    @Override
    public synchronized boolean isUseParallelTransfer() {
        return this.useParallelTransfer;
    }

    public synchronized void setUseParallelTransfer(boolean useParallelTransfer) {
        this.useParallelTransfer = useParallelTransfer;
    }

    public synchronized void setMaxParallelThreads(int maxParallelThreads) {
        this.maxParallelThreads = maxParallelThreads;
    }

    @Override
    public synchronized int getMaxParallelThreads() {
        return this.maxParallelThreads;
    }

    @Override
    public synchronized int getMaxFilesAndDirsQueryMax() {
        return this.maxFilesAndDirsQueryMax;
    }

    @Override
    public synchronized boolean isUseTransferThreadsPool() {
        return this.useTransferThreadsPool;
    }

    @Override
    public synchronized int getTransferThreadPoolTimeoutMillis() {
        return this.transferThreadPoolTimeoutMillis;
    }

    public synchronized void setMaxFilesAndDirsQueryMax(int maxFilesAndDirsQueryMax) {
        this.maxFilesAndDirsQueryMax = maxFilesAndDirsQueryMax;
    }

    public synchronized void setUseTransferThreadsPool(boolean useTransferThreadsPool) {
        this.useTransferThreadsPool = useTransferThreadsPool;
    }

    public synchronized void setTransferThreadPoolTimeoutMillis(int transferThreadPoolTimeoutMillis) {
        this.transferThreadPoolTimeoutMillis = transferThreadPoolTimeoutMillis;
    }

    @Override
    public synchronized boolean isAllowPutGetResourceRedirects() {
        return this.allowPutGetResourceRedirects;
    }

    public synchronized void setAllowPutGetResourceRedirects(boolean allowPutGetResourceRedirects) {
        this.allowPutGetResourceRedirects = allowPutGetResourceRedirects;
    }

    @Override
    public synchronized boolean isComputeChecksumAfterTransfer() {
        return this.computeChecksumAfterTransfer;
    }

    public synchronized void setComputeChecksumAfterTransfer(boolean computeChecksumAfterTransfer) {
        this.computeChecksumAfterTransfer = computeChecksumAfterTransfer;
    }

    @Override
    public synchronized boolean isComputeAndVerifyChecksumAfterTransfer() {
        return this.computeAndVerifyChecksumAfterTransfer;
    }

    public synchronized void setComputeAndVerifyChecksumAfterTransfer(boolean computeAndVerifyChecksumAfterTransfer) {
        this.computeAndVerifyChecksumAfterTransfer = computeAndVerifyChecksumAfterTransfer;
    }

    public synchronized void setIntraFileStatusCallbacks(boolean intraFileStatusCallbacks) {
        this.intraFileStatusCallbacks = intraFileStatusCallbacks;
    }

    @Override
    public synchronized boolean isIntraFileStatusCallbacks() {
        return this.intraFileStatusCallbacks;
    }

    @Override
    public synchronized int getIRODSSocketTimeout() {
        return this.irodsSocketTimeout;
    }

    public synchronized void setIRODSSocketTimeout(int irodsSocketTimeout) {
        this.irodsSocketTimeout = irodsSocketTimeout;
    }

    @Override
    public synchronized int getIRODSParallelTransferSocketTimeout() {
        return this.irodsParallelSocketTimeout;
    }

    public synchronized void setIRODSParallelTransferSocketTimeout(int irodsParallelSocketTimeout) {
        this.irodsParallelSocketTimeout = irodsParallelSocketTimeout;
    }

    @Override
    public synchronized int getTransferThreadPoolMaxSimultaneousTransfers() {
        return this.transferThreadPoolMaxSimultaneousTransfers;
    }

    @Override
    public synchronized int getInternalInputStreamBufferSize() {
        return this.internalInputStreamBufferSize;
    }

    @Override
    public synchronized int getInternalOutputStreamBufferSize() {
        return this.internalOutputStreamBufferSize;
    }

    @Override
    public synchronized int getInternalCacheBufferSize() {
        return this.internalCacheBufferSize;
    }

    @Override
    public synchronized int getSendInputStreamBufferSize() {
        return this.sendInputStreamBufferSize;
    }

    @Override
    public synchronized int getInputToOutputCopyBufferByteSize() {
        return this.inputToOutputCopyBufferByteSize;
    }

    @Override
    public synchronized int getLocalFileOutputStreamBufferSize() {
        return this.localFileOutputStreamBufferSize;
    }

    @Override
    public synchronized int getLocalFileInputStreamBufferSize() {
        return this.localFileInputStreamBufferSize;
    }

    public synchronized void setTransferThreadPoolMaxSimultaneousTransfers(int transferThreadPoolMaxSimultaneousTransfers) {
        this.transferThreadPoolMaxSimultaneousTransfers = transferThreadPoolMaxSimultaneousTransfers;
    }

    public synchronized void setInternalInputStreamBufferSize(int internalInputStreamBufferSize) {
        this.internalInputStreamBufferSize = internalInputStreamBufferSize;
    }

    public synchronized void setInternalOutputStreamBufferSize(int internalOutputStreamBufferSize) {
        this.internalOutputStreamBufferSize = internalOutputStreamBufferSize;
    }

    public synchronized void setInternalCacheBufferSize(int internalCacheBufferSize) {
        this.internalCacheBufferSize = internalCacheBufferSize;
    }

    public synchronized void setSendInputStreamBufferSize(int sendInputStreamBufferSize) {
        this.sendInputStreamBufferSize = sendInputStreamBufferSize;
    }

    public synchronized void setLocalFileOutputStreamBufferSize(int localFileOutputStreamBufferSize) {
        this.localFileOutputStreamBufferSize = localFileOutputStreamBufferSize;
    }

    public synchronized void setLocalFileInputStreamBufferSize(int localFileInputStreamBufferSize) {
        this.localFileInputStreamBufferSize = localFileInputStreamBufferSize;
    }

    public synchronized void setIrodsSocketTimeout(int irodsSocketTimeout) {
        this.irodsSocketTimeout = irodsSocketTimeout;
    }

    public synchronized void setIrodsParallelSocketTimeout(int irodsParallelSocketTimeout) {
        this.irodsParallelSocketTimeout = irodsParallelSocketTimeout;
    }

    @Override
    public synchronized int getPutBufferSize() {
        return this.putBufferSize;
    }

    @Override
    public synchronized int getGetBufferSize() {
        return this.getBufferSize;
    }

    public synchronized void setPutBufferSize(int putBufferSize) {
        this.putBufferSize = putBufferSize;
    }

    public synchronized void setGetBufferSize(int getBufferSize) {
        this.getBufferSize = getBufferSize;
    }

    public synchronized void setInputToOutputCopyBufferByteSize(int inputToOutputCopyBufferByteSize) {
        this.inputToOutputCopyBufferByteSize = inputToOutputCopyBufferByteSize;
    }

    @Override
    public synchronized String getEncoding() {
        return this.encoding;
    }

    public synchronized void setEncoding(String encoding) {
        if (encoding == null || encoding.isEmpty()) {
            throw new IllegalArgumentException("encoding is null or empty");
        }
        this.encoding = encoding;
    }

    @Override
    public synchronized boolean isReconnect() {
        return this.reconnect;
    }

    @Override
    public synchronized boolean isInstrument() {
        return this.instrument;
    }

    public synchronized int getIrodsSocketTimeout() {
        return this.irodsSocketTimeout;
    }

    public synchronized int getIrodsParallelSocketTimeout() {
        return this.irodsParallelSocketTimeout;
    }

    public synchronized void setInstrument(boolean instrument) {
        this.instrument = instrument;
    }

    public synchronized void setReconnect(boolean reconnect) {
        this.reconnect = reconnect;
    }

    @Override
    public synchronized boolean isDefaultToPublicIfNothingUnderRootWhenListing() {
        return this.defaultToPublicIfNothingUnderRootWhenListing;
    }

    public synchronized void setDefaultToPublicIfNothingUnderRootWhenListing(boolean defaultToPublicIfNothingUnderRootWhenListing) {
        this.defaultToPublicIfNothingUnderRootWhenListing = defaultToPublicIfNothingUnderRootWhenListing;
    }

    @Override
    public synchronized long getReconnectTimeInMillis() {
        return this.reconnectTimeInMillis;
    }

    public synchronized void setReconnectTimeInMillis(long reconnectTimeInMillis) {
        this.reconnectTimeInMillis = reconnectTimeInMillis;
    }

    @Override
    public synchronized boolean isUsingDiscoveredServerPropertiesCache() {
        return this.usingDiscoveredServerPropertiesCache;
    }

    @Override
    public synchronized boolean isUsingSpecificQueryForCollectionListingsWithPermissions() {
        return this.usingSpecificQueryForCollectionListingsWithPermissions;
    }

    public synchronized void setUsingSpecificQueryForCollectionListingWithPermissions(boolean useSpecificQuery) {
        this.usingSpecificQueryForCollectionListingsWithPermissions = useSpecificQuery;
    }

    @Override
    public synchronized boolean isUsingSpecQueryForDataObjPermissionsForUserInGroup() {
        return this.usingSpecQueryForDataObjPermissionsForUserInGroup;
    }

    public synchronized void setUsingSpecQueryForDataObjPermissionsForUserInGroup(boolean usingSpecQueryForDataObjPermissionsForUserInGroup) {
        this.usingSpecQueryForDataObjPermissionsForUserInGroup = usingSpecQueryForDataObjPermissionsForUserInGroup;
    }

    @Override
    public synchronized int getPAMTimeToLive() {
        return this.pamTimeToLive;
    }

    public synchronized void setPAMTimeToLive(int pamTimeToLive) {
        this.pamTimeToLive = pamTimeToLive;
    }

    @Override
    public synchronized boolean isForcePamFlush() {
        return this.forcePamFlush;
    }

    public synchronized void setForcePamFlush(boolean forcePamFlush) {
        this.forcePamFlush = forcePamFlush;
    }

    @Override
    public synchronized String getConnectionFactory() {
        return this.connectionFactory;
    }

    public synchronized int getPamTimeToLive() {
        return this.pamTimeToLive;
    }

    public synchronized void setPamTimeToLive(int pamTimeToLive) {
        this.pamTimeToLive = pamTimeToLive;
    }

    public synchronized void setUsingDiscoveredServerPropertiesCache(boolean usingDiscoveredServerPropertiesCache) {
        this.usingDiscoveredServerPropertiesCache = usingDiscoveredServerPropertiesCache;
    }

    public synchronized void setUsingSpecificQueryForCollectionListingsWithPermissions(boolean usingSpecificQueryForCollectionListingsWithPermissions) {
        this.usingSpecificQueryForCollectionListingsWithPermissions = usingSpecificQueryForCollectionListingsWithPermissions;
    }

    public synchronized void setConnectionFactory(String connectionFactory) {
        this.connectionFactory = connectionFactory;
    }

    @Override
    public synchronized ChecksumEncodingEnum getChecksumEncoding() {
        return this.checksumEncoding;
    }

    public synchronized void setChecksumEncoding(ChecksumEncodingEnum checksumEncoding) {
        if (checksumEncoding == null) {
            throw new IllegalArgumentException("null checksumEncoding");
        }
        this.checksumEncoding = checksumEncoding;
    }

    @Override
    public synchronized boolean isParallelTcpKeepAlive() {
        return this.parallelTcpKeepAlive;
    }

    public synchronized void setParallelTcpKeepAlive(boolean parallelTcpKeepAlive) {
        this.parallelTcpKeepAlive = parallelTcpKeepAlive;
    }

    @Override
    public synchronized int getParallelTcpSendWindowSize() {
        return this.parallelTcpSendWindowSize;
    }

    public synchronized void setParallelTcpSendWindowSize(int parallelTcpSendWindowSize) {
        this.parallelTcpSendWindowSize = parallelTcpSendWindowSize;
    }

    @Override
    public synchronized int getParallelTcpReceiveWindowSize() {
        return this.parallelTcpReceiveWindowSize;
    }

    public synchronized void setParallelTcpReceiveWindowSize(int parallelTcpReceiveWindowSize) {
        this.parallelTcpReceiveWindowSize = parallelTcpReceiveWindowSize;
    }

    @Override
    public synchronized int getParallelTcpPerformancePrefsConnectionTime() {
        return this.parallelTcpPerformancePrefsConnectionTime;
    }

    public synchronized void setParallelTcpPerformancePrefsConnectionTime(int parallelTcpPerformancePrefsConnectionTime) {
        this.parallelTcpPerformancePrefsConnectionTime = parallelTcpPerformancePrefsConnectionTime;
    }

    @Override
    public synchronized int getParallelTcpPerformancePrefsLatency() {
        return this.parallelTcpPerformancePrefsLatency;
    }

    public synchronized void setParallelTcpPerformancePrefsLatency(int parallelTcpPerformancePrefsLatency) {
        this.parallelTcpPerformancePrefsLatency = parallelTcpPerformancePrefsLatency;
    }

    @Override
    public synchronized int getParallelTcpPerformancePrefsBandwidth() {
        return this.parallelTcpPerformancePrefsBandwidth;
    }

    public synchronized void setParallelTcpPerformancePrefsBandwidth(int parallelTcpPerformancePrefsBandwidth) {
        this.parallelTcpPerformancePrefsBandwidth = parallelTcpPerformancePrefsBandwidth;
    }

    @Override
    public synchronized boolean isPrimaryTcpKeepAlive() {
        return this.primaryTcpKeepAlive;
    }

    public synchronized void setPrimaryTcpKeepAlive(boolean primaryTcpKeepAlive) {
        this.primaryTcpKeepAlive = primaryTcpKeepAlive;
    }

    @Override
    public synchronized int getPrimaryTcpSendWindowSize() {
        return this.primaryTcpSendWindowSize;
    }

    public synchronized void setPrimaryTcpSendWindowSize(int primaryTcpSendWindowSize) {
        this.primaryTcpSendWindowSize = primaryTcpSendWindowSize;
    }

    @Override
    public synchronized int getPrimaryTcpReceiveWindowSize() {
        return this.primaryTcpReceiveWindowSize;
    }

    public synchronized void setPrimaryTcpReceiveWindowSize(int primaryTcpReceiveWindowSize) {
        this.primaryTcpReceiveWindowSize = primaryTcpReceiveWindowSize;
    }

    @Override
    public synchronized int getPrimaryTcpPerformancePrefsConnectionTime() {
        return this.primaryTcpPerformancePrefsConnectionTime;
    }

    public synchronized void setPrimaryTcpPerformancePrefsConnectionTime(int primaryTcpPerformancePrefsConnectionTime) {
        this.primaryTcpPerformancePrefsConnectionTime = primaryTcpPerformancePrefsConnectionTime;
    }

    @Override
    public synchronized int getPrimaryTcpPerformancePrefsLatency() {
        return this.primaryTcpPerformancePrefsLatency;
    }

    public synchronized void setPrimaryTcpPerformancePrefsLatency(int primaryTcpPerformancePrefsLatency) {
        this.primaryTcpPerformancePrefsLatency = primaryTcpPerformancePrefsLatency;
    }

    @Override
    public synchronized int getPrimaryTcpPerformancePrefsBandwidth() {
        return this.primaryTcpPerformancePrefsBandwidth;
    }

    public synchronized void setPrimaryTcpPerformancePrefsBandwidth(int primaryTcpPerformancePrefsBandwidth) {
        this.primaryTcpPerformancePrefsBandwidth = primaryTcpPerformancePrefsBandwidth;
    }

    public synchronized String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("SettableJargonProperties [useParallelTransfer=");
        builder.append(this.useParallelTransfer);
        builder.append(", useNIOForParallelTransfers=");
        builder.append(false);
        builder.append(", maxParallelThreads=");
        builder.append(this.maxParallelThreads);
        builder.append(", maxFilesAndDirsQueryMax=");
        builder.append(this.maxFilesAndDirsQueryMax);
        builder.append(", useTransferThreadsPool=");
        builder.append(this.useTransferThreadsPool);
        builder.append(", transferThreadPoolMaxSimultaneousTransfers=");
        builder.append(this.transferThreadPoolMaxSimultaneousTransfers);
        builder.append(", transferThreadPoolTimeoutMillis=");
        builder.append(this.transferThreadPoolTimeoutMillis);
        builder.append(", allowPutGetResourceRedirects=");
        builder.append(this.allowPutGetResourceRedirects);
        builder.append(", computeChecksumAfterTransfer=");
        builder.append(this.computeChecksumAfterTransfer);
        builder.append(", computeAndVerifyChecksumAfterTransfer=");
        builder.append(this.computeAndVerifyChecksumAfterTransfer);
        builder.append(", intraFileStatusCallbacks=");
        builder.append(this.intraFileStatusCallbacks);
        builder.append(", irodsSocketTimeout=");
        builder.append(this.irodsSocketTimeout);
        builder.append(", irodsParallelSocketTimeout=");
        builder.append(this.irodsParallelSocketTimeout);
        builder.append(", internalInputStreamBufferSize=");
        builder.append(this.internalInputStreamBufferSize);
        builder.append(", internalOutputStreamBufferSize=");
        builder.append(this.internalOutputStreamBufferSize);
        builder.append(", internalCacheBufferSize=");
        builder.append(this.internalCacheBufferSize);
        builder.append(", sendInputStreamBufferSize=");
        builder.append(this.sendInputStreamBufferSize);
        builder.append(", localFileOutputStreamBufferSize=");
        builder.append(this.localFileOutputStreamBufferSize);
        builder.append(", localFileInputStreamBufferSize=");
        builder.append(this.localFileInputStreamBufferSize);
        builder.append(", putBufferSize=");
        builder.append(this.putBufferSize);
        builder.append(", getBufferSize=");
        builder.append(this.getBufferSize);
        builder.append(", inputToOutputCopyBufferByteSize=");
        builder.append(this.inputToOutputCopyBufferByteSize);
        builder.append(", ");
        if (this.encoding != null) {
            builder.append("encoding=");
            builder.append(this.encoding);
            builder.append(", ");
        }
        builder.append("instrument=");
        builder.append(this.instrument);
        builder.append(", reconnect=");
        builder.append(this.reconnect);
        builder.append(", defaultToPublicIfNothingUnderRootWhenListing=");
        builder.append(this.defaultToPublicIfNothingUnderRootWhenListing);
        builder.append(", reconnectTimeInMillis=");
        builder.append(this.reconnectTimeInMillis);
        builder.append(", usingDiscoveredServerPropertiesCache=");
        builder.append(this.usingDiscoveredServerPropertiesCache);
        builder.append(", usingSpecificQueryForCollectionListingsWithPermissions=");
        builder.append(this.usingSpecificQueryForCollectionListingsWithPermissions);
        builder.append(", usingSpecQueryForDataObjPermissionsForUserInGroup=");
        builder.append(this.usingSpecQueryForDataObjPermissionsForUserInGroup);
        builder.append(", pamTimeToLive=");
        builder.append(this.pamTimeToLive);
        builder.append(", forcePamFlush=");
        builder.append(this.forcePamFlush);
        builder.append(", ");
        if (this.connectionFactory != null) {
            builder.append("connectionFactory=");
            builder.append(this.connectionFactory);
            builder.append(", ");
        }
        if (this.checksumEncoding != null) {
            builder.append("checksumEncoding=");
            builder.append((Object)this.checksumEncoding);
            builder.append(", ");
        }
        builder.append("parallelTcpKeepAlive=");
        builder.append(this.parallelTcpKeepAlive);
        builder.append(", parallelTcpSendWindowSize=");
        builder.append(this.parallelTcpSendWindowSize);
        builder.append(", parallelTcpReceiveWindowSize=");
        builder.append(this.parallelTcpReceiveWindowSize);
        builder.append(", parallelTcpPerformancePrefsConnectionTime=");
        builder.append(this.parallelTcpPerformancePrefsConnectionTime);
        builder.append(", parallelTcpPerformancePrefsLatency=");
        builder.append(this.parallelTcpPerformancePrefsLatency);
        builder.append(", parallelTcpPerformancePrefsBandwidth=");
        builder.append(this.parallelTcpPerformancePrefsBandwidth);
        builder.append(", primaryTcpKeepAlive=");
        builder.append(this.primaryTcpKeepAlive);
        builder.append(", primaryTcpSendWindowSize=");
        builder.append(this.primaryTcpSendWindowSize);
        builder.append(", primaryTcpReceiveWindowSize=");
        builder.append(this.primaryTcpReceiveWindowSize);
        builder.append(", primaryTcpPerformancePrefsConnectionTime=");
        builder.append(this.primaryTcpPerformancePrefsConnectionTime);
        builder.append(", primaryTcpPerformancePrefsLatency=");
        builder.append(this.primaryTcpPerformancePrefsLatency);
        builder.append(", primaryTcpPerformancePrefsBandwidth=");
        builder.append(this.primaryTcpPerformancePrefsBandwidth);
        builder.append(", socketRenewalIntervalInSeconds=");
        builder.append(this.socketRenewalIntervalInSeconds);
        builder.append(", longTransferRestart=");
        builder.append(this.longTransferRestart);
        builder.append(", parallelCopyBufferSize=");
        builder.append(this.parallelCopyBufferSize);
        builder.append(", intraFileStatusCallbacksNumberCallsInterval=");
        builder.append(this.intraFileStatusCallbacksNumberCallsInterval);
        builder.append(", intraFileStatusCallbacksTotalBytesInterval=");
        builder.append(this.intraFileStatusCallbacksTotalBytesInterval);
        builder.append(", ");
        if (this.negotiationPolicy != null) {
            builder.append("negotiationPolicy=");
            builder.append((Object)this.negotiationPolicy);
            builder.append(", ");
        }
        if (this.encryptionAlgorithmEnum != null) {
            builder.append("encryptionAlgorithmEnum=");
            builder.append((Object)this.encryptionAlgorithmEnum);
            builder.append(", ");
        }
        builder.append("encryptionKeySize=");
        builder.append(this.encryptionKeySize);
        builder.append(", encryptionSaltSize=");
        builder.append(this.encryptionSaltSize);
        builder.append(", encryptionNumberHashRounds=");
        builder.append(this.encryptionNumberHashRounds);
        builder.append("]");
        return builder.toString();
    }

    @Override
    public synchronized int getSocketRenewalIntervalInSeconds() {
        return this.socketRenewalIntervalInSeconds;
    }

    public synchronized void setSocketRenewalIntervalInSeconds(int socketRenewalIntervalInSeconds) {
        this.socketRenewalIntervalInSeconds = socketRenewalIntervalInSeconds;
    }

    @Override
    public synchronized boolean isLongTransferRestart() {
        return this.longTransferRestart;
    }

    public synchronized void setLongTransferRestart(boolean longFileTransferRestart) {
        this.longTransferRestart = longFileTransferRestart;
    }

    @Override
    public synchronized int getParallelCopyBufferSize() {
        return this.parallelCopyBufferSize;
    }

    public synchronized void setParallelCopyBufferSize(int parallelCopyBufferSize) {
        this.parallelCopyBufferSize = parallelCopyBufferSize;
    }

    @Override
    public synchronized int getIntraFileStatusCallbacksNumberCallsInterval() {
        return this.intraFileStatusCallbacksNumberCallsInterval;
    }

    public synchronized void setIntraFileStatusCallbacksNumberCallsInterval(int intraFileStatusCallbacksNumberCallsInterval) {
        this.intraFileStatusCallbacksNumberCallsInterval = intraFileStatusCallbacksNumberCallsInterval;
    }

    @Override
    public synchronized long getIntraFileStatusCallbacksTotalBytesInterval() {
        return this.intraFileStatusCallbacksTotalBytesInterval;
    }

    public synchronized void setIntraFileStatusCallbacksTotalBytesInterval(long intraFileStatusCallbacksTotalBytesInterval) {
        this.intraFileStatusCallbacksTotalBytesInterval = intraFileStatusCallbacksTotalBytesInterval;
    }

    @Override
    public synchronized ClientServerNegotiationPolicy.SslNegotiationPolicy getNegotiationPolicy() {
        return this.negotiationPolicy;
    }

    public synchronized void setNegotiationPolicy(ClientServerNegotiationPolicy.SslNegotiationPolicy negotiationPolicy) {
        if (negotiationPolicy == null) {
            throw new IllegalArgumentException("null negotiationPolicy");
        }
        this.negotiationPolicy = negotiationPolicy;
    }

    @Override
    public synchronized EncryptionAlgorithmEnum getEncryptionAlgorithmEnum() {
        return this.encryptionAlgorithmEnum;
    }

    public synchronized void setEncryptionAlgorithmEnum(EncryptionAlgorithmEnum encryptionAlgorithmEnum) {
        this.encryptionAlgorithmEnum = encryptionAlgorithmEnum;
    }

    @Override
    public synchronized int getEncryptionKeySize() {
        return this.encryptionKeySize;
    }

    public synchronized void setEncryptionKeySize(int encryptionKeySize) {
        this.encryptionKeySize = encryptionKeySize;
    }

    @Override
    public synchronized int getEncryptionSaltSize() {
        return this.encryptionSaltSize;
    }

    public synchronized void setEncryptionSaltSize(int encryptionSaltSize) {
        this.encryptionSaltSize = encryptionSaltSize;
    }

    @Override
    public synchronized int getEncryptionNumberHashRounds() {
        return this.encryptionNumberHashRounds;
    }

    public synchronized void setEncryptionNumberHashRounds(int encryptionNumberHashRounds) {
        this.encryptionNumberHashRounds = encryptionNumberHashRounds;
    }

    @Override
    public synchronized boolean isBypassSslCertChecks() {
        return this.bypassSslCertChecks;
    }

    public synchronized void setBypassSslCertChecks(boolean bypassSslCertChecks) {
        this.bypassSslCertChecks = bypassSslCertChecks;
    }
}

