/*
 * Decompiled with CFR 0.152.
 */
package org.irods.jargon.core.connection;

import java.util.Date;
import org.irods.jargon.core.connection.IrodsVersion;

public class IRODSServerProperties {
    private final Date initializeDate = new Date();
    private final IcatEnabled icatEnabled;
    private final int serverBootTime;
    private IrodsVersion irodsVersion;
    private final String apiVersion;
    private final String rodsZone;

    public static IRODSServerProperties instance(IcatEnabled icatEnabled, int serverBootTime, String relVersion, String apiVersion, String rodsZone) {
        return new IRODSServerProperties(icatEnabled, serverBootTime, relVersion, apiVersion, rodsZone);
    }

    private IRODSServerProperties(IcatEnabled icatEnabled, int serverBootTime, String relVersion, String apiVersion, String rodsZone) {
        this.icatEnabled = icatEnabled;
        this.serverBootTime = serverBootTime;
        this.apiVersion = apiVersion;
        this.irodsVersion = new IrodsVersion(relVersion);
        this.rodsZone = rodsZone;
    }

    public Date getInitializeDate() {
        return this.initializeDate;
    }

    public IcatEnabled getIcatEnabled() {
        return this.icatEnabled;
    }

    public int getServerBootTime() {
        return this.serverBootTime;
    }

    public String getApiVersion() {
        return this.apiVersion;
    }

    public String getRodsZone() {
        return this.rodsZone;
    }

    public boolean isSupportsConnectionRerouting() {
        boolean supports = false;
        if (this.isTheIrodsServerAtLeastAtTheGivenReleaseVersion("rods2.5")) {
            supports = true;
        }
        return supports;
    }

    public boolean isSupportsSpecificQuery() {
        boolean supports = false;
        if (this.isTheIrodsServerAtLeastAtTheGivenReleaseVersion("rods3.1")) {
            supports = true;
        }
        return supports;
    }

    public boolean isSupportsTickets() {
        boolean supports = false;
        if (this.isTheIrodsServerAtLeastAtTheGivenReleaseVersion("rods3.1")) {
            supports = true;
        }
        return supports;
    }

    public boolean isSupportsWSOWorkflow() {
        boolean supports = false;
        if (this.isTheIrodsServerAtLeastAtTheGivenReleaseVersion("rods3.2")) {
            supports = true;
        }
        return supports;
    }

    public boolean isSupportsCaseInsensitiveQueries() {
        boolean supports = false;
        if (this.isTheIrodsServerAtLeastAtTheGivenReleaseVersion("rods3.2")) {
            supports = true;
        }
        return supports;
    }

    public boolean isTheIrodsServerAtLeastAtTheGivenReleaseVersion(String releaseVersion) {
        if (releaseVersion == null || releaseVersion.length() == 0) {
            throw new IllegalArgumentException("null or empty releaseVersion");
        }
        int compare = this.getIrodsVersion().compareTo(new IrodsVersion(releaseVersion));
        return compare >= 0;
    }

    public boolean isNeedsPamFlush() {
        return this.isTheIrodsServerAtLeastAtTheGivenReleaseVersion("rods4.0") && !this.isAtLeastIrods410();
    }

    public boolean isAtLeastIrods410() {
        return this.isTheIrodsServerAtLeastAtTheGivenReleaseVersion("rods4.1.0");
    }

    public boolean isAtLeastIrods420() {
        return this.isTheIrodsServerAtLeastAtTheGivenReleaseVersion("rods4.2.0");
    }

    public IrodsVersion getIrodsVersion() {
        return this.irodsVersion;
    }

    public static enum IcatEnabled {
        ICAT_ENABLED,
        NO_ICAT;

    }
}

