/*
 * Decompiled with CFR 0.152.
 */
package com.joyent.manta.client;

import com.joyent.http.signature.KeyFingerprinter;
import com.joyent.http.signature.Signer;
import com.joyent.http.signature.ThreadLocalSigner;
import com.joyent.manta.config.AuthAwareConfigContext;
import com.joyent.manta.config.ConfigContext;
import java.io.IOException;
import java.net.URI;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.security.KeyPair;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.bouncycastle.util.encoders.Base64;

public class UriSigner {
    private final AuthAwareConfigContext authConfig;

    @Deprecated
    public UriSigner(ConfigContext config, KeyPair keyPair, ThreadLocalSigner signer) {
        this(new AuthAwareConfigContext(config));
    }

    UriSigner(AuthAwareConfigContext authConfig) {
        this.authConfig = authConfig;
    }

    public URI signURI(URI uri, String method, long expires) throws IOException {
        Validate.notNull((Object)method, (String)"Method must not be null", (Object[])new Object[0]);
        Validate.notNull((Object)uri, (String)"URI must not be null", (Object[])new Object[0]);
        Validate.isTrue((boolean)StringUtils.isEmpty((CharSequence)uri.getQuery()), (String)"Query must be null or empty. URI: %s", (Object[])new Object[]{uri});
        ThreadLocalSigner signer = this.authConfig.getSigner();
        String charset = "UTF-8";
        String algorithm = ((Signer)signer.get()).getHttpHeaderAlgorithm().toUpperCase();
        String keyId = String.format("/%s/keys/%s", this.authConfig.getMantaUser(), KeyFingerprinter.md5Fingerprint((KeyPair)this.authConfig.getKeyPair()));
        String keyIdEncoded = URLEncoder.encode(keyId, "UTF-8");
        StringBuilder sigText = new StringBuilder();
        sigText.append(method).append("\n").append(uri.getHost()).append("\n").append(uri.getRawPath()).append("\n").append("algorithm=").append(algorithm).append("&").append("expires=").append(expires).append("&").append("keyId=").append(keyIdEncoded);
        StringBuilder request = new StringBuilder();
        byte[] sigBytes = sigText.toString().getBytes(StandardCharsets.UTF_8);
        byte[] signed = ((Signer)signer.get()).sign("", this.authConfig.getKeyPair(), sigBytes);
        String encoded = new String(Base64.encode((byte[])signed), "UTF-8");
        String urlEncoded = URLEncoder.encode(encoded, "UTF-8");
        request.append(uri).append("?").append("algorithm=").append(algorithm).append("&").append("expires=").append(expires).append("&").append("keyId=").append(keyIdEncoded).append("&").append("signature=").append(urlEncoded);
        return URI.create(request.toString());
    }
}

