/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.onedrive.client.types;

import com.eclipsesource.json.JsonObject;
import com.eclipsesource.json.JsonValue;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.nuxeo.onedrive.client.OneDriveAPI;
import org.nuxeo.onedrive.client.OneDriveJsonRequest;
import org.nuxeo.onedrive.client.OneDriveJsonResponse;
import org.nuxeo.onedrive.client.URLTemplate;
import org.nuxeo.onedrive.client.types.BaseItem;
import org.nuxeo.onedrive.client.types.Drive;
import org.nuxeo.onedrive.client.types.Facet;
import org.nuxeo.onedrive.client.types.File;
import org.nuxeo.onedrive.client.types.FileSystemInfo;
import org.nuxeo.onedrive.client.types.Folder;
import org.nuxeo.onedrive.client.types.Package;

public class DriveItem
extends BaseItem {
    private final ParentReference parent;
    private final ItemIdentifierType itemIdentifierType;

    public DriveItem(Drive parent) {
        super(parent.getApi(), null);
        this.parent = new DriveParent(parent);
        this.itemIdentifierType = null;
    }

    public DriveItem(Drive parent, String id) {
        super(parent.getApi(), id);
        this.parent = new DriveParent(parent);
        this.itemIdentifierType = ItemIdentifierType.Id;
    }

    public DriveItem(DriveItem parent, String path) {
        super(parent.getApi(), path);
        this.parent = new ItemParent(parent);
        this.itemIdentifierType = ItemIdentifierType.Path;
    }

    public ItemIdentifierType getItemIdentifierType() {
        return this.itemIdentifierType;
    }

    public Drive getDrive() {
        if (this.parent instanceof DriveParent) {
            return (Drive)((DriveParent)this.parent).getParent();
        }
        return ((DriveItem)((ItemParent)this.parent).getParent()).getDrive();
    }

    @Override
    public String getPath() {
        if (this.parent instanceof DriveParent) {
            DriveParent drive = (DriveParent)this.parent;
            if (null == this.itemIdentifierType) {
                return ((Drive)drive.getParent()).getAction("/root");
            }
            if (ItemIdentifierType.Id == this.itemIdentifierType) {
                return ((Drive)drive.getParent()).getAction("/items/" + this.getId());
            }
        } else if (this.parent instanceof ItemParent) {
            ItemParent item = (ItemParent)this.parent;
            return ((DriveItem)item.getParent()).getAction(":/" + this.getId());
        }
        return null;
    }

    @Override
    public String getAction(String action) {
        StringBuilder actionPathBuilder = new StringBuilder();
        actionPathBuilder.append(this.getPath());
        if (ItemIdentifierType.Path == this.itemIdentifierType) {
            actionPathBuilder.append(":");
        }
        actionPathBuilder.append(action);
        return actionPathBuilder.toString();
    }

    @Override
    public Metadata getMetadata() throws IOException {
        URL url = new URLTemplate(this.getPath()).build(this.getApi().getBaseURL());
        OneDriveJsonRequest request = new OneDriveJsonRequest(url, "GET");
        OneDriveJsonResponse response = request.sendRequest(this.getApi().getExecutor());
        return (Metadata)new Metadata().fromJson(response.getContent());
    }

    public static Metadata parseJson(OneDriveAPI api, JsonObject jsonObject) {
        String id = jsonObject.get("id").asString();
        JsonValue parentReference = jsonObject.get("parentReference");
        Drive drive = null == parentReference ? new Drive(api) : new Drive(api, parentReference.asObject().get("driveId").asString());
        DriveItem item = new DriveItem(drive, id);
        return (Metadata)item.new Metadata().fromJson(jsonObject);
    }

    public class Metadata
    extends BaseItem.Metadata<Metadata> {
        private String cTag;
        private String description;
        private Metadata remoteItem;
        private Long size;
        private String webDavUrl;
        private final Map<Class, Facet> facetMap;

        public Metadata() {
            super(DriveItem.this);
            this.facetMap = new HashMap<Class, Facet>();
        }

        public Package getPackage() {
            return this.getFacet(Package.class);
        }

        public File getFile() {
            return this.getFacet(File.class);
        }

        public Folder getFolder() {
            return this.getFacet(Folder.class);
        }

        public boolean isPackage() {
            return null != this.getFacet(Package.class);
        }

        public boolean isFile() {
            return null != this.getFacet(File.class);
        }

        public boolean isFolder() {
            return null != this.getFacet(Folder.class);
        }

        public String getcTag() {
            return this.cTag;
        }

        @Override
        public String getDescription() {
            return this.description;
        }

        public Metadata getRemoteItem() {
            return this.remoteItem;
        }

        public Long getSize() {
            return this.size;
        }

        public String getWebDavUrl() {
            return this.webDavUrl;
        }

        public <T extends Facet> T getFacet(Class<T> clazz) {
            return (T)((Facet)this.facetMap.getOrDefault(clazz, null));
        }

        @Override
        protected void parseMember(JsonObject.Member member) {
            switch (member.getName()) {
                case "cTag": {
                    this.cTag = member.getValue().asString();
                    break;
                }
                case "description": {
                    this.description = member.getValue().asString();
                    break;
                }
                case "remoteItem": {
                    this.remoteItem = DriveItem.parseJson(DriveItem.this.getApi(), member.getValue().asObject());
                    break;
                }
                case "size": {
                    this.size = member.getValue().asLong();
                    break;
                }
                case "webDavUrl": {
                    this.webDavUrl = member.getValue().asString();
                    break;
                }
                case "file": {
                    this.facetMap.put(File.class, (Facet)new File().fromJson(member.getValue().asObject()));
                    break;
                }
                case "fileSystemInfo": {
                    this.facetMap.put(FileSystemInfo.class, (Facet)new FileSystemInfo().fromJson(member.getValue().asObject()));
                    break;
                }
                case "folder": {
                    this.facetMap.put(Folder.class, (Facet)new Folder().fromJson(member.getValue().asObject()));
                    break;
                }
                case "audio": 
                case "content": 
                case "deleted": 
                case "image": 
                case "location": 
                case "pendingOperations": 
                case "photo": 
                case "publication": 
                case "root": 
                case "searchResult": 
                case "shared": 
                case "specialFolder": 
                case "video": {
                    break;
                }
                case "activities": 
                case "analytics": 
                case "children": 
                case "createdByUser": 
                case "lastModifiedByUser": 
                case "permissions": 
                case "subscriptions": 
                case "thumbnails": 
                case "versions": {
                    break;
                }
                default: {
                    super.parseMember(member);
                }
            }
        }
    }

    private static class ItemParent
    extends ParentReference<DriveItem> {
        ItemParent(DriveItem parent) {
            super(parent);
        }
    }

    private static class DriveParent
    extends ParentReference<Drive> {
        DriveParent(Drive parent) {
            super(parent);
        }
    }

    private static abstract class ParentReference<T> {
        private final T parent;

        ParentReference(T parent) {
            this.parent = parent;
        }

        public T getParent() {
            return this.parent;
        }
    }

    public static enum ItemIdentifierType {
        Id,
        Path;

    }
}

