/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.importer;

import ch.cyberduck.core.Filter;
import ch.cyberduck.core.Host;
import ch.cyberduck.core.Local;
import ch.cyberduck.core.LocalFactory;
import ch.cyberduck.core.ProtocolFactory;
import ch.cyberduck.core.Scheme;
import ch.cyberduck.core.date.ISO8601DateParser;
import ch.cyberduck.core.date.InvalidDateException;
import ch.cyberduck.core.exception.AccessDeniedException;
import ch.cyberduck.core.ftp.FTPConnectMode;
import ch.cyberduck.core.importer.XmlBookmarkCollection;
import ch.cyberduck.core.preferences.PreferencesFactory;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;
import org.xml.sax.Attributes;

public class SmartFtpBookmarkCollection
extends XmlBookmarkCollection {
    private static final Logger log = Logger.getLogger(SmartFtpBookmarkCollection.class);
    private static final long serialVersionUID = 6455585501577444740L;

    @Override
    public String getBundleIdentifier() {
        return "com.smartftp";
    }

    @Override
    public String getName() {
        return "SmartFTP";
    }

    @Override
    public Local getFile() {
        return LocalFactory.get((String)PreferencesFactory.get().getProperty("bookmark.import.smartftp.location"));
    }

    @Override
    protected void parse(ProtocolFactory protocols, Local folder) throws AccessDeniedException {
        for (Local child : folder.list().filter((Filter)new Filter<Local>(){

            public boolean accept(Local file) {
                if (file.isDirectory()) {
                    return true;
                }
                return "xml".equals(file.getExtension());
            }

            public Pattern toPattern() {
                return Pattern.compile(".*\\.xml");
            }
        })) {
            if (child.isDirectory()) {
                this.parse(protocols, child);
                continue;
            }
            this.read(protocols, child);
        }
    }

    @Override
    protected XmlBookmarkCollection.AbstractHandler getHandler(ProtocolFactory protocols) {
        return new ServerHandler(protocols);
    }

    private class ServerHandler
    extends XmlBookmarkCollection.AbstractHandler {
        private final ProtocolFactory protocols;
        private Host current = null;

        public ServerHandler(ProtocolFactory protocols) {
            this.protocols = protocols;
        }

        @Override
        public void startElement(String name, Attributes attrs) {
            if (name.equals("FavoriteItem")) {
                this.current = new Host(this.protocols.forScheme(Scheme.ftp));
                this.current.getCredentials().setUsername(PreferencesFactory.get().getProperty("connection.login.anon.name"));
            }
        }

        @Override
        public void endElement(String name, String elementText) {
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("endElement:%s,%s", name, elementText));
            }
            switch (name) {
                case "Host": {
                    this.current.setHostname(elementText);
                    break;
                }
                case "Protocol": {
                    try {
                        switch (Integer.parseInt(elementText)) {
                            case 1: {
                                this.current.setProtocol(this.protocols.forScheme(Scheme.ftp));
                                break;
                            }
                            case 2: 
                            case 3: {
                                this.current.setProtocol(this.protocols.forScheme(Scheme.ftps));
                                break;
                            }
                            case 4: {
                                this.current.setProtocol(this.protocols.forScheme(Scheme.sftp));
                            }
                        }
                        this.current.setPort(-1);
                    }
                    catch (NumberFormatException e) {
                        log.warn((Object)("Unknown Protocol:" + e.getMessage()));
                    }
                    break;
                }
                case "Port": {
                    try {
                        this.current.setPort(Integer.parseInt(elementText));
                    }
                    catch (NumberFormatException e) {
                        log.warn((Object)("Invalid Port:" + e.getMessage()));
                    }
                    break;
                }
                case "LastConnect": {
                    try {
                        this.current.setTimestamp(new ISO8601DateParser().parse(elementText));
                    }
                    catch (InvalidDateException e) {
                        log.warn((Object)String.format("Failed to parse timestamp from %s %s", elementText, e.getMessage()));
                    }
                    break;
                }
                case "User": {
                    this.current.getCredentials().setUsername(elementText);
                    break;
                }
                case "Name": {
                    this.current.setNickname(elementText);
                    break;
                }
                case "DataConnectionMethod": {
                    try {
                        switch (Integer.parseInt(elementText)) {
                            case 0: {
                                this.current.setFTPConnectMode(FTPConnectMode.active);
                                break;
                            }
                            case 1: {
                                this.current.setFTPConnectMode(FTPConnectMode.passive);
                            }
                        }
                    }
                    catch (NumberFormatException e) {
                        log.warn((Object)("Invalid connect mode:" + e.getMessage()));
                    }
                    break;
                }
                case "Description": {
                    this.current.setComment(elementText);
                    break;
                }
                case "Path": {
                    this.current.setDefaultPath(elementText);
                    break;
                }
                case "HTTP": {
                    this.current.setWebURL(elementText);
                    break;
                }
                case "WebRootPath": {
                    this.current.setDefaultPath(elementText);
                    break;
                }
                case "PrivateKey": {
                    this.current.getCredentials().setIdentity(LocalFactory.get((String)elementText));
                    break;
                }
                case "FavoriteItem": {
                    SmartFtpBookmarkCollection.this.add(this.current);
                }
            }
        }
    }
}

