/*
 * Decompiled with CFR 0.152.
 */
package com.nulabinc.zxcvbn.matchers;

import com.nulabinc.zxcvbn.WipeableString;
import com.nulabinc.zxcvbn.matchers.BaseMatcher;
import com.nulabinc.zxcvbn.matchers.DictionaryMatcher;
import com.nulabinc.zxcvbn.matchers.L33tSubDict;
import com.nulabinc.zxcvbn.matchers.Match;
import com.nulabinc.zxcvbn.matchers.MatchFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class L33tMatcher
extends BaseMatcher {
    private final Map<String, Map<String, Integer>> rankedDictionaries;
    private static final Map<Character, List<Character>> L33T_TABLE = new HashMap<Character, List<Character>>();

    public L33tMatcher() {
        this(new HashMap<String, Map<String, Integer>>());
    }

    public L33tMatcher(Map<String, Map<String, Integer>> rankedDictionaries) {
        this.rankedDictionaries = rankedDictionaries == null ? new HashMap<String, Map<String, Integer>>() : rankedDictionaries;
    }

    public Map<Character, List<Character>> relevantL33tSubTable(CharSequence password) {
        return this.relevantL33tSubTable(password, L33T_TABLE);
    }

    public Map<Character, List<Character>> relevantL33tSubTable(CharSequence password, Map<Character, List<Character>> table) {
        HashMap<Character, Boolean> passwordChars = new HashMap<Character, Boolean>();
        for (int n = 0; n < password.length(); ++n) {
            passwordChars.put(Character.valueOf(password.charAt(n)), true);
        }
        HashMap<Character, List<Character>> subTable = new HashMap<Character, List<Character>>();
        for (Map.Entry<Character, List<Character>> l33tRowRef : table.entrySet()) {
            Character letter = l33tRowRef.getKey();
            List<Character> subs = l33tRowRef.getValue();
            ArrayList<Character> relevantSubs = new ArrayList<Character>();
            for (Character sub : subs) {
                if (!passwordChars.containsKey(sub)) continue;
                relevantSubs.add(sub);
            }
            if (relevantSubs.size() <= 0) continue;
            subTable.put(letter, relevantSubs);
        }
        return subTable;
    }

    @Override
    public List<Match> execute(CharSequence password) {
        ArrayList<Match> matches = new ArrayList<Match>();
        Map<Character, List<Character>> subTable = this.relevantL33tSubTable(password);
        L33tSubDict l33tSubs = new L33tSubDict(subTable);
        for (Map<Character, Character> sub : l33tSubs) {
            if (sub.isEmpty()) break;
            CharSequence subbedPassword = this.translate(password, sub);
            for (Match match : new DictionaryMatcher(this.rankedDictionaries).execute(subbedPassword)) {
                WipeableString token = WipeableString.copy(password, match.i, match.j + 1);
                WipeableString lower = WipeableString.lowerCase(token);
                if (lower.equals(match.matchedWord)) {
                    token.wipe();
                    lower.wipe();
                    continue;
                }
                HashMap<Character, Character> matchSub = new HashMap<Character, Character>();
                for (Map.Entry<Character, Character> entry : sub.entrySet()) {
                    Character subbedChr = entry.getKey();
                    Character chr = entry.getValue();
                    if (token.indexOf(subbedChr.charValue()) == -1) continue;
                    matchSub.put(subbedChr, chr);
                }
                ArrayList<String> subDisplays = new ArrayList<String>();
                for (Map.Entry matchSubRef : matchSub.entrySet()) {
                    Character k = (Character)matchSubRef.getKey();
                    Character v = (Character)matchSubRef.getValue();
                    subDisplays.add(String.format("%s -> %s", k, v));
                }
                String string = Arrays.toString(subDisplays.toArray(new String[0]));
                matches.add(MatchFactory.createDictionaryL33tMatch(match.i, match.j, token, match.matchedWord, match.rank, match.dictionaryName, match.reversed, matchSub, string));
                lower.wipe();
            }
        }
        ArrayList<Match> lst = new ArrayList<Match>();
        for (Match match : matches) {
            if (match.tokenLength() <= 1) continue;
            lst.add(match);
        }
        return this.sorted(lst);
    }

    static {
        L33T_TABLE.put(Character.valueOf('a'), Arrays.asList(Character.valueOf('4'), Character.valueOf('@')));
        L33T_TABLE.put(Character.valueOf('b'), Arrays.asList(Character.valueOf('8')));
        L33T_TABLE.put(Character.valueOf('c'), Arrays.asList(Character.valueOf('('), Character.valueOf('{'), Character.valueOf('['), Character.valueOf('<')));
        L33T_TABLE.put(Character.valueOf('e'), Arrays.asList(Character.valueOf('3')));
        L33T_TABLE.put(Character.valueOf('g'), Arrays.asList(Character.valueOf('6'), Character.valueOf('9')));
        L33T_TABLE.put(Character.valueOf('i'), Arrays.asList(Character.valueOf('1'), Character.valueOf('!'), Character.valueOf('|')));
        L33T_TABLE.put(Character.valueOf('l'), Arrays.asList(Character.valueOf('1'), Character.valueOf('|'), Character.valueOf('7')));
        L33T_TABLE.put(Character.valueOf('o'), Arrays.asList(Character.valueOf('0')));
        L33T_TABLE.put(Character.valueOf('s'), Arrays.asList(Character.valueOf('$'), Character.valueOf('5')));
        L33T_TABLE.put(Character.valueOf('t'), Arrays.asList(Character.valueOf('+'), Character.valueOf('7')));
        L33T_TABLE.put(Character.valueOf('x'), Arrays.asList(Character.valueOf('%')));
        L33T_TABLE.put(Character.valueOf('z'), Arrays.asList(Character.valueOf('2')));
    }
}

