/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.cli;

import ch.cyberduck.core.Factory;
import ch.cyberduck.core.exception.ConnectionCanceledException;
import ch.cyberduck.core.exception.LoginCanceledException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.concurrent.Semaphore;
import org.apache.commons.lang3.StringUtils;
import org.fusesource.jansi.AnsiConsole;

public class Console {
    private final java.io.Console console;
    private final PrintStream out = AnsiConsole.out();
    private static final Semaphore lock = new Semaphore(1);

    public Console() {
        switch (Factory.Platform.getDefault()) {
            case windows: {
                this.console = null;
                break;
            }
            default: {
                this.console = System.console();
            }
        }
    }

    public String readLine(String format, Object ... args) throws ConnectionCanceledException {
        if (this.console != null) {
            return this.wrap(this.console.readLine(format, args));
        }
        this.printf(format, args);
        BufferedReader reader = new BufferedReader(new InputStreamReader(System.in));
        try {
            return this.wrap(reader.readLine());
        }
        catch (IOException e) {
            throw new ConnectionCanceledException(e);
        }
    }

    public char[] readPassword(String format, Object ... args) throws ConnectionCanceledException {
        if (this.console != null) {
            return this.wrap(this.console.readPassword(format, args));
        }
        String line = this.readLine(format, args);
        if (StringUtils.isBlank((CharSequence)line)) {
            throw new LoginCanceledException();
        }
        return line.toCharArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printf(String format, Object ... args) {
        if (StringUtils.isEmpty((CharSequence)format)) {
            return;
        }
        try {
            lock.acquire();
            if (this.console != null) {
                PrintWriter writer = this.console.writer();
                if (Arrays.asList(args).isEmpty()) {
                    writer.print(format);
                } else {
                    writer.printf(format, args);
                }
                writer.flush();
            } else {
                if (Arrays.asList(args).isEmpty()) {
                    this.out.printf(format, new Object[0]);
                } else {
                    this.out.printf(format, args);
                }
                this.out.flush();
            }
        }
        catch (InterruptedException interruptedException) {
        }
        finally {
            lock.release();
        }
    }

    private String wrap(String input) throws ConnectionCanceledException {
        if (null == input) {
            throw new ConnectionCanceledException();
        }
        return input;
    }

    private char[] wrap(char[] input) throws ConnectionCanceledException {
        if (null == input) {
            throw new ConnectionCanceledException();
        }
        return input;
    }
}

