/*
 * Decompiled with CFR 0.152.
 */
package org.freedesktop.dbus.connections;

import java.util.concurrent.LinkedBlockingQueue;
import org.freedesktop.dbus.connections.AbstractConnection;
import org.freedesktop.dbus.messages.Message;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SenderThread
extends Thread {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private boolean terminate;
    private final LinkedBlockingQueue<Message> outgoingQueue = new LinkedBlockingQueue();
    private final AbstractConnection abstractConnection;

    SenderThread(AbstractConnection _abstractConnection) {
        this.abstractConnection = _abstractConnection;
        this.setName("DBUS Sender Thread");
    }

    public void terminate() {
        this.terminate = true;
        this.interrupt();
    }

    public LinkedBlockingQueue<Message> getOutgoingQueue() {
        return this.outgoingQueue;
    }

    @Override
    public void run() {
        Message poll;
        Message m = null;
        this.logger.trace("Monitoring outbound queue");
        while (!this.terminate) {
            try {
                m = this.outgoingQueue.take();
                if (m == null) continue;
                this.abstractConnection.sendMessage(m);
                m = null;
            }
            catch (InterruptedException _ex) {
                if (this.terminate) continue;
                this.logger.warn("Interrupted while waiting for a message to send", (Throwable)_ex);
            }
        }
        this.logger.debug("Flushing outbound queue and quitting");
        while (!this.outgoingQueue.isEmpty() && (poll = this.outgoingQueue.poll()) != null) {
            this.abstractConnection.sendMessage(this.outgoingQueue.poll());
        }
    }
}

