/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.cryptolib.common;

import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Mac;
import javax.crypto.SecretKey;

public final class MacSupplier {
    public static final MacSupplier HMAC_SHA256 = new MacSupplier("HmacSHA256");
    private final String macAlgorithm;
    private final ThreadLocal<Mac> threadLocal;

    public MacSupplier(String macAlgorithm) {
        this.macAlgorithm = macAlgorithm;
        this.threadLocal = new Provider();
    }

    public Mac withKey(SecretKey key) {
        try {
            Mac mac = this.threadLocal.get();
            mac.init(key);
            return mac;
        }
        catch (InvalidKeyException e) {
            throw new IllegalArgumentException("Invalid key.", e);
        }
    }

    private class Provider
    extends ThreadLocal<Mac> {
        private Provider() {
        }

        @Override
        protected Mac initialValue() {
            try {
                return Mac.getInstance(MacSupplier.this.macAlgorithm);
            }
            catch (NoSuchAlgorithmException e) {
                throw new IllegalArgumentException("Invalid MAC algorithm.", e);
            }
        }
    }
}

