/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.cryptomator.features;

import ch.cyberduck.core.Credentials;
import ch.cyberduck.core.PasswordCallback;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.VersioningConfiguration;
import ch.cyberduck.core.cache.LRUCache;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.ConnectionCanceledException;
import ch.cyberduck.core.features.Vault;
import ch.cyberduck.core.features.Versioning;

public class CryptoVersioningFeature
implements Versioning {
    private final Session<?> session;
    private final Versioning delegate;
    private final Vault vault;

    public CryptoVersioningFeature(Session<?> session, Versioning delegate, Vault vault) {
        this.session = session;
        this.delegate = delegate;
        this.vault = vault;
    }

    public Versioning withCache(LRUCache<Path, VersioningConfiguration> cache) {
        this.delegate.withCache(cache);
        return this;
    }

    public VersioningConfiguration getConfiguration(Path container) throws BackgroundException {
        return this.delegate.getConfiguration(this.vault.encrypt(this.session, container));
    }

    public void setConfiguration(Path container, PasswordCallback prompt, VersioningConfiguration configuration) throws BackgroundException {
        this.delegate.setConfiguration(this.vault.encrypt(this.session, container), prompt, configuration);
    }

    public void revert(Path file) throws BackgroundException {
        this.delegate.revert(this.vault.encrypt(this.session, file));
    }

    public boolean isRevertable(Path file) {
        return this.delegate.isRevertable(file);
    }

    public Credentials getToken(String mfaSerial, PasswordCallback callback) throws ConnectionCanceledException {
        return this.delegate.getToken(mfaSerial, callback);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("CryptoVersioningFeature{");
        sb.append("delegate=").append(this.delegate);
        sb.append('}');
        return sb.toString();
    }
}

