/*
 * Decompiled with CFR 0.152.
 */
package com.joyent.http.signature.crypto;

import com.joyent.http.signature.CryptoException;
import com.joyent.http.signature.crypto.JceDigest;
import com.joyent.http.signature.crypto.NativeRSABlindedEngine;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.nist.NISTObjectIdentifiers;
import org.bouncycastle.asn1.oiw.OIWObjectIdentifiers;
import org.bouncycastle.crypto.AsymmetricBlockCipher;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.encodings.PKCS1Encoding;
import org.bouncycastle.jcajce.provider.asymmetric.rsa.DigestSignatureSpi;
import org.bouncycastle.jcajce.provider.util.DigestFactory;

public abstract class NativeRSAWithSHA
extends DigestSignatureSpi {
    protected NativeRSAWithSHA(ASN1ObjectIdentifier objId, Digest digest, AsymmetricBlockCipher cipher) {
        super(objId, digest, cipher);
    }

    private static Digest getDigest(String digest) {
        try {
            return new JceDigest(digest);
        }
        catch (CryptoException e) {
            String noHyphen = digest.replaceFirst("-", "");
            return DigestFactory.getDigest((String)noHyphen);
        }
    }

    public static class SHA512
    extends NativeRSAWithSHA {
        public SHA512() {
            super(NISTObjectIdentifiers.id_sha512, NativeRSAWithSHA.getDigest("SHA-512"), (AsymmetricBlockCipher)new PKCS1Encoding((AsymmetricBlockCipher)new NativeRSABlindedEngine()));
        }
    }

    public static class SHA256
    extends NativeRSAWithSHA {
        public SHA256() {
            super(NISTObjectIdentifiers.id_sha256, NativeRSAWithSHA.getDigest("SHA-256"), (AsymmetricBlockCipher)new PKCS1Encoding((AsymmetricBlockCipher)new NativeRSABlindedEngine()));
        }
    }

    public static class SHA1
    extends NativeRSAWithSHA {
        public SHA1() {
            super(OIWObjectIdentifiers.idSHA1, NativeRSAWithSHA.getDigest("SHA-1"), (AsymmetricBlockCipher)new PKCS1Encoding((AsymmetricBlockCipher)new NativeRSABlindedEngine()));
        }
    }
}

