/*
 * Decompiled with CFR 0.152.
 */
package com.spectralogic.ds3client.helpers;

import com.google.common.collect.Sets;
import com.spectralogic.ds3client.models.BulkObject;
import com.spectralogic.ds3client.models.Objects;
import com.spectralogic.ds3client.models.PhysicalPlacement;
import java.util.Collection;
import java.util.Set;
import java.util.UUID;

public class JobState {
    private final Set<BlobIdentityDecorator> blobs = Sets.newConcurrentHashSet();
    private final int numBlobsInJob;

    public JobState(Collection<Objects> chunksThatContainBlobs) {
        int numBlobsInChunks = 0;
        for (Objects chunk : chunksThatContainBlobs) {
            for (BulkObject blob : chunk.getObjects()) {
                this.blobs.add(new BlobIdentityDecorator(blob));
                ++numBlobsInChunks;
            }
        }
        this.numBlobsInJob = numBlobsInChunks;
    }

    public boolean blobTransferredOrFailed(BulkObject blob) {
        return this.blobs.remove(new BlobIdentityDecorator(blob));
    }

    public boolean contains(BulkObject blob) {
        return this.blobs.contains(new BlobIdentityDecorator(blob));
    }

    public int numBlobsInJob() {
        return this.numBlobsInJob;
    }

    private static class BlobIdentityDecorator {
        private final String bucket;
        private final UUID id;
        private final boolean latest;
        private final long length;
        private final String name;
        private final long offset;
        private final PhysicalPlacement physicalPlacement;
        private final UUID versionId;

        private BlobIdentityDecorator(BulkObject blob) {
            this.bucket = blob.getBucket();
            this.id = blob.getId();
            this.latest = blob.getLatest();
            this.length = blob.getLength();
            this.name = blob.getName();
            this.offset = blob.getOffset();
            this.physicalPlacement = blob.getPhysicalPlacement();
            this.versionId = blob.getVersionId();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof BlobIdentityDecorator)) {
                return false;
            }
            BlobIdentityDecorator that = (BlobIdentityDecorator)o;
            if (this.latest != that.latest) {
                return false;
            }
            if (this.length != that.length) {
                return false;
            }
            if (this.offset != that.offset) {
                return false;
            }
            if (this.versionId != null ? !this.versionId.equals(that.versionId) : that.versionId != null) {
                return false;
            }
            if (this.bucket != null ? !this.bucket.equals(that.bucket) : that.bucket != null) {
                return false;
            }
            if (this.id != null ? !this.id.equals(that.id) : that.id != null) {
                return false;
            }
            if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
                return false;
            }
            return this.physicalPlacement != null ? this.physicalPlacement.equals(that.physicalPlacement) : that.physicalPlacement == null;
        }

        public int hashCode() {
            return java.util.Objects.hash(this.bucket, this.id, this.latest, this.length, this.name, this.offset, this.physicalPlacement, this.versionId);
        }

        public String toString() {
            return "BlobIdentityDecorator{bucket='" + this.bucket + '\'' + ", length=" + this.length + ", name='" + this.name + '\'' + ", offset=" + this.offset + '}';
        }
    }
}

