/*
 * Decompiled with CFR 0.152.
 */
package com.spectralogic.ds3client.commands.spectrads3.notifications;

import com.spectralogic.ds3client.commands.interfaces.AbstractCreateNotificationRequest;
import com.spectralogic.ds3client.models.HttpResponseFormatType;
import com.spectralogic.ds3client.models.NamingConventionType;
import com.spectralogic.ds3client.models.RequestType;
import java.util.UUID;

public class PutJobCompletedNotificationRegistrationSpectraS3Request
extends AbstractCreateNotificationRequest {
    private HttpResponseFormatType format;
    private String jobId;
    private NamingConventionType namingConvention;
    private RequestType notificationHttpMethod;

    public PutJobCompletedNotificationRegistrationSpectraS3Request(String notificationEndPoint) {
        super(notificationEndPoint);
    }

    public PutJobCompletedNotificationRegistrationSpectraS3Request withFormat(HttpResponseFormatType format) {
        this.format = format;
        this.updateQueryParam("format", format);
        return this;
    }

    public PutJobCompletedNotificationRegistrationSpectraS3Request withJobId(UUID jobId) {
        this.jobId = jobId.toString();
        this.updateQueryParam("job_id", jobId);
        return this;
    }

    public PutJobCompletedNotificationRegistrationSpectraS3Request withJobId(String jobId) {
        this.jobId = jobId;
        this.updateQueryParam("job_id", jobId);
        return this;
    }

    public PutJobCompletedNotificationRegistrationSpectraS3Request withNamingConvention(NamingConventionType namingConvention) {
        this.namingConvention = namingConvention;
        this.updateQueryParam("naming_convention", namingConvention);
        return this;
    }

    public PutJobCompletedNotificationRegistrationSpectraS3Request withNotificationHttpMethod(RequestType notificationHttpMethod) {
        this.notificationHttpMethod = notificationHttpMethod;
        this.updateQueryParam("notification_http_method", notificationHttpMethod);
        return this;
    }

    @Override
    public String getPath() {
        return "/_rest_/job_completed_notification_registration";
    }

    public HttpResponseFormatType getFormat() {
        return this.format;
    }

    public String getJobId() {
        return this.jobId;
    }

    public NamingConventionType getNamingConvention() {
        return this.namingConvention;
    }

    public RequestType getNotificationHttpMethod() {
        return this.notificationHttpMethod;
    }
}

